/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.enums;

public enum ConnectionType {
    UDP(1, 7600),
    TCP(2, 7500),
    HTTP(3, 80),
    HTTPSTREAM(4, 80),
    LISTEN_UDP(11, 7600),
    LISTEN_TCP(12, 80),
    WS(13, 80),
    WSS(14, 80);

    public final int code;
    public final int port;

    private ConnectionType(int code, int port) {
        this.code = code;
        this.port = port;
    }

    public static final ConnectionType of(String typeName) {
        for (ConnectionType known : ConnectionType.values()) {
            if (!known.name().equalsIgnoreCase(typeName)) continue;
            return known;
        }
        return TCP;
    }
}

