/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.util.XMLNode;

public class SymbolInfo {
    private final char _baseCode;
    private final String _exchange;
    private final String _name;
    private final String _symbol;
    private final float _pointValue;
    private final int _tickIncrement;
    private final int _unitCode;

    public SymbolInfo(String symbol, String name, String exchange, int unitCode, Float pointValue, int tickIncrement) {
        this(symbol, name, exchange, SymbolInfo.convertUnitCodeInt2DDF(unitCode), pointValue, tickIncrement);
    }

    public SymbolInfo(String symbol, String name, String exchange, char baseCode, Float pointValue, int tickIncrement) {
        this._symbol = symbol;
        this._name = name;
        this._exchange = exchange;
        this._baseCode = baseCode;
        this._unitCode = SymbolInfo.ddfuc2bb(baseCode);
        this._pointValue = pointValue == null ? 1.0f : pointValue.floatValue();
        this._tickIncrement = tickIncrement;
    }

    public char getBaseCode() {
        return this._baseCode;
    }

    public String getExchange() {
        return this._exchange;
    }

    public String getName() {
        return XMLNode.htmlDecode(this._name);
    }

    public float getPointValue() {
        return this._pointValue;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public int getTickIncrement() {
        return this._tickIncrement;
    }

    public int getUnitCode() {
        return this._unitCode;
    }

    public static char convertUnitCodeInt2DDF(int code) {
        switch (code) {
            case -1: {
                return '2';
            }
            case -2: {
                return '3';
            }
            case -3: {
                return '4';
            }
            case -4: {
                return '5';
            }
            case -5: {
                return '6';
            }
            case -6: {
                return '7';
            }
            case 0: {
                return '8';
            }
            case 1: {
                return '9';
            }
            case 2: {
                return 'A';
            }
            case 3: {
                return 'B';
            }
            case 4: {
                return 'C';
            }
            case 5: {
                return 'D';
            }
            case 6: {
                return 'E';
            }
            case 7: {
                return 'F';
            }
        }
        return 'A';
    }

    public static int convertBaseCode2Multiplier(char baseCode) {
        switch (baseCode) {
            case '2': {
                return 8;
            }
            case '3': {
                return 16;
            }
            case '4': {
                return 32;
            }
            case '5': {
                return 64;
            }
            case '6': {
                return 128;
            }
            case '7': {
                return 256;
            }
            case '8': {
                return 1;
            }
            case '9': {
                return 10;
            }
            case 'A': {
                return 100;
            }
            case 'B': {
                return 1000;
            }
            case 'C': {
                return 10000;
            }
            case 'D': {
                return 100000;
            }
            case 'E': {
                return 1000000;
            }
            case 'F': {
                return 10000000;
            }
        }
        return 1;
    }

    public static int ddfuc2bb(char c) {
        if (c == 42) {
            return 0;
        }
        int ival = c;
        if (ival >= 65) {
            ival -= 7;
        }
        if (ival >= 56) {
            return ival - 56;
        }
        switch (c) {
            case 50: {
                return -1;
            }
            case 51: {
                return -2;
            }
            case 52: {
                return -3;
            }
            case 53: {
                return -4;
            }
            case 54: {
                return -5;
            }
            case 55: {
                return -6;
            }
        }
        return 0;
    }
}

