/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.db.Quote;
import com.ddfplus.util.DDFDate;
import com.ddfplus.util.ParserHelper;
import com.ddfplus.util.XMLNode;
import java.io.Serializable;
import java.text.NumberFormat;

public class Session
implements Cloneable,
Serializable {
    static final long serialVersionUID = 2144658854597154180L;
    private static final NumberFormat _numberFormatInstance = NumberFormat.getNumberInstance();
    protected volatile float _blockTrade = 0.0f;
    protected volatile float _close = 0.0f;
    protected volatile float _close2 = 0.0f;
    private DDFDate _day = null;
    protected volatile float _high = 0.0f;
    protected volatile float _low = 0.0f;
    protected volatile float _open = 0.0f;
    protected volatile float _open2 = 0.0f;
    protected volatile int _openInterest = 0;
    private final Quote _parentQuote;
    private volatile float _previous = 0.0f;
    protected volatile char _session;
    protected volatile float _settlement = 0.0f;
    protected volatile long _timestamp = 0L;
    protected volatile int _tradeSize = 0;
    protected volatile long _tradeTimestamp = 0L;
    protected volatile long _volume = 0L;
    protected volatile long _numTrades = 0L;
    protected volatile double _priceVolume = 0.0;
    protected volatile float _vwap = 0.0f;
    static final int LAST_LIMIT = 3;
    private volatile float[] lastArray = new float[3];

    public Session(Quote parent) {
        this(parent, null, '\u0000');
    }

    public Session(Quote parent, DDFDate day, char sessionCode) {
        this._parentQuote = parent;
        this._day = day;
        this._session = sessionCode;
    }

    public Object clone() {
        Session s = new Session(this._parentQuote, this._day, this._session);
        s._blockTrade = this._blockTrade;
        s._close = this._close;
        s._close2 = this._close2;
        s._high = this._high;
        s.lastArray = (float[])this.lastArray.clone();
        s._settlement = this._settlement;
        s._low = this._low;
        s._open = this._open;
        s._open2 = this._open2;
        s._openInterest = this._openInterest;
        s._previous = this._previous;
        s._timestamp = this._timestamp;
        s._tradeSize = this._tradeSize;
        s._tradeTimestamp = this._tradeTimestamp;
        s._volume = this._volume;
        s._numTrades = this._numTrades;
        s._priceVolume = this._priceVolume;
        s._vwap = this._vwap;
        return s;
    }

    public float getBlockTrade() {
        return this._blockTrade;
    }

    public float getClose() {
        return this._close;
    }

    public void setClose(float v) {
        this._close = v;
    }

    public float getClose2() {
        return this._close2;
    }

    public void setClose2(float v) {
        this._close2 = v;
    }

    public long getTimeInMillis() {
        return this._timestamp;
    }

    public DDFDate getDay() {
        return this._day;
    }

    public char getDayCode() {
        if (this._day == null) {
            return '\u0000';
        }
        return this._day.getDayCode();
    }

    public void setDayCode(DDFDate day) {
        this._day = day;
    }

    public void setDayCode(char code) {
        this._day = DDFDate.fromDayCode(code);
    }

    public float getHigh() {
        return this._high;
    }

    public float getLast() {
        return this.lastArray[0];
    }

    public float getLast(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return this.lastArray[index];
            }
        }
        return 0.0f;
    }

    public int getLastSize() {
        return this._tradeSize;
    }

    public float getLow() {
        return this._low;
    }

    public long getNumberOfTrades() {
        return this._numTrades;
    }

    public float getOpen() {
        return this._open;
    }

    public float getOpen2() {
        return this._open2;
    }

    public void setOpen2(float v) {
        this._open2 = v;
    }

    public int getOpenInterest() {
        return this._openInterest;
    }

    public void setOpenInterest(int v) {
        this._openInterest = v;
    }

    public float getPrevious() {
        return this._previous;
    }

    public double getPriceVolume() {
        return this._priceVolume;
    }

    public float getSettlement() {
        return this._settlement;
    }

    public void setSettlement(float f) {
        this._settlement = f;
    }

    public long getTradeTimestamp() {
        return this._tradeTimestamp;
    }

    public void setTradeTimestamp(long ts) {
        this._tradeTimestamp = ts;
    }

    public float getVWAP() {
        return this._vwap;
    }

    public void setLast(float last) {
        this.lastArray[2] = this.lastArray[1];
        this.lastArray[1] = this.lastArray[0];
        this.lastArray[0] = last;
    }

    public void setLastSize(int value) {
        this._tradeSize = value;
    }

    public char getSessionCode() {
        return this._session;
    }

    public void setSessionCode(char code) {
        this._session = code;
    }

    public long getVolume() {
        return this._volume;
    }

    public void fromXMLNode(XMLNode node) {
        String s = node.getAttribute("timestamp");
        if (s != null) {
            this._timestamp = DDFDate.fromDDFString(s).getMillisCST();
        }
        if ((s = node.getAttribute("day")) != null && s.length() > 0) {
            try {
                this._day = DDFDate.fromDayCode(s.charAt(0));
            }
            catch (Exception e) {
                this._day = new DDFDate(this._timestamp);
            }
        }
        if ((s = node.getAttribute("session")) != null && s.length() > 0) {
            this._session = s.charAt(0);
        }
        if ((s = node.getAttribute("timestamp")) != null) {
            this._timestamp = DDFDate.fromDDFString(s).getMillisCST();
        }
        if ((s = node.getAttribute("tradetime")) != null) {
            this._tradeTimestamp = DDFDate.fromDDFString(s).getMillisCST();
        }
        if ((s = node.getAttribute("open")) != null) {
            this._open = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("open2")) != null) {
            this._open2 = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("high")) != null) {
            this._high = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("low")) != null) {
            this._low = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("last")) != null) {
            this.setLast(ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode()));
        }
        if ((s = node.getAttribute("close")) != null) {
            this._close = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("close2")) != null) {
            this._close2 = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("previous")) != null) {
            this._previous = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("settlement")) != null) {
            this._settlement = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("tradesize")) != null) {
            this._tradeSize = ParserHelper.string2int(s);
        }
        if ((s = node.getAttribute("openinterest")) != null) {
            this._openInterest = ParserHelper.string2int(s);
        }
        if ((s = node.getAttribute("volume")) != null) {
            this._volume = ParserHelper.string2int(s);
        }
        if ((s = node.getAttribute("numtrades")) != null) {
            this._numTrades = ParserHelper.string2int(s);
        }
        s = node.getAttribute("pricevolume");
        try {
            if (s != null) {
                this._priceVolume = Double.parseDouble(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = node.getAttribute("vwap");
        try {
            if (s != null && s.length() > 0) {
                this._vwap = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = node.getAttribute("blocktrade");
        if (s != null) {
            this._blockTrade = ParserHelper.string2float(s, this._parentQuote.getSymbolInfo().getBaseCode());
        }
    }

    public void setBlockTrade(float value) {
        this._blockTrade = value;
    }

    public void setHigh(float value) {
        this._high = value;
    }

    public void setLow(float value) {
        this._low = value;
    }

    public void setNumberOfTrades(long value) {
        this._numTrades = value;
    }

    public void setOpen(float value) {
        this._open = value;
    }

    public void setPrevious(float value) {
        this._previous = value;
    }

    public void setPriceVolume(double value) {
        this._priceVolume = value;
    }

    public void setTimeInMillis(long value) {
        this._timestamp = value;
    }

    public void setVolume(long value) {
        this._volume = value;
    }

    public void setVWAP(float value) {
        this._vwap = value;
    }

    public XMLNode toXMLNode() {
        float f;
        int uc = this._parentQuote.getSymbolInfo().getUnitCode();
        XMLNode node = new XMLNode("SESSION");
        if (this._day != null) {
            node.setAttribute("day", "" + this._day.getDayCode());
        }
        if (this._session != '\u0000') {
            node.setAttribute("session", "" + this._session);
        }
        if (this._timestamp > 0L) {
            DDFDate d = new DDFDate(this._timestamp);
            node.setAttribute("timestamp", d.toDDFString());
        }
        if (this._open != 0.0f) {
            node.setAttribute("open", Integer.toString(ParserHelper.float2int(uc, this._open)));
        }
        if (this._open2 != 0.0f) {
            node.setAttribute("open2", Integer.toString(ParserHelper.float2int(uc, this._open2)));
        }
        if (this._high != 0.0f) {
            node.setAttribute("high", Integer.toString(ParserHelper.float2int(uc, this._high)));
        }
        if (this._low != 0.0f) {
            node.setAttribute("low", Integer.toString(ParserHelper.float2int(uc, this._low)));
        }
        if ((f = this.getLast()) != 0.0f) {
            node.setAttribute("last", Integer.toString(ParserHelper.float2int(uc, f)));
        }
        if (this._close != 0.0f) {
            node.setAttribute("close", Integer.toString(ParserHelper.float2int(uc, this._close)));
        }
        if (this._close2 != 0.0f) {
            node.setAttribute("close2", Integer.toString(ParserHelper.float2int(uc, this._close2)));
        }
        if (this._previous != 0.0f) {
            node.setAttribute("previous", Integer.toString(ParserHelper.float2int(uc, this._previous)));
        }
        if (this._settlement != 0.0f) {
            node.setAttribute("settlement", Integer.toString(ParserHelper.float2int(uc, this._settlement)));
        }
        if (this._tradeSize != 0) {
            node.setAttribute("tradesize", "" + this._tradeSize);
        }
        if (this._openInterest != 0) {
            node.setAttribute("openinterest", "" + this._openInterest);
        }
        if (this._volume != 0L) {
            node.setAttribute("volume", "" + this._volume);
        }
        if (this._numTrades > 0L) {
            node.setAttribute("numtrades", "" + this._numTrades);
        }
        if (this._priceVolume != 0.0) {
            node.setAttribute("pricevolume", _numberFormatInstance.format(this._priceVolume));
        }
        if (this._vwap != 0.0f) {
            node.setAttribute("vwap", Integer.toString(ParserHelper.float2int(uc, this._vwap)));
        }
        if (this._blockTrade != 0.0f) {
            node.setAttribute("blocktrade", Integer.toString(ParserHelper.float2int(uc, this._blockTrade)));
        }
        if (this._tradeTimestamp > 0L) {
            DDFDate d = new DDFDate(this._tradeTimestamp);
            node.setAttribute("tradetime", d.toDDFString());
        }
        StringBuilder ticks = new StringBuilder();
        for (int i = 0; i < this.lastArray.length - 1 && this.lastArray[i + 1] != 0.0f; ++i) {
            if (this.lastArray[i] > this.lastArray[i + 1]) {
                ticks.append("+");
                continue;
            }
            if (this.lastArray[i] < this.lastArray[i + 1]) {
                ticks.append("-");
                continue;
            }
            ticks.append(".");
        }
        if (ticks.length() > 0) {
            node.setAttribute("ticks", ticks.toString());
        }
        return node;
    }

    static {
        _numberFormatInstance.setGroupingUsed(false);
        _numberFormatInstance.setMaximumFractionDigits(2);
        _numberFormatInstance.setMinimumFractionDigits(2);
    }
}

