/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.db.Session;
import com.ddfplus.db.SymbolInfo;
import com.ddfplus.enums.MarketConditionType;
import com.ddfplus.messages.DdfMarketBase;
import com.ddfplus.util.DDFDate;
import com.ddfplus.util.ParserHelper;
import com.ddfplus.util.XMLNode;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Quote
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9094149815858170620L;
    private volatile String _ddfExchange = "";
    private final SymbolInfo _symbolInfo;
    private volatile float _ask = 0.0f;
    private volatile int _askSize = 0;
    private volatile float _bid = 0.0f;
    private volatile int _bidSize = 0;
    protected volatile Session _combinedSession = new Session(this);
    protected volatile Session _previousSession = new Session(this);
    private final List<Session> _sessions = new CopyOnWriteArrayList<Session>();
    private volatile char _flag = '\u0000';
    private volatile MarketConditionType _marketCondition = MarketConditionType.NORMAL;
    protected volatile long _lastUpdated = 0L;
    private volatile DdfMarketBase _message = null;
    private volatile char _permission = '\u0000';

    public Quote(SymbolInfo symbolInfo) {
        this._symbolInfo = symbolInfo;
    }

    public Object clone() {
        Quote q = new Quote(this._symbolInfo);
        q._ask = this._ask;
        q._askSize = this._askSize;
        q._bid = this._bid;
        q._bidSize = this._bidSize;
        q._ddfExchange = this._ddfExchange;
        q._flag = this._flag;
        q._lastUpdated = this._lastUpdated;
        q._marketCondition = this._marketCondition;
        q._message = this._message;
        q._permission = this._permission;
        q._combinedSession = (Session)this._combinedSession.clone();
        q._previousSession = (Session)this._previousSession.clone();
        q._sessions.addAll(this._sessions);
        return q;
    }

    public Session createSession(char dayCode, char sessionCode) {
        Session session = this.getSession(dayCode, sessionCode);
        if (session == null) {
            session = new Session(this, DDFDate.fromDayCode(dayCode), sessionCode);
            if (sessionCode == 'R' || sessionCode == 'T') {
                this._sessions.add(session);
            }
        }
        return session;
    }

    public Session createSession(DDFDate date, char sessionCode) {
        char dayCode = date.getDayCode();
        Session session = this.getSession(dayCode, sessionCode);
        if (session == null) {
            session = new Session(this, date, sessionCode);
            if (sessionCode == 'R' || sessionCode == 'T') {
                this._sessions.add(session);
            }
        }
        return session;
    }

    public float getAsk() {
        return this._ask;
    }

    public int getAskSize() {
        return this._askSize;
    }

    public float getBid() {
        return this._bid;
    }

    public int getBidSize() {
        return this._bidSize;
    }

    public float getChange() {
        float last = this._combinedSession.getLast();
        if (last == 0.0f) {
            return 0.0f;
        }
        float prev = this._previousSession.getLast();
        if (prev == 0.0f) {
            return 0.0f;
        }
        return last - prev;
    }

    public Session getCombinedSession() {
        return this._combinedSession;
    }

    public String getDDFExchange() {
        return this._ddfExchange;
    }

    public char getFlag() {
        return this._flag;
    }

    public long getLastUpdated() {
        return this._lastUpdated;
    }

    public MarketConditionType getMarketCondition() {
        return this._marketCondition;
    }

    public DdfMarketBase getMessage() {
        return this._message;
    }

    public char getPermission() {
        return this._permission;
    }

    public Session getPreviousSession() {
        return this._previousSession;
    }

    public Session getSession(char dayCode, char sessionCode) {
        for (Session session : this._sessions) {
            if (session.getDayCode() != dayCode || session.getSessionCode() != sessionCode) continue;
            return session;
        }
        return null;
    }

    public SymbolInfo getSymbolInfo() {
        return this._symbolInfo;
    }

    public void setAsk(float value) {
        this._ask = value;
    }

    public void setAskSize(int value) {
        this._askSize = value;
    }

    public void setBid(float value) {
        this._bid = value;
    }

    public void setBidSize(int value) {
        this._bidSize = value;
    }

    public void setFlag(char value) {
        this._flag = value;
    }

    public void setCombinedSession(Session session) {
        this._combinedSession = session;
    }

    public void setMarketCondition(MarketConditionType value) {
        this._marketCondition = value;
    }

    protected void setMessage(DdfMarketBase message) {
        this._message = message;
        if (this._ddfExchange.length() < 1) {
            this._ddfExchange = "" + this._message.getExchange();
        }
    }

    public void setDDFExchange(String value) {
        this._ddfExchange = value;
    }

    public void setPermission(char c) {
        this._permission = c;
    }

    public void setPreviousSession(Session session) {
        this._previousSession = session;
    }

    public void updateLastUpdated() {
        this._lastUpdated = System.currentTimeMillis();
    }

    public void updateLastUpdated(long millis) {
        this._lastUpdated = millis;
    }

    public String toJSONString() {
        Session session = this._combinedSession;
        Session session_t = this.getSession(this._combinedSession.getDayCode(), 'T');
        StringBuilder sb = new StringBuilder("\"" + this._symbolInfo.getSymbol() + "\": { \"symbol\": \"" + this._symbolInfo.getSymbol() + "\", \"name\": \"" + this._symbolInfo.getName().replaceAll("\"", "\\\\\"") + "\", \"exchange\": \"" + this._symbolInfo.getExchange() + "\", \"basecode\": \"" + this._symbolInfo.getBaseCode() + "\", \"pointvalue\": " + this._symbolInfo.getPointValue() + ", \"tickincrement\": " + this._symbolInfo.getTickIncrement() + ", \"ddfexchange\": " + (String)(this._ddfExchange == null || this._ddfExchange.length() == 0 ? "null" : "\"" + this._ddfExchange + "\""));
        if (session.getDay() != null) {
            sb.append(", \"day\": \"" + session.getDayCode() + "\", \"date\": \"" + LocalDate.from(session.getDay().getDate()).format(DateTimeFormatter.ISO_DATE) + "\"");
        }
        sb.append(", \"flag\": " + (String)(this._flag != '\u0000' ? "\"" + this._flag + "\"" : "null") + ", \"lastupdate\": " + new DDFDate(this._lastUpdated).toDDFString());
        sb.append(", \"bid\": " + (this._bid == 0.0f ? "null" : ParserHelper.float2string(this._bid, this._symbolInfo.getBaseCode(), 3)) + ", \"bidsize\": " + (Serializable)(this._bidSize == 0 ? "null" : Integer.valueOf(this._bidSize * 100)) + ", \"ask\": " + (this._ask == 0.0f ? "null" : ParserHelper.float2string(this._ask, this._symbolInfo.getBaseCode(), 3)) + ", \"asksize\": " + (Serializable)(this._askSize == 0 ? "null" : Integer.valueOf(this._askSize * 100)));
        sb.append(", \"open\": " + (session.getOpen() == 0.0f ? "null" : ParserHelper.float2string(session.getOpen(), this._symbolInfo.getBaseCode(), 3)) + ", \"high\": " + (session.getHigh() == 0.0f ? "null" : ParserHelper.float2string(session.getHigh(), this._symbolInfo.getBaseCode(), 3)) + ", \"low\": " + (session.getLow() == 0.0f ? "null" : ParserHelper.float2string(session.getLow(), this._symbolInfo.getBaseCode(), 3)) + ", \"last\": " + (session.getLast() == 0.0f ? "null" : ParserHelper.float2string(session.getLast(), this._symbolInfo.getBaseCode(), 3)) + ", \"last2\": " + (session.getLast(1) == 0.0f ? "null" : ParserHelper.float2string(session.getLast(1), this._symbolInfo.getBaseCode(), 3)) + ", \"last3\": " + (session.getLast(2) == 0.0f ? "null" : ParserHelper.float2string(session.getLast(2), this._symbolInfo.getBaseCode(), 3)) + ", \"last_t\": " + (session_t != null && session_t.getLast() != 0.0f ? ParserHelper.float2string(session_t.getLast(), this._symbolInfo.getBaseCode(), 3) : "null") + ", \"lastsize\": " + (Serializable)(session.getLastSize() == 0 ? "null" : Integer.valueOf(session.getLastSize())) + ", \"tradetimestamp\": " + session.getTradeTimestamp() + ", \"settlement\": " + (session.getSettlement() == 0.0f ? "null" : ParserHelper.float2string(session.getSettlement(), this._symbolInfo.getBaseCode(), 3)) + ", \"previous\": " + (session.getPrevious() == 0.0f ? "null" : ParserHelper.float2string(session.getPrevious(), this._symbolInfo.getBaseCode(), 3)) + ", \"volume\": " + (Serializable)(session.getVolume() == 0L ? "null" : Long.valueOf(session.getVolume())) + ", \"openinterest\": " + (Serializable)(session.getOpenInterest() == 0 ? "null" : Integer.valueOf(session.getOpenInterest())) + ", \"numtrades\": " + session.getNumberOfTrades() + ", \"pricevolume\": " + ParserHelper.float2string(session.getPriceVolume(), 'A', 3, false) + ", \"timestamp\": " + session.getTimeInMillis());
        if (session_t != null && session_t.getLast() != 0.0f) {
            sb.append(", \"t_session\" : { ");
            sb.append("\"last\": " + ParserHelper.float2string(session_t.getLast(), this._symbolInfo.getBaseCode(), 3));
            sb.append(", \"lastsize\": " + (Serializable)(session_t.getLastSize() == 0 ? "null" : Integer.valueOf(session_t.getLastSize())));
            sb.append(", \"tradetimestamp\": " + session_t.getTradeTimestamp());
            sb.append(", \"timestamp\": " + session_t.getTimeInMillis());
            sb.append("}");
        }
        Session previous_session = this._previousSession;
        sb.append(", \"previous_session\": { ");
        sb.append("\"last\": " + (previous_session.getLast() == 0.0f ? "null" : ParserHelper.float2string(previous_session.getLast(), this._symbolInfo.getBaseCode(), 3)));
        sb.append((String)(previous_session.getOpen() == 0.0f ? "" : ",\"open\": " + ParserHelper.float2string(previous_session.getOpen(), this._symbolInfo.getBaseCode(), 3)));
        sb.append((String)(previous_session.getHigh() == 0.0f ? "" : ",\"high\": " + ParserHelper.float2string(previous_session.getHigh(), this._symbolInfo.getBaseCode(), 3)));
        sb.append((String)(previous_session.getLow() == 0.0f ? "" : ",\"low\": " + ParserHelper.float2string(previous_session.getLow(), this._symbolInfo.getBaseCode(), 3)));
        sb.append((String)(previous_session.getPrevious() == 0.0f ? "" : ",\"previous\": " + ParserHelper.float2string(previous_session.getPrevious(), this._symbolInfo.getBaseCode(), 3)));
        sb.append((String)(previous_session.getVolume() == 0L ? "" : ",\"volume\": " + previous_session.getVolume()));
        sb.append((String)(previous_session.getOpenInterest() == 0 ? "" : ",\"openinterest\": " + previous_session.getOpenInterest()));
        sb.append(",\"day\": " + (String)(previous_session.getDayCode() == '\u0000' ? "null" : "\"" + previous_session.getDayCode() + "\""));
        sb.append(",\"date\": " + (String)(previous_session.getDay() == null ? "null" : "\"" + LocalDate.from(previous_session.getDay().getDate()).format(DateTimeFormatter.ISO_DATE) + "\""));
        sb.append(" }");
        sb.append("}");
        return sb.toString();
    }

    public XMLNode toXMLNode() {
        return this.toXMLNode(true);
    }

    public XMLNode toXMLNode(boolean showBidAsk) {
        XMLNode node = new XMLNode("QUOTE");
        node.setAttribute("symbol", this._symbolInfo.getSymbol());
        node.setAttribute("name", this._symbolInfo.getName());
        node.setAttribute("exchange", this._symbolInfo.getExchange());
        node.setAttribute("basecode", "" + this._symbolInfo.getBaseCode());
        node.setAttribute("pointvalue", "" + this._symbolInfo.getPointValue());
        node.setAttribute("tickincrement", "" + this._symbolInfo.getTickIncrement());
        if (this._ddfExchange != null && this._ddfExchange.length() > 0) {
            node.setAttribute("ddfexchange", this._ddfExchange);
        }
        if (this._flag != '\u0000') {
            node.setAttribute("flag", "" + this._flag);
        }
        if (this._marketCondition != MarketConditionType.NORMAL) {
            node.setAttribute("marketcondition", "" + this._marketCondition.getCode());
        }
        if (this._lastUpdated > 0L) {
            node.setAttribute("lastupdate", new DDFDate(this._lastUpdated).toDDFString());
        }
        if (showBidAsk) {
            if (this._bid != 0.0f) {
                node.setAttribute("bid", Integer.toString(ParserHelper.float2int(this._symbolInfo.getUnitCode(), this._bid)));
            }
            if (this._bidSize != 0) {
                node.setAttribute("bidsize", "" + this._bidSize);
            }
            if (this._ask != 0.0f) {
                node.setAttribute("ask", Integer.toString(ParserHelper.float2int(this._symbolInfo.getUnitCode(), this._ask)));
            }
            if (this._askSize != 0) {
                node.setAttribute("asksize", "" + this._askSize);
            }
        }
        XMLNode n1 = this._combinedSession.toXMLNode();
        n1.setAttribute("id", "combined");
        node.addNode(n1);
        XMLNode n2 = this._previousSession.toXMLNode();
        n2.setAttribute("id", "previous");
        node.addNode(n2);
        for (Session session : this._sessions) {
            XMLNode n = session.toXMLNode();
            n.setAttribute("id", "session_" + n.getAttribute("day") + "_" + n.getAttribute("session"));
            node.addNode(n);
        }
        return node;
    }

    public static Quote fromXMLNode(XMLNode node) {
        if (!node.getName().equals("QUOTE")) {
            return null;
        }
        Quote qte = new Quote(new SymbolInfo(node.getAttribute("symbol"), node.getAttribute("name"), node.getAttribute("exchange"), node.getAttribute("basecode").charAt(0), Float.valueOf(node.getAttribute("pointvalue") != null ? Float.parseFloat(node.getAttribute("pointvalue")) : 1.0f), node.getAttribute("tickincrement") != null ? Integer.parseInt(node.getAttribute("tickincrement")) : 1));
        String s = node.getAttribute("ddfexchange");
        if (s != null) {
            qte._ddfExchange = node.getAttribute("ddfexchange");
        }
        if ((s = node.getAttribute("flag")) != null && s.length() > 0) {
            qte._flag = s.charAt(0);
        }
        if ((s = node.getAttribute("marketcondition")) != null && s.length() > 0) {
            qte._marketCondition = MarketConditionType.getByCode(s.charAt(0));
        }
        if ((s = node.getAttribute("bid")) != null) {
            qte._bid = ParserHelper.string2float(s, qte.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("bidsize")) != null) {
            qte._bidSize = ParserHelper.string2int(s);
        }
        if ((s = node.getAttribute("ask")) != null) {
            qte._ask = ParserHelper.string2float(s, qte.getSymbolInfo().getBaseCode());
        }
        if ((s = node.getAttribute("asksize")) != null) {
            qte._askSize = ParserHelper.string2int(s);
        }
        if ((s = node.getAttribute("mode")) != null) {
            qte._permission = s.charAt(0);
        }
        if ((s = node.getAttribute("lastupdate")) != null && s.length() > 0) {
            qte._lastUpdated = DDFDate.fromDDFString(s).getMillisCST();
        }
        for (XMLNode n : node.getAllNodes("SESSION")) {
            Session session = new Session(qte);
            session.fromXMLNode(n);
            if (n.getAttribute("id").equals("combined")) {
                qte._combinedSession = session;
                continue;
            }
            if (n.getAttribute("id").equals("previous")) {
                qte._previousSession = session;
                continue;
            }
            qte._sessions.add(session);
        }
        return qte;
    }

    public boolean isTick() {
        return this._message.getQuoteType().isTick();
    }

    public boolean isRefresh() {
        return this._message.getQuoteType().isRefresh();
    }
}

