/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.util.DDFDate;
import com.ddfplus.util.ParserHelper;
import com.ddfplus.util.XMLNode;

public class Ohlc {
    private String _exchange;
    private final String _symbol;
    private char _day;
    private int _interval = 0;
    private long _time = 0L;
    private char _baseCode = '\u0000';
    private float _open = 0.0f;
    private float _high = 0.0f;
    private float _low = 0.0f;
    private float _close = 0.0f;
    private int _volume = 0;

    public Ohlc(String symbol) {
        this._symbol = symbol;
    }

    public String getExchange() {
        return this._exchange;
    }

    public void setExchange(String exchange) {
        this._exchange = exchange;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public char getDay() {
        return this._day;
    }

    public int getInterval() {
        return this._interval;
    }

    public long getTime() {
        return this._time;
    }

    public char getBaseCode() {
        return this._baseCode;
    }

    public float getOpen() {
        return this._open;
    }

    public float getHigh() {
        return this._high;
    }

    public float getLow() {
        return this._low;
    }

    public float getClose() {
        return this._close;
    }

    public int getVolume() {
        return this._volume;
    }

    public void setDay(char _day) {
        this._day = _day;
    }

    public void setInterval(int _interval) {
        this._interval = _interval;
    }

    public void setTime(long _time) {
        this._time = _time;
    }

    public void setBaseCode(char _baseCode) {
        this._baseCode = _baseCode;
    }

    public void setOpen(float _open) {
        this._open = _open;
    }

    public void setHigh(float _high) {
        this._high = _high;
    }

    public void setLow(float _low) {
        this._low = _low;
    }

    public void setClose(float _close) {
        this._close = _close;
    }

    public void setVolume(int _volume) {
        this._volume = _volume;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._exchange != null) {
            sb.append("exch=" + this._exchange + ";");
        }
        sb.append(this._symbol + ";");
        sb.append("day=" + this._day + ";");
        sb.append("time=" + new DDFDate(this._time).toDDFString() + ";");
        sb.append("baseCode=" + this._baseCode + ";");
        sb.append("open=" + this._open + ";");
        sb.append("high=" + this._high + ";");
        sb.append("low=" + this._low + ";");
        sb.append("close=" + this._close + ";");
        sb.append("volume=" + this._volume + ";");
        return sb.toString();
    }

    public static final Ohlc fromXMLNode(XMLNode node) {
        if (!node.getName().equals("ohlc")) {
            return null;
        }
        Ohlc ohlc = new Ohlc(node.getAttribute("symbol"));
        ohlc._day = node.getAttribute("day").charAt(0);
        ohlc._baseCode = node.getAttribute("basecode").charAt(0);
        ohlc._interval = Integer.parseInt(node.getAttribute("interval"));
        String v = node.getAttribute("time");
        if (v != null && v.length() > 0) {
            ohlc._time = DDFDate.fromDDFStringOhlc(v).getMillisCST();
        }
        ohlc._open = ParserHelper.string2float(node.getAttribute("open"), ohlc._baseCode);
        ohlc._high = ParserHelper.string2float(node.getAttribute("high"), ohlc._baseCode);
        ohlc._low = ParserHelper.string2float(node.getAttribute("low"), ohlc._baseCode);
        ohlc._close = ParserHelper.string2float(node.getAttribute("close"), ohlc._baseCode);
        ohlc._volume = Integer.parseInt(node.getAttribute("volume"));
        return ohlc;
    }
}

