/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.messages.DdfMarketBase;

public class MarketEvent {
    private MarketEventType type;
    private float open;
    private float high;
    private float low;
    private float close;
    private float preSettlement;
    private float settlement;
    private String symbol;
    private DdfMarketBase ddfMessage;

    public MarketEvent(MarketEventType eventType) {
        this.type = eventType;
    }

    public MarketEventType getEventType() {
        return this.type;
    }

    public void setEventType(MarketEventType type) {
        this.type = type;
    }

    public float getOpen() {
        return this.open;
    }

    public void setOpen(float f) {
        this.open = f;
    }

    public float getClose() {
        return this.close;
    }

    public void setClose(float f) {
        this.close = f;
    }

    public float getSettlement() {
        return this.settlement;
    }

    public void setSettlement(float f) {
        this.settlement = f;
    }

    public float getPreSettlement() {
        return this.preSettlement;
    }

    public void setPreSettlement(float f) {
        this.preSettlement = f;
    }

    public float getHigh() {
        return this.high;
    }

    public void setHigh(float f) {
        this.high = f;
    }

    public float getLow() {
        return this.low;
    }

    public void setLow(float f) {
        this.low = f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MarketEvent(" + this.ddfMessage.getRecord() + this.ddfMessage.getSubRecord() + "): ");
        sb.append("type: " + this.type + " ");
        switch (this.type) {
            case PreOpen: {
                break;
            }
            case Open: {
                break;
            }
            case High: {
                sb.append("high: " + this.high);
                break;
            }
            case Low: {
                sb.append("low: " + this.low);
                break;
            }
            case Close: {
                sb.append("close: " + this.close);
                break;
            }
            case PreSettlement: {
                sb.append("preSettlement: " + this.preSettlement);
                break;
            }
            case Settlement: {
                sb.append("settlement: " + this.settlement);
                break;
            }
        }
        if (this.symbol != null) {
            sb.append(" symbol: " + this.symbol);
        }
        if (this.ddfMessage != null) {
            sb.append(" DDF: " + this.ddfMessage);
        }
        return sb.toString();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setDdfMessage(DdfMarketBase msg) {
        this.ddfMessage = msg;
    }

    public DdfMarketBase getDdfMessage() {
        return this.ddfMessage;
    }

    public static enum MarketEventType {
        PreOpen,
        Open,
        High,
        Low,
        Close,
        PreSettlement,
        Settlement,
        TradingHalt,
        TradingResumption;

    }
}

