/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.codec.Codec;
import com.ddfplus.db.BookQuote;
import com.ddfplus.db.CumulativeVolume;
import com.ddfplus.db.FeedEvent;
import com.ddfplus.db.MarketEvent;
import com.ddfplus.db.MasterType;
import com.ddfplus.db.Ohlc;
import com.ddfplus.db.Quote;
import com.ddfplus.db.Session;
import com.ddfplus.enums.DdfRecord;
import com.ddfplus.enums.DdfSessionCode;
import com.ddfplus.enums.DdfSubRecord;
import com.ddfplus.enums.MarketConditionType;
import com.ddfplus.enums.QuoteElement;
import com.ddfplus.enums.QuoteElementModifiers;
import com.ddfplus.messages.DdfMarketBase;
import com.ddfplus.messages.DdfMarketBidAsk;
import com.ddfplus.messages.DdfMarketCondition;
import com.ddfplus.messages.DdfMarketDepth;
import com.ddfplus.messages.DdfMarketParameter;
import com.ddfplus.messages.DdfMarketRefresh;
import com.ddfplus.messages.DdfMarketRefreshXML;
import com.ddfplus.messages.DdfMarketTrade;
import com.ddfplus.messages.DdfTimestamp;
import com.ddfplus.service.feed.FeedService;
import com.ddfplus.util.DDFDate;
import com.ddfplus.util.XMLNode;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMaster {
    private static final Logger log = LoggerFactory.getLogger(DataMaster.class);
    private final Map<String, BookQuote> bookMap;
    private final Map<String, CumulativeVolume> _cumulativeVolumeTable;
    private final Map<String, Quote> quoteMap;
    private final Map<String, Long> unrecoginzedSymbols;
    private volatile long millisCST = 0L;
    private final MasterType _type;
    private FeedService feedService;

    public DataMaster(MasterType type) {
        this._type = type;
        this.bookMap = new ConcurrentHashMap<String, BookQuote>();
        this._cumulativeVolumeTable = new ConcurrentHashMap<String, CumulativeVolume>();
        this.quoteMap = new ConcurrentHashMap<String, Quote>();
        this.unrecoginzedSymbols = new ConcurrentHashMap<String, Long>();
    }

    public FeedEvent processMessage(byte[] message) {
        if (message == null || message.length < 2) {
            return null;
        }
        DdfMarketBase msg = Codec.parseMessage(message);
        if (msg == null) {
            log.error("DataMaster.processMessage(" + new String(message) + ") failed.");
            return null;
        }
        return this.processMessage(msg);
    }

    public FeedEvent processMessage(DdfMarketBase msg) {
        if (msg == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("processMessage: " + msg);
        }
        FeedEvent fe = new FeedEvent();
        fe.setDdfMessage(msg);
        if (this._type == MasterType.EndOfDay) {
            return fe;
        }
        if (msg.getSymbol() != null && msg.getSymbol().length() > 0) {
            String s = msg.getSymbol();
            Quote quote = this.getQuote(s);
            if (quote == null) {
                this.unrecoginzedSymbols.put(s, System.currentTimeMillis());
            } else if (this.unrecoginzedSymbols.containsKey(s)) {
                this.unrecoginzedSymbols.remove(s);
            }
        }
        if (msg.getRecord() == DdfRecord.Timestamp.value()) {
            this.millisCST = ((DdfTimestamp)((Object)msg)).getMillisCST();
            Date d = new Date(this.millisCST);
            fe.setDate(d);
        } else if (msg.getRecord() != DdfRecord.RefreshOld.value()) {
            if (msg.getRecord() == DdfRecord.RefreshXml.value()) {
                this.recordX_marketRefresh(msg, fe);
            } else {
                if (msg.getRecord() == '2' || msg.getRecord() == 'C') {
                    Quote quote;
                    if (msg instanceof DdfMarketTrade) {
                        fe.setTrade((DdfMarketTrade)msg);
                    }
                    if ((quote = this.getQuote(msg.getSymbol())) == null) {
                        if (this.feedService != null) {
                            this.feedService.scheduleQuoteRefresh(msg.getSymbol());
                        }
                        return fe;
                    }
                    this.record2_liveprices(msg, quote, fe);
                    fe.setQuote(quote);
                    return fe;
                }
                if (msg.getRecord() == DdfRecord.DepthEndOfDay.value()) {
                    BookQuote b = this.record3_book_eod(msg);
                    fe.setBook(b);
                } else {
                    log.warn("Unrecognized DDF Message: " + msg);
                }
            }
        }
        return fe;
    }

    public BookQuote getBookQuote(String symbol) {
        if (symbol == null) {
            return null;
        }
        BookQuote bookQoute = this.bookMap.get(symbol);
        return bookQoute;
    }

    public CumulativeVolume getCumulativeVolume(String symbol) {
        CumulativeVolume cv = this._cumulativeVolumeTable.get(symbol);
        return cv;
    }

    public Quote getQuote(String symbol) {
        if (symbol == null) {
            return null;
        }
        Quote quote = this.quoteMap.get(symbol);
        return quote;
    }

    public int[] getSizes() {
        return new int[]{this.quoteMap.size(), this.bookMap.size(), this._cumulativeVolumeTable.size()};
    }

    public long getMillisCST() {
        return this.millisCST;
    }

    public void putQuote(Quote q) {
        this.quoteMap.put(q.getSymbolInfo().getSymbol(), q);
    }

    public void putBookQuote(BookQuote q) {
        this.bookMap.put(q.getSymbol(), q);
    }

    public void putCumulativeVolume(CumulativeVolume cv) {
        this._cumulativeVolumeTable.put(cv.getSymbol(), cv);
    }

    public MasterType getMasterType() {
        return this._type;
    }

    public void clearDataCache() {
        this._cumulativeVolumeTable.clear();
        this.bookMap.clear();
        this.quoteMap.clear();
        this.millisCST = 0L;
    }

    public void setFeedService(FeedService feedService) {
        this.feedService = feedService;
    }

    void recordX_marketRefresh(DdfMarketBase msg, FeedEvent fe) {
        DdfMarketRefreshXML message = (DdfMarketRefreshXML)msg;
        XMLNode node = message.getXMLNode();
        if (node.getName().equals("QUOTE")) {
            Quote quote = this.handleRefreshQuote(msg, node);
            fe.setQuote(quote);
        } else if (node.getName().equals("BOOK")) {
            BookQuote bookQuote = this.handleBookQuoteRefresh(node);
            fe.setBook(bookQuote);
        } else if (node.getName().equals("CV")) {
            CumulativeVolume volume = this.handleRefreshCumlativeVolume(node);
            fe.setCumVolume(volume);
        } else if (node.getName().equals("ohlc")) {
            Ohlc ohlc = Ohlc.fromXMLNode(node);
            fe.setOhlc(ohlc);
        } else {
            log.error("wrong refresh message type: {}", (Object)node.getName());
        }
    }

    void record2_liveprices(DdfMarketBase msg, Quote quote, FeedEvent fe) {
        int day2_dayFromMessage;
        int day1_dayFromCurrentQuoteSession;
        quote.updateLastUpdated();
        quote.setMessage(msg);
        boolean bDoNotSetFlag = false;
        CumulativeVolume cv = this.getCumulativeVolume(msg.getSymbol());
        Session pCombinedSession = null;
        Session pPreviousSession = null;
        if (quote._combinedSession.getDayCode() == '\u0000') {
            quote._combinedSession.setDayCode(msg.getDay());
        }
        if ((day1_dayFromCurrentQuoteSession = DDFDate.convertDayCodeToNumber(quote._combinedSession.getDayCode())) == (day2_dayFromMessage = DDFDate.convertDayCodeToNumber(msg.getDay()))) {
            pCombinedSession = quote._combinedSession;
            pPreviousSession = quote._previousSession;
        } else if (msg.getDay() == quote._previousSession.getDayCode()) {
            pCombinedSession = quote._previousSession;
            pPreviousSession = new Session(quote);
            bDoNotSetFlag = true;
            if (log.isDebugEnabled()) {
                log.debug("Previous session: " + msg);
            }
        } else if (day2_dayFromMessage > day1_dayFromCurrentQuoteSession || day1_dayFromCurrentQuoteSession - day2_dayFromMessage > 5) {
            if (quote._combinedSession.getLast() == 0.0f) {
                if (log.isDebugEnabled()) {
                    log.debug("New session, last == 0: " + msg);
                }
                pCombinedSession = quote._combinedSession;
                pPreviousSession = quote._previousSession;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("New session, last > 0: " + msg);
                }
                Session pPrevious = quote._previousSession;
                quote._previousSession = quote._combinedSession;
                quote._combinedSession = new Session(quote, DDFDate.fromDayCode(msg.getDay()), msg.getSession());
                quote.setFlag('p');
                MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.PreOpen, quote.getSymbolInfo().getSymbol());
                if (log.isDebugEnabled()) {
                    log.debug(me.toString());
                }
                quote._combinedSession._open = 0.0f;
                quote._combinedSession._high = 0.0f;
                quote._combinedSession._low = 0.0f;
                quote._combinedSession.setPrevious(quote._previousSession.getLast());
                if (quote._previousSession.getOpenInterest() == 0) {
                    quote._previousSession._openInterest = pPrevious._openInterest;
                }
                pCombinedSession = quote._combinedSession;
                pPreviousSession = quote._previousSession;
                if (cv != null) {
                    DDFDate d = DDFDate.fromDayCode(msg.getDay());
                    cv.setDate(d.getMillisCST());
                    cv.getData().clear();
                }
            }
        } else {
            return;
        }
        pCombinedSession._session = msg.getSession();
        Session session = quote.createSession(msg.getDay(), msg.getSession());
        if (session == pCombinedSession) {
            session = null;
        }
        if (session != null && session.getPrevious() == 0.0f) {
            session.setPrevious(pCombinedSession.getPrevious());
        }
        if (msg instanceof DdfMarketParameter) {
            this.record2_subrecord0(msg, fe, quote, bDoNotSetFlag, pCombinedSession, pPreviousSession, session);
        } else if (msg instanceof DdfMarketRefresh) {
            this.record2_subrecord12346(msg, fe, quote, bDoNotSetFlag, pCombinedSession, pPreviousSession, session);
        } else if (msg instanceof DdfMarketTrade && msg.getSession() == 'T') {
            Session s2 = quote.createSession(pCombinedSession.getDayCode(), 'T');
            this.record2_subrecord7T(msg, pCombinedSession, s2, session);
        } else if (msg instanceof DdfMarketTrade) {
            this.record2_subrecord7Z(msg, quote, bDoNotSetFlag, cv, pCombinedSession, session);
        } else if (msg instanceof DdfMarketBidAsk) {
            this.record2_subrecord8(msg, quote, pCombinedSession, session);
        } else if (msg instanceof DdfMarketCondition) {
            MarketConditionType marketConditon = ((DdfMarketCondition)msg).getMarketCondition();
            quote.setMarketCondition(marketConditon);
            if (marketConditon == MarketConditionType.TRADING_HALT) {
                this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.TradingHalt, quote.getSymbolInfo().getSymbol());
            } else if (marketConditon == MarketConditionType.TRADING_RESUMTPION) {
                this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.TradingResumption, quote.getSymbolInfo().getSymbol());
            }
        }
    }

    void record2_subrecord0(DdfMarketBase msg, FeedEvent fe, Quote quote, boolean bDoNotSetFlag, Session pCombinedSession, Session pPreviousSession, Session session) {
        DdfMarketParameter msg20 = (DdfMarketParameter)msg;
        boolean bUpdateTimestamp = true;
        char element = msg20.getElement();
        char modifier = msg20.getModifier();
        float f = msg20.getValueAsFloat();
        int i = msg20.getValueAsInteger();
        if (msg20.getValueAsFloat() == 0.0f && msg20.getValueAsInteger() == 0) {
            return;
        }
        if (element == QuoteElement.Trade.value() && (modifier == QuoteElementModifiers.Last.value() || modifier == QuoteElementModifiers.Ask.value() || modifier == QuoteElementModifiers.Bid.value())) {
            if (session != null) {
                session.setLast(f);
            }
            pCombinedSession.setLast(f);
            if (modifier == QuoteElementModifiers.Last.value()) {
                if (msg.getMillisCST() > 0L) {
                    if (session != null) {
                        session._tradeTimestamp = msg.getMillisCST();
                    }
                    pCombinedSession._tradeTimestamp = msg.getMillisCST();
                } else {
                    if (session != null) {
                        session._tradeTimestamp = this.determineTimestamp(msg);
                    }
                    pCombinedSession._tradeTimestamp = this.determineTimestamp(msg);
                }
                if (!bDoNotSetFlag) {
                    quote.setFlag('\u0000');
                }
            }
        } else if (element == QuoteElement.Trade.value() && modifier == QuoteElementModifiers.BidSize.value()) {
            quote.setBidSize(i);
            if (this._type == MasterType.Realtime) {
                bUpdateTimestamp = false;
            }
        } else if (element == QuoteElement.Trade.value() && modifier == QuoteElementModifiers.AskSize.value()) {
            quote.setAskSize(i);
            if (this._type == MasterType.Realtime) {
                bUpdateTimestamp = false;
            }
        } else if (element == QuoteElement.Trade.value() && modifier == QuoteElementModifiers.TradeSize.value()) {
            if (session != null) {
                session._tradeSize = i;
                session._volume += (long)i;
            }
            pCombinedSession._tradeSize = i;
            pCombinedSession._volume += (long)i;
        } else if (element == QuoteElement.Ask.value()) {
            if (f == 0.0f) {
                quote.setAsk(0.0f);
                quote.setAskSize(0);
            } else {
                quote.setAsk(f);
            }
            if (this._type != MasterType.Realtime) {
                bUpdateTimestamp = false;
            }
        } else if (element == QuoteElement.Bid.value()) {
            if (f == 0.0f) {
                quote.setBid(0.0f);
                quote.setBidSize(0);
            } else {
                quote.setBid(f);
            }
            if (this._type != MasterType.Realtime) {
                bUpdateTimestamp = false;
            }
        } else if (element == QuoteElement.Close.value()) {
            if (session != null) {
                session.setLast(f);
                session._close = f;
            }
            pCombinedSession.setLast(f);
            pCombinedSession._close = f;
            if (!bDoNotSetFlag) {
                quote.setFlag('c');
            }
            if (modifier == QuoteElementModifiers.Ask.value()) {
                quote.setAsk(f);
            } else if (modifier == QuoteElementModifiers.Bid.value()) {
                quote.setBid(f);
            }
            MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Close, quote.getSymbolInfo().getSymbol());
            me.setClose(f);
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        } else if (element == QuoteElement.Close2.value()) {
            if (!bDoNotSetFlag) {
                quote.setFlag('c');
            }
            if (session != null) {
                session.setLast(f);
                session._close2 = f;
            }
            pCombinedSession.setLast(f);
            pCombinedSession._close2 = f;
            if (modifier == QuoteElementModifiers.Ask.value()) {
                quote.setAsk(f);
            } else if (modifier == QuoteElementModifiers.Bid.value()) {
                quote.setBid(f);
            }
        } else if (element == QuoteElement.OpenInterest.value() && modifier == QuoteElementModifiers.Ask.value()) {
            pCombinedSession._openInterest = i;
            bUpdateTimestamp = false;
        } else if (element == QuoteElement.Settlement.value() && modifier == QuoteElementModifiers.Last.value()) {
            if (!bDoNotSetFlag) {
                quote.setFlag('s');
            }
            if (session != null) {
                session.setLast(f);
                session._settlement = f;
            }
            pCombinedSession.setLast(f);
            pCombinedSession._settlement = f;
            MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Settlement, quote.getSymbolInfo().getSymbol());
            me.setSettlement(f);
            quote.setMarketCondition(MarketConditionType.NORMAL);
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        } else if (element == QuoteElement.SettlementDuringMarketTrading.value() && modifier == QuoteElementModifiers.Last.value()) {
            if (session != null) {
                session._settlement = f;
            }
            pCombinedSession._settlement = f;
            MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.PreSettlement, quote.getSymbolInfo().getSymbol());
            me.setPreSettlement(f);
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        } else if (element == QuoteElement.VWAP.value() && modifier == QuoteElementModifiers.Last.value()) {
            if (session != null) {
                session._vwap = f;
            }
            pCombinedSession._vwap = f;
        } else if (element == QuoteElement.High.value()) {
            if (session != null) {
                session._high = f;
            }
            pCombinedSession._high = f;
            MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.High, quote.getSymbolInfo().getSymbol());
            me.setHigh(f);
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        } else if (element == QuoteElement.Low.value()) {
            if (session != null) {
                session._low = f;
            }
            pCombinedSession._low = f;
            MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Low, quote.getSymbolInfo().getSymbol());
            me.setLow(f);
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        } else if (element == QuoteElement.Volume.value() && modifier == QuoteElementModifiers.Ask.value()) {
            pPreviousSession._volume = i;
            bUpdateTimestamp = false;
        } else if (element == QuoteElement.Volume.value() && modifier == QuoteElementModifiers.CumulativeVolume.value()) {
            if (session != null) {
                session._volume = i;
            }
            pCombinedSession._volume = i;
        } else if (element == QuoteElement.Open.value()) {
            if (!bDoNotSetFlag) {
                quote.setFlag('\u0000');
            }
            if (pCombinedSession._open == 0.0f) {
                if (session != null) {
                    if (session.getHigh() == 0.0f && session.getLow() == 0.0f && session.getLast() == 0.0f) {
                        session.setLast(f);
                        session._open = f;
                        session._high = f;
                        session._low = f;
                    } else {
                        session._open = f;
                    }
                }
                if (pCombinedSession.getHigh() == 0.0f && pCombinedSession.getLow() == 0.0f && pCombinedSession.getLast() == 0.0f) {
                    pCombinedSession.setLast(f);
                    pCombinedSession._open = f;
                    pCombinedSession._high = f;
                    pCombinedSession._low = f;
                } else {
                    pCombinedSession._open = f;
                }
                MarketEvent me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Open, quote.getSymbolInfo().getSymbol());
                me.setOpen(f);
                quote.setMarketCondition(MarketConditionType.NORMAL);
                if (log.isDebugEnabled()) {
                    log.debug(me.toString());
                }
            }
        } else if (element == QuoteElement.Previous.value()) {
            pPreviousSession.setLast(f);
            pPreviousSession._settlement = f;
            if (session != null) {
                session.setPrevious(f);
            }
            pCombinedSession.setPrevious(f);
            if (this._type == MasterType.Delayed) {
                Calendar c = Calendar.getInstance();
                c.setTime(new Date(this.millisCST));
                c.add(12, -1 * quote.getMessage().getDelay());
                pPreviousSession._timestamp = c.getTimeInMillis();
            } else {
                pPreviousSession._timestamp = this.millisCST;
            }
            bUpdateTimestamp = false;
        }
        if (bUpdateTimestamp) {
            if (session != null) {
                session._timestamp = this.determineTimestamp(msg);
            }
            pCombinedSession._timestamp = this.determineTimestamp(msg);
        }
    }

    void record2_subrecord12346(DdfMarketBase msg, FeedEvent fe, Quote quote, boolean bDoNotSetFlag, Session pCombinedSession, Session pPreviousSession, Session session) {
        MarketEvent me;
        boolean bProcessCombined = true;
        boolean clearPreFlag = false;
        if ((msg.getSubRecord() == DdfSubRecord.ExchangeGeneratedRefresh.value() || msg.getSubRecord() == DdfSubRecord.DdfGeneratedUpdatePriceElementsRefresh.value() || msg.getSubRecord() == DdfSubRecord.DdfGeneratedActiveSessionRefresh.value()) && msg.getSession() == DdfSessionCode.CmeGlobexPitSession.value()) {
            bProcessCombined = false;
        }
        DdfMarketRefresh msg21 = (DdfMarketRefresh)msg;
        Float f = null;
        Long l = null;
        if (bProcessCombined) {
            f = msg21.getAsk();
            if (f != null) {
                quote.setAsk(f.floatValue());
                if (f.floatValue() == 0.0f) {
                    quote.setAskSize(0);
                }
            }
            if ((f = msg21.getBid()) != null) {
                quote.setBid(f.floatValue());
                if (f.floatValue() == 0.0f) {
                    quote.setBidSize(0);
                }
            }
        }
        if ((f = msg21.getLast()) != null) {
            if (session != null) {
                session.setLast(f.floatValue());
            }
            if (bProcessCombined) {
                pCombinedSession.setLast(f.floatValue());
                clearPreFlag = true;
            }
        }
        if ((f = msg21.getClose()) != null) {
            if (session != null) {
                session._close = f.floatValue();
                session.setLast(f.floatValue());
            }
            if (bProcessCombined) {
                if (!bDoNotSetFlag) {
                    quote.setFlag('c');
                }
                pCombinedSession._close = f.floatValue();
                pCombinedSession.setLast(f.floatValue());
                clearPreFlag = true;
                me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Close, quote.getSymbolInfo().getSymbol());
                me.setClose(f.floatValue());
                if (log.isDebugEnabled()) {
                    log.debug(me.toString());
                }
            }
        } else if (msg.getSubRecord() == DdfSubRecord.DdfGeneratedUpdatePriceElementsRefresh.value() && bProcessCombined && !bDoNotSetFlag) {
            quote.setFlag('\u0000');
        }
        if ((f = msg21.getClose2()) != null) {
            if (session != null) {
                session._close2 = f.floatValue();
            }
            if (bProcessCombined) {
                pCombinedSession._close2 = f.floatValue();
            }
        }
        if ((f = msg21.getSettle()) != null) {
            if (f.floatValue() == 0.0f) {
                if (session != null) {
                    session._settlement = f.floatValue();
                }
                pCombinedSession._settlement = f.floatValue();
                if (!bDoNotSetFlag) {
                    quote.setFlag('\u0000');
                }
            } else {
                if (session != null) {
                    session.setLast(f.floatValue());
                    session._settlement = f.floatValue();
                }
                if (bProcessCombined) {
                    if (!bDoNotSetFlag) {
                        quote.setFlag('s');
                    }
                    pCombinedSession.setLast(f.floatValue());
                    pCombinedSession._settlement = f.floatValue();
                    clearPreFlag = true;
                    me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Settlement, quote.getSymbolInfo().getSymbol());
                    me.setSettlement(f.floatValue());
                    quote.setMarketCondition(MarketConditionType.NORMAL);
                    if (log.isDebugEnabled()) {
                        log.debug(me.toString());
                    }
                }
            }
        }
        if ((f = msg21.getHigh()) != null) {
            if (session != null) {
                session._high = f.floatValue();
            }
            if (bProcessCombined) {
                pCombinedSession._high = f.floatValue();
                clearPreFlag = true;
            }
            me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.High, quote.getSymbolInfo().getSymbol());
            me.setHigh(f.floatValue());
            if (log.isDebugEnabled()) {
                log.debug(me.toString());
            }
        }
        if ((f = msg21.getLow()) != null) {
            if (session != null) {
                session._low = f.floatValue();
            }
            if (bProcessCombined) {
                pCombinedSession._low = f.floatValue();
                clearPreFlag = true;
                me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Low, quote.getSymbolInfo().getSymbol());
                me.setLow(f.floatValue());
                if (log.isDebugEnabled()) {
                    log.debug(me.toString());
                }
            }
        }
        if ((f = msg21.getOpen()) != null) {
            if (session != null) {
                session._open = f.floatValue();
            }
            if (bProcessCombined) {
                pCombinedSession._open = f.floatValue();
                clearPreFlag = true;
                me = this.addMarketEvent(fe, msg, MarketEvent.MarketEventType.Open, quote.getSymbolInfo().getSymbol());
                me.setOpen(f.floatValue());
                quote.setMarketCondition(MarketConditionType.NORMAL);
                if (log.isDebugEnabled()) {
                    log.debug(me.toString());
                }
            }
        }
        if ((f = msg21.getOpen2()) != null) {
            if (session != null) {
                session._open2 = f.floatValue();
            }
            if (bProcessCombined) {
                pCombinedSession._open2 = f.floatValue();
            }
        }
        if ((l = msg21.getPreviousVolume()) != null && bProcessCombined) {
            pPreviousSession._volume = l;
        }
        if ((l = msg21.getOpenInterest()) != null && bProcessCombined) {
            pPreviousSession._openInterest = l.intValue();
        }
        if ((l = msg21.getVolume()) != null) {
            if (session != null) {
                session._volume = l;
            }
            if (bProcessCombined) {
                pCombinedSession._volume = l;
            }
        }
        if ((f = msg21.getPrevious()) != null) {
            if (session != null) {
                session.setPrevious(f.floatValue());
            }
            if (bProcessCombined) {
                pPreviousSession.setLast(f.floatValue());
                pCombinedSession.setPrevious(f.floatValue());
            }
        }
        switch (msg.getSubRecord()) {
            case '1': {
                if (session != null) {
                    session._timestamp = this.determineTimestamp(msg);
                }
                if (!bProcessCombined) break;
                pCombinedSession._timestamp = this.determineTimestamp(msg);
                break;
            }
            case '6': {
                if (session != null) {
                    session._tradeTimestamp = session._timestamp = this.determineTimestamp(msg);
                }
                if (!bProcessCombined) break;
                pCombinedSession._tradeTimestamp = pCombinedSession._timestamp = this.determineTimestamp(msg);
            }
        }
        if (quote.getFlag() == 'p' && clearPreFlag && !bDoNotSetFlag) {
            quote.setFlag('\u0000');
        }
    }

    void record2_subrecord7T(DdfMarketBase msg, Session pCombinedSession, Session pElectronicSession, Session session) {
        if (session != null && session != pElectronicSession) {
            session.setLast(((DdfMarketTrade)msg).getTradePrice());
            session._tradeSize = ((DdfMarketTrade)msg).getTradeSize();
            session._volume += (long)((DdfMarketTrade)msg).getTradeSize();
            ++session._numTrades;
            session._priceVolume += (double)(((DdfMarketTrade)msg).getTradePrice() * (float)((DdfMarketTrade)msg).getTradeSize());
        }
        pElectronicSession.setLast(((DdfMarketTrade)msg).getTradePrice());
        pElectronicSession._tradeSize = ((DdfMarketTrade)msg).getTradeSize();
        pElectronicSession._volume += (long)((DdfMarketTrade)msg).getTradeSize();
        ++pElectronicSession._numTrades;
        pElectronicSession._priceVolume += (double)(((DdfMarketTrade)msg).getTradePrice() * (float)((DdfMarketTrade)msg).getTradeSize());
        pCombinedSession._volume += (long)((DdfMarketTrade)msg).getTradeSize();
        if (msg.getMillisCST() > 0L) {
            if (session != null) {
                session._tradeTimestamp = msg.getMillisCST();
            }
            pElectronicSession._tradeTimestamp = msg.getMillisCST();
        } else {
            if (session != null) {
                session._tradeTimestamp = this.determineTimestamp(msg);
            }
            pElectronicSession._tradeTimestamp = this.determineTimestamp(msg);
        }
        if (session != null) {
            session._timestamp = pElectronicSession._tradeTimestamp;
        }
        pElectronicSession._timestamp = pElectronicSession._tradeTimestamp;
    }

    void record2_subrecord7Z(DdfMarketBase msg, Quote quote, boolean bDoNotSetFlag, CumulativeVolume cv, Session pCombinedSession, Session session) {
        DdfMarketTrade trade = (DdfMarketTrade)msg;
        if (msg.getSubRecord() == 'Z') {
            char saleCondition = trade.getSession();
            if (saleCondition == 'M' || saleCondition == 'Q') {
                return;
            }
            if (saleCondition == 'Z') {
                pCombinedSession.setBlockTrade(trade.getTradePrice());
                if (session != null) {
                    session.setBlockTrade(trade.getTradePrice());
                }
            }
            if (session != null) {
                session._volume += (long)trade.getTradeSize();
            }
            pCombinedSession._volume += (long)trade.getTradeSize();
        } else {
            char saleCondition = trade.getSession();
            if (saleCondition == '9') {
                return;
            }
            if (session != null) {
                session.setLast(trade.getTradePrice());
                session._tradeSize = trade.getTradeSize();
                session._volume += (long)trade.getTradeSize();
                ++session._numTrades;
                session._priceVolume += (double)(trade.getTradePrice() * (float)trade.getTradeSize());
            }
            pCombinedSession.setLast(trade.getTradePrice());
            pCombinedSession._tradeSize = trade.getTradeSize();
            pCombinedSession._volume += (long)trade.getTradeSize();
            ++pCombinedSession._numTrades;
            pCombinedSession._priceVolume += (double)(trade.getTradePrice() * (float)trade.getTradeSize());
            if (msg.getMillisCST() > 0L) {
                if (session != null) {
                    session._tradeTimestamp = msg.getMillisCST();
                }
                pCombinedSession._tradeTimestamp = msg.getMillisCST();
            } else {
                if (session != null) {
                    session._tradeTimestamp = this.determineTimestamp(msg);
                }
                pCombinedSession._tradeTimestamp = this.determineTimestamp(msg);
            }
            if (session != null) {
                session._timestamp = pCombinedSession._tradeTimestamp;
            }
            pCombinedSession._timestamp = pCombinedSession._tradeTimestamp;
            if (cv != null) {
                cv.addTrade(((DdfMarketTrade)msg).getTradePrice(), ((DdfMarketTrade)msg).getTradeSize());
            }
            if (!bDoNotSetFlag) {
                quote.setFlag('\u0000');
            }
        }
    }

    void record2_subrecord8(DdfMarketBase msg, Quote quote, Session pCombinedSession, Session session) {
        Integer i;
        DdfMarketBidAsk m = (DdfMarketBidAsk)msg;
        Float f = m.getAskPrice();
        if (f != null) {
            quote.setAsk(f.floatValue());
            if (f.floatValue() == 0.0f) {
                quote.setAskSize(0);
            } else {
                i = m.getAskSize();
                if (i != null) {
                    quote.setAskSize(i);
                }
            }
        }
        if ((f = m.getBidPrice()) != null) {
            quote.setBid(f.floatValue());
            if (f.floatValue() == 0.0f) {
                quote.setBidSize(0);
            } else {
                i = m.getBidSize();
                if (i != null) {
                    quote.setBidSize(i);
                }
            }
        }
        if (this._type == MasterType.Realtime) {
            if (session != null) {
                session._timestamp = this.determineTimestamp(msg);
            }
            pCombinedSession._timestamp = this.determineTimestamp(msg);
        }
    }

    BookQuote record3_book_eod(DdfMarketBase msg) {
        if (msg.getSubRecord() == DdfSubRecord.BookDepth.value()) {
            BookQuote bookQuote = this.getBookQuote(msg.getSymbol());
            if (bookQuote == null) {
                bookQuote = BookQuote.FromDDFMessage((DdfMarketDepth)msg);
            } else {
                int i;
                bookQuote.setBaseCode(msg.getBaseCode());
                bookQuote.askcount = ((DdfMarketDepth)msg).getAskCount();
                bookQuote.bidcount = ((DdfMarketDepth)msg).getBidCount();
                float[] fa = ((DdfMarketDepth)msg).getAskPrices();
                int[] ia = ((DdfMarketDepth)msg).getAskSizes();
                for (i = 0; i < bookQuote.askcount; ++i) {
                    if (fa[i] != 0.0f) {
                        bookQuote.askprices[i] = fa[i];
                    }
                    if (ia[i] == 0) continue;
                    bookQuote.asksizes[i] = ia[i];
                }
                fa = ((DdfMarketDepth)msg).getBidPrices();
                ia = ((DdfMarketDepth)msg).getBidSizes();
                for (i = 0; i < bookQuote.bidcount; ++i) {
                    if (fa[i] != 0.0f) {
                        bookQuote.bidprices[i] = fa[i];
                    }
                    if (ia[i] == 0) continue;
                    bookQuote.bidsizes[i] = ia[i];
                }
            }
            if (bookQuote != null) {
                this.bookMap.put(bookQuote.getSymbol(), bookQuote);
            }
            return bookQuote;
        }
        return null;
    }

    private MarketEvent addMarketEvent(FeedEvent fe, DdfMarketBase msg, MarketEvent.MarketEventType type, String symbol) {
        MarketEvent me = new MarketEvent(type);
        me.setDdfMessage(msg);
        me.setSymbol(symbol);
        fe.addMarketEvent(me);
        return me;
    }

    private CumulativeVolume handleRefreshCumlativeVolume(XMLNode node) {
        CumulativeVolume volume = CumulativeVolume.fromXMLNode(node);
        if (volume != null) {
            this._cumulativeVolumeTable.put(volume.getSymbol(), volume);
        }
        return volume;
    }

    private BookQuote handleBookQuoteRefresh(XMLNode node) {
        BookQuote bookQuote = BookQuote.fromXMLNode(node);
        if (bookQuote != null) {
            this.bookMap.put(bookQuote.getSymbol(), bookQuote);
        }
        return bookQuote;
    }

    private Quote handleRefreshQuote(DdfMarketBase msg, XMLNode node) {
        Quote quote = Quote.fromXMLNode(node);
        if (quote != null) {
            this.quoteMap.put(quote.getSymbolInfo().getSymbol(), quote);
            quote.setMessage(msg);
        }
        return quote;
    }

    private long determineTimestamp(DdfMarketBase m) {
        long millis = this.millisCST;
        int type = this.getSymbolType(m.getSymbol());
        if (type > 200 && type < 300) {
            millis += 3600000L;
        }
        if (this._type == MasterType.Delayed) {
            millis -= (long)(m.getDelay() * 60 * 1000);
        }
        return millis;
    }

    private int getSymbolType(String symbol) {
        if (symbol.length() > 0) {
            boolean hasNumbers = false;
            char[] ca = symbol.toCharArray();
            if (ca[0] == '$') {
                return 202;
            }
            if (ca[0] == '^') {
                return 501;
            }
            for (int i = 0; i < ca.length; ++i) {
                if (!Character.isDigit(ca[i])) continue;
                hasNumbers = true;
                break;
            }
            if (!hasNumbers) {
                return 201;
            }
            if (Character.isDigit(ca[ca.length - 1])) {
                return 101;
            }
            return 102;
        }
        return -1;
    }

    public void addSubscribedSymbol(String symbol) {
        this.unrecoginzedSymbols.put(symbol, System.currentTimeMillis());
    }

    public void removeSubscribedSymbol(String symbol) {
        this.unrecoginzedSymbols.remove(symbol);
    }

    public String[] getUnknownSymbols() {
        return this.unrecoginzedSymbols.keySet().toArray(new String[this.unrecoginzedSymbols.size()]);
    }
}

