/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.db.SymbolInfo;
import com.ddfplus.util.DDFDate;
import com.ddfplus.util.ParserHelper;
import com.ddfplus.util.XMLNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CumulativeVolume {
    protected final String _symbol;
    protected volatile char _baseCode = '\u0000';
    protected volatile int _tickIncrement = 1;
    protected volatile float _last = 0.0f;
    protected volatile int _lastSize = 0;
    protected volatile int _lastCumulativeVolume = 0;
    protected volatile long _date = 0L;
    protected final Map<Float, Integer> _data;

    public CumulativeVolume(String symbol) {
        this._symbol = symbol;
        this._data = new ConcurrentHashMap<Float, Integer>();
    }

    protected void addTrade(float price, int size) {
        Float f = Float.valueOf(price);
        Integer i = this._data.get(f);
        int ival = 0;
        if (i != null) {
            ival = i;
        }
        this._data.put(f, ival += size);
        this._lastSize = size;
        this._lastCumulativeVolume = price == this._last ? (this._lastCumulativeVolume += this._lastSize) : this._lastSize;
        this._last = price;
    }

    public String getSymbol() {
        return this._symbol;
    }

    public char getBaseCode() {
        return this._baseCode;
    }

    public long getDate() {
        return this._date;
    }

    public float getLast() {
        return this._last;
    }

    public int getLastSize() {
        return this._lastSize;
    }

    public int getLastCumulativeVolume() {
        return this._lastCumulativeVolume;
    }

    public List<Float> getPrices() {
        ArrayList<Float> l = new ArrayList<Float>(this._data.keySet());
        Collections.sort(l);
        return l;
    }

    public Map<Float, Integer> getData() {
        return this._data;
    }

    public char getDayCode() {
        return new DDFDate(this._date).getDayCode();
    }

    public int getTickIncrement() {
        return this._tickIncrement;
    }

    protected void setDate(long date) {
        this._date = date;
    }

    public String toString() {
        String s = this._symbol + ";" + this._last + ";" + this._lastSize + ";" + this._lastCumulativeVolume + ";" + this._data.toString();
        return s;
    }

    public XMLNode toXMLNode() {
        int uc = SymbolInfo.ddfuc2bb(this._baseCode);
        XMLNode node = new XMLNode("CV");
        node.setAttribute("symbol", this._symbol);
        node.setAttribute("basecode", "" + this._baseCode);
        node.setAttribute("tickincrement", "" + this._tickIncrement);
        node.setAttribute("last", Integer.toString(ParserHelper.float2int(uc, this._last)));
        node.setAttribute("lastsize", "" + this._lastSize);
        node.setAttribute("lastcvol", "" + this._lastCumulativeVolume);
        if (this._date > 0L) {
            DDFDate d = new DDFDate(this._date);
            node.setAttribute("date", d.toDDFString());
        }
        node.setAttribute("count", "" + this._data.size());
        StringBuilder sb = new StringBuilder();
        for (Float f : this._data.keySet()) {
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(ParserHelper.float2int(uc, f.floatValue()) + "," + this._data.get(f));
        }
        if (sb.length() > 0) {
            node.setAttribute("data", sb.toString());
        }
        return node;
    }

    public static final CumulativeVolume fromXMLNode(XMLNode node) {
        String dataString;
        if (!node.getName().equals("CV")) {
            return null;
        }
        CumulativeVolume volume = new CumulativeVolume(node.getAttribute("symbol"));
        volume._baseCode = node.getAttribute("basecode").charAt(0);
        volume._tickIncrement = Integer.parseInt(node.getAttribute("tickincrement"));
        volume._last = ParserHelper.string2float(node.getAttribute("last"), volume._baseCode);
        volume._lastSize = Integer.parseInt(node.getAttribute("lastsize"));
        volume._lastCumulativeVolume = Integer.parseInt(node.getAttribute("lastcvol"));
        String dateString = node.getAttribute("date");
        if (dateString != null) {
            volume._date = DDFDate.fromDDFString(dateString).getMillisCST();
        }
        if ((dataString = node.getAttribute("data")) != null) {
            String[] data = dataString.split(":");
            for (int i = 0; i < data.length; ++i) {
                String[] pair = data[i].split(",");
                Float price = Float.valueOf(ParserHelper.string2float(pair[0], volume._baseCode));
                Integer quantity = Integer.parseInt(pair[1]);
                volume._data.put(price, quantity);
            }
        }
        return volume;
    }
}

