/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.db;

import com.ddfplus.db.SymbolInfo;
import com.ddfplus.messages.DdfMarketDepth;
import com.ddfplus.util.ParserHelper;
import com.ddfplus.util.XMLNode;
import java.io.Serializable;

public class BookQuote
implements Serializable {
    static final long serialVersionUID = 8023594349583363700L;
    protected final String symbol;
    protected volatile int askcount = 0;
    protected volatile int bidcount = 0;
    protected volatile float[] askprices = new float[10];
    protected volatile int[] asksizes = new int[10];
    protected volatile float[] bidprices = new float[10];
    protected volatile int[] bidsizes = new int[10];
    protected volatile char basecode = '\u0000';
    protected volatile long timestamp = 0L;

    public BookQuote(String symbol) {
        this.symbol = symbol;
    }

    public int getAskCount() {
        return this.askcount;
    }

    public Object[] getAskData() {
        Object[] o = new Object[]{this.askprices, this.asksizes};
        return o;
    }

    public int getBidCount() {
        return this.bidcount;
    }

    public Object[] getBidData() {
        Object[] o = new Object[]{this.bidprices, this.bidsizes};
        return o;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public char getBaseCode() {
        return this.basecode;
    }

    public void setBaseCode(char c) {
        if (c != '?') {
            this.basecode = c;
        }
    }

    public long getTimeInMillis() {
        return this.timestamp;
    }

    public XMLNode toXMLNode() {
        int i;
        XMLNode node = new XMLNode("BOOK");
        node.setAttribute("symbol", this.symbol);
        node.setAttribute("basecode", "" + this.basecode);
        node.setAttribute("askcount", "" + this.askcount);
        node.setAttribute("bidcount", "" + this.bidcount);
        int uc = SymbolInfo.ddfuc2bb(this.basecode);
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (i = 0; i < this.askcount; ++i) {
            sb1.append("," + Integer.toString(ParserHelper.float2int(uc, this.askprices[i])));
            sb2.append("," + this.asksizes[i]);
        }
        if (sb1.length() > 0) {
            node.setAttribute("askprices", sb1.substring(1));
        }
        if (sb2.length() > 0) {
            node.setAttribute("asksizes", sb2.substring(1));
        }
        sb1 = new StringBuilder();
        sb2 = new StringBuilder();
        for (i = 0; i < this.bidcount; ++i) {
            sb1.append("," + Integer.toString(ParserHelper.float2int(uc, this.bidprices[i])));
            sb2.append("," + this.bidsizes[i]);
        }
        if (sb1.length() > 0) {
            node.setAttribute("bidprices", sb1.substring(1));
        }
        if (sb2.length() > 0) {
            node.setAttribute("bidsizes", sb2.substring(1));
        }
        return node;
    }

    public static final BookQuote FromDDFMessage(DdfMarketDepth message) {
        BookQuote bq = new BookQuote(message.getSymbol());
        bq.basecode = message.getBaseCode();
        bq.askcount = message.getAskCount();
        bq.bidcount = message.getBidCount();
        System.arraycopy(message.getAskPrices(), 0, bq.askprices, 0, bq.askcount);
        System.arraycopy(message.getAskSizes(), 0, bq.asksizes, 0, bq.askcount);
        System.arraycopy(message.getBidPrices(), 0, bq.bidprices, 0, bq.bidcount);
        System.arraycopy(message.getBidSizes(), 0, bq.bidsizes, 0, bq.bidcount);
        return bq;
    }

    public static BookQuote fromXMLNode(XMLNode node) {
        int i;
        String[] sa;
        BookQuote bq = new BookQuote(node.getAttribute("symbol"));
        bq.basecode = node.getAttribute("basecode").charAt(0);
        bq.askcount = Integer.parseInt(node.getAttribute("askcount"));
        bq.bidcount = Integer.parseInt(node.getAttribute("bidcount"));
        String s = node.getAttribute("askprices");
        if (s != null) {
            sa = s.split(",");
            for (i = 0; i < sa.length; ++i) {
                if (sa[i].length() <= 0) continue;
                bq.askprices[i] = ParserHelper.string2float(sa[i], bq.basecode);
            }
        }
        if ((s = node.getAttribute("asksizes")) != null) {
            sa = s.split(",");
            for (i = 0; i < sa.length; ++i) {
                if (sa[i].length() <= 0) continue;
                bq.asksizes[i] = Integer.parseInt(sa[i]);
            }
        }
        if ((s = node.getAttribute("bidprices")) != null) {
            sa = s.split(",");
            for (i = 0; i < sa.length; ++i) {
                if (sa[i].length() <= 0) continue;
                bq.bidprices[i] = ParserHelper.string2float(sa[i], bq.basecode);
            }
        }
        if ((s = node.getAttribute("bidsizes")) != null) {
            sa = s.split(",");
            for (i = 0; i < sa.length; ++i) {
                if (sa[i].length() <= 0) continue;
                bq.bidsizes[i] = Integer.parseInt(sa[i]);
            }
        }
        return bq;
    }
}

