/*
 * Decompiled with CFR 0.152.
 */
package com.ddfplus.codec;

import com.ddfplus.db.SymbolInfo;
import com.ddfplus.messages.AbstractMsgBaseMarket;
import com.ddfplus.messages.CtrlTimestamp;
import com.ddfplus.messages.Data20Parameter;
import com.ddfplus.messages.Data21Refresh;
import com.ddfplus.messages.Data27Trade;
import com.ddfplus.messages.Data28BidAsk;
import com.ddfplus.messages.Data29Condition;
import com.ddfplus.messages.Data2ZTrade;
import com.ddfplus.messages.Data3BOrderBook;
import com.ddfplus.messages.Data3XSummary;
import com.ddfplus.messages.DataRefreshXML;
import com.ddfplus.messages.DdfMarketBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Codec {
    private static final Logger log = LoggerFactory.getLogger(Codec.class);

    private Codec() {
    }

    public static int getIndexOf(byte[] ba, char item, int start) {
        byte b = (byte)item;
        for (int i = start; i < ba.length; ++i) {
            if (ba[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static int parseDDFIntValue(byte[] ba, int start, int length) {
        return length == 0 ? 0 : Codec.parseIntValue(ba, start, length);
    }

    public static float parseDDFPriceValue(byte[] ba, int start, int length, char unitcode) throws NumberFormatException {
        return Codec.parseDDFPriceValue(ba, start, length, SymbolInfo.ddfuc2bb(unitcode));
    }

    public static float parseDDFPriceValue(byte[] ba, int start, int length, int basecode) throws NumberFormatException {
        if (start + length > ba.length) {
            throw new NumberFormatException("Index Out of Bounds array.length=" + ba.length + ", start=" + start + ", length=" + length);
        }
        if (length == 0) {
            return 0.0f;
        }
        if ((char)ba[start] == '-' && length == 1) {
            return 0.0f;
        }
        if (basecode >= 0) {
            long lval = Codec.parseLongValue(ba, start, length);
            double d = (double)lval / Math.pow(10.0, basecode);
            return (float)d;
        }
        float f = 0.0f;
        int ival = Codec.parseIntValue(ba, start, length);
        switch (basecode) {
            case -1: {
                f = (float)(ival / 10) + (float)(ival % 10) / 8.0f;
                break;
            }
            case -2: {
                f = (float)(ival / 100) + (float)(ival % 100) / 16.0f;
                break;
            }
            case -3: {
                f = (float)(ival / 100) + (float)(ival % 100) / 32.0f;
                break;
            }
            case -4: {
                f = (float)(ival / 100) + (float)(ival % 100) / 64.0f;
                break;
            }
            case -5: {
                f = (float)(ival / 1000) + (float)(ival % 1000) / 128.0f;
                break;
            }
            case -6: {
                f = (float)(ival / 1000) + (float)(ival % 1000) / 256.0f;
            }
        }
        return f;
    }

    public static int parseIntValue(byte[] ba, int start, int length) throws NumberFormatException {
        if (start + length > ba.length) {
            throw new NumberFormatException("Index Out of Bounds array.length=" + ba.length + ", start=" + start + ", length=" + length);
        }
        int mult = 1;
        if ((char)ba[start] == '-') {
            mult = -1;
            ++start;
            --length;
        }
        int value = 0;
        int base = 1;
        for (int i = start + length - 1; i >= start; --i) {
            value += base * (ba[i] - 48);
            base *= 10;
        }
        return value * mult;
    }

    public static long parseLongValue(byte[] ba, int start, int length) {
        long mult = 1L;
        if ((char)ba[start] == '-') {
            mult = -1L;
            ++start;
            --length;
        }
        long value = 0L;
        int base = 1;
        for (int i = start + length - 1; i >= start; --i) {
            value += (long)base * ((long)ba[i] - 48L);
            base *= 10;
        }
        return value * mult;
    }

    public static DdfMarketBase parseMessage(byte[] array) {
        AbstractMsgBaseMarket msg;
        boolean showErrorMessage;
        block42: {
            byte[] baOriginal = array;
            showErrorMessage = true;
            msg = null;
            try {
                block1 : switch (array[0]) {
                    case 37: {
                        String message = new String(array);
                        if (message.charAt(1) != '<') {
                            if (message.charAt(1) == '%') {
                                message = message.substring(1);
                            } else {
                                log.error("format error; message={}", (Object)message);
                                break;
                            }
                        }
                        msg = DataRefreshXML.Parse(message);
                        break;
                    }
                    case 1: {
                        int record = array[1];
                        String spreadType = null;
                        String[] spreadLegs = null;
                        if (record == 83) {
                            Object[] o = Codec.stripSpreadPreamble(array);
                            record = 50;
                            array = (byte[])o[5];
                            spreadType = (String)o[1];
                            spreadLegs = (String[])o[3];
                        }
                        switch (record) {
                            case 35: {
                                msg = CtrlTimestamp.Parse(array);
                                break block1;
                            }
                            case 33: {
                                showErrorMessage = false;
                                break block1;
                            }
                            case 50: 
                            case 67: 
                            case 83: {
                                int pos = Codec.getIndexOf(array, ',', 0);
                                char subrecord = (char)array[pos + 1];
                                switch (subrecord) {
                                    case '0': {
                                        String symbol = Codec.parseStringValue(array, 2, pos - 2);
                                        char baseCode = (char)array[pos + 3];
                                        char exchange = (char)array[pos + 4];
                                        int delay = Codec.parseIntValue(array, pos + 5, 2);
                                        int pos2 = Codec.getIndexOf(array, ',', pos + 7);
                                        char element = (char)array[pos2 + 1];
                                        char modifier = (char)array[pos2 + 2];
                                        switch (element) {
                                            case '1': {
                                                msg = new Data28BidAsk(array);
                                                ((Data28BidAsk)msg)._record = (char)50;
                                                ((Data28BidAsk)msg)._subrecord = (char)56;
                                                ((Data28BidAsk)msg)._ask = Float.valueOf(Codec.parseDDFPriceValue(array, pos + 7, pos2 - pos - 7, baseCode));
                                                break;
                                            }
                                            case '2': {
                                                msg = new Data28BidAsk(array);
                                                ((Data28BidAsk)msg)._record = (char)50;
                                                ((Data28BidAsk)msg)._subrecord = (char)56;
                                                ((Data28BidAsk)msg)._bid = Float.valueOf(Codec.parseDDFPriceValue(array, pos + 7, pos2 - pos - 7, baseCode));
                                                break;
                                            }
                                            default: {
                                                msg = Data20Parameter.Parse(array);
                                            }
                                        }
                                        msg._symbol = symbol;
                                        msg._basecode = baseCode;
                                        msg._exchange = exchange;
                                        msg._delay = delay;
                                        msg._day = (char)array[pos2 + 3];
                                        msg._session = (char)array[pos2 + 4];
                                        msg.setMessageTimestamp(pos2 + 5);
                                        break;
                                    }
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '6': {
                                        msg = Data21Refresh.Parse(array);
                                        break;
                                    }
                                    case '5': {
                                        showErrorMessage = false;
                                        break;
                                    }
                                    case '7': {
                                        msg = Data27Trade.Parse(array);
                                        break;
                                    }
                                    case 'Z': {
                                        msg = Data2ZTrade.Parse(array);
                                        break;
                                    }
                                    case '8': {
                                        msg = Data28BidAsk.Parse(array);
                                        break;
                                    }
                                    case '9': {
                                        msg = Data29Condition.Parse(array);
                                        break;
                                    }
                                    case 'F': {
                                        showErrorMessage = false;
                                    }
                                }
                                if (msg == null || spreadType == null) break block42;
                                msg._spreadType = spreadType;
                                msg._spreadLegs = spreadLegs;
                                if (msg._etxpos > -1) {
                                    msg._etxpos += baOriginal.length - array.length;
                                    break block1;
                                }
                                break block42;
                            }
                            case 51: {
                                int pos = Codec.getIndexOf(array, ',', 0);
                                switch ((char)array[pos + 1]) {
                                    case 'B': {
                                        msg = Data3BOrderBook.Parse(array);
                                        break block1;
                                    }
                                    case 'C': {
                                        msg = Data3XSummary.Parse(array);
                                        break block1;
                                    }
                                    case 'D': {
                                        showErrorMessage = false;
                                        break block1;
                                    }
                                    case 'I': {
                                        msg = Data3XSummary.Parse(array);
                                        break block1;
                                    }
                                    case 'R': {
                                        showErrorMessage = false;
                                        break block1;
                                    }
                                    case 'S': {
                                        msg = Data3XSummary.Parse(array);
                                        break block1;
                                    }
                                    case 'T': {
                                        msg = Data3XSummary.Parse(array);
                                        break block1;
                                    }
                                    case 'V': 
                                    case 'W': {
                                        showErrorMessage = false;
                                    }
                                }
                                break block1;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error("Parse failed on message: " + new String(array) + " error: ", (Throwable)e);
            }
        }
        if (msg == null && showErrorMessage) {
            log.error("Could not parse message: " + new String(array));
        }
        return msg;
    }

    public static String parseStringValue(byte[] ba, int start, int length) {
        char[] ca = new char[length];
        for (int i = 0; i < length; ++i) {
            ca[i] = (char)ba[i + start];
        }
        return new String(ca);
    }

    protected static Object[] stripSpreadPreamble(byte[] ba) {
        int pos = Codec.getIndexOf(ba, ',', 0);
        String symbol = Codec.parseStringValue(ba, 2, pos - 2);
        char subrecord = (char)ba[pos + 1];
        int spStart = pos + 7;
        String spreadType = Codec.parseStringValue(ba, pos + 7, 2);
        int numberOfLegs = Codec.parseIntValue(ba, pos + 9, 1);
        String[] legs = new String[numberOfLegs];
        legs[0] = symbol;
        pos += 10;
        for (int i = 1; i < numberOfLegs; ++i) {
            int pos2 = Codec.getIndexOf(ba, ',', pos);
            legs[i] = Codec.parseStringValue(ba, pos, pos2 - pos);
            pos = pos2 + 1;
        }
        int start2 = pos;
        switch (subrecord) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                --start2;
            }
        }
        int length = spStart + (ba.length - start2);
        byte[] ba2 = new byte[length];
        System.arraycopy(ba, 0, ba2, 0, spStart);
        System.arraycopy(ba, start2, ba2, spStart, ba.length - start2);
        StringBuilder sb = new StringBuilder("_S_" + spreadType);
        for (String s : legs) {
            sb.append("_" + s);
        }
        byte[] ba3 = new byte[ba2.length - symbol.length() + sb.length()];
        ba3[0] = 1;
        ba3[1] = 50;
        for (int i = 0; i < sb.length(); ++i) {
            ba3[2 + i] = (byte)sb.charAt(i);
        }
        System.arraycopy(ba2, 2 + symbol.length(), ba3, 2 + sb.length(), ba3.length - (2 + sb.length()));
        return new Object[]{Character.valueOf(subrecord), spreadType, numberOfLegs, legs, ba2, ba3};
    }
}

