/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullParserFactory {
    static final Class referenceContextClass;
    public static final String PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    private static final String RESOURCE_NAME = "/META-INF/services/org.xmlpull.v1.XmlPullParserFactory";
    protected ArrayList parserClasses;
    protected String classNamesLocation;
    protected ArrayList serializerClasses;
    protected HashMap features = new HashMap();

    protected XmlPullParserFactory() {
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        this.features.put(name, state);
    }

    public boolean getFeature(String name) {
        Boolean value = (Boolean)this.features.get(name);
        return value != null ? value : false;
    }

    public void setNamespaceAware(boolean awareness) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", awareness);
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
    }

    public void setValidating(boolean validating) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", validating);
    }

    public boolean isValidating() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    public XmlPullParser newPullParser() throws XmlPullParserException {
        if (this.parserClasses == null) {
            throw new XmlPullParserException("Factory initialization was incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.parserClasses.size() == 0) {
            throw new XmlPullParserException("No valid parser classes found in " + this.classNamesLocation);
        }
        StringBuilder issues = new StringBuilder();
        for (int i = 0; i < this.parserClasses.size(); ++i) {
            Class ppClass = (Class)this.parserClasses.get(i);
            try {
                XmlPullParser pp = (XmlPullParser)ppClass.newInstance();
                for (String key : this.features.keySet()) {
                    Boolean value = (Boolean)this.features.get(key);
                    if (value == null || !value.booleanValue()) continue;
                    pp.setFeature(key, true);
                }
                return pp;
            }
            catch (Exception ex) {
                issues.append(ppClass.getName() + ": " + ex.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create parser: " + String.valueOf(issues));
    }

    public XmlSerializer newSerializer() throws XmlPullParserException {
        if (this.serializerClasses == null) {
            throw new XmlPullParserException("Factory initialization incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.serializerClasses.size() == 0) {
            throw new XmlPullParserException("No valid serializer classes found in " + this.classNamesLocation);
        }
        StringBuilder issues = new StringBuilder();
        for (int i = 0; i < this.serializerClasses.size(); ++i) {
            Class ppClass = (Class)this.serializerClasses.get(i);
            try {
                XmlSerializer ser = (XmlSerializer)ppClass.newInstance();
                return ser;
            }
            catch (Exception ex) {
                issues.append(ppClass.getName() + ": " + ex.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create serializer: " + String.valueOf(issues));
    }

    public static XmlPullParserFactory newInstance() throws XmlPullParserException {
        return XmlPullParserFactory.newInstance(null, null);
    }

    public static XmlPullParserFactory newInstance(String classNames, Class context) throws XmlPullParserException {
        classNames = "org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer";
        XmlPullParserFactory factory = null;
        ArrayList parserClasses = new ArrayList();
        ArrayList serializerClasses = new ArrayList();
        int pos = 0;
        while (pos < classNames.length()) {
            int cut = classNames.indexOf(44, pos);
            if (cut == -1) {
                cut = classNames.length();
            }
            String name = classNames.substring(pos, cut);
            Class<?> candidate = null;
            Object instance = null;
            try {
                candidate = Class.forName(name);
                instance = candidate.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (candidate != null) {
                boolean recognized = false;
                if (instance instanceof XmlPullParser) {
                    parserClasses.add(candidate);
                    recognized = true;
                }
                if (instance instanceof XmlSerializer) {
                    serializerClasses.add(candidate);
                    recognized = true;
                }
                if (instance instanceof XmlPullParserFactory) {
                    if (factory == null) {
                        factory = instance;
                    }
                    recognized = true;
                }
                if (!recognized) {
                    throw new XmlPullParserException("incompatible class: " + name);
                }
            }
            pos = cut + 1;
        }
        if (factory == null) {
            factory = new XmlPullParserFactory();
        }
        factory.parserClasses = parserClasses;
        factory.serializerClasses = serializerClasses;
        factory.classNamesLocation = "org.kxml2.io.kXmlParser,org.kxml2.io.KXmlSerializer";
        return factory;
    }

    static {
        XmlPullParserFactory f = new XmlPullParserFactory();
        referenceContextClass = f.getClass();
    }
}

