/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.datetime.NDateTime;
import com.t4login.util.Range;
import java.util.ArrayList;
import java.util.List;

public class TimeRange {
    public NDateTime start;
    public NDateTime end;

    public static TimeRange of(NDateTime start, NDateTime end) {
        return new TimeRange(start, end);
    }

    public static TimeRange of(NDateTime val) {
        return new TimeRange(val);
    }

    public TimeRange() {
        this.start = null;
        this.end = null;
    }

    public TimeRange(NDateTime val) {
        this.start = val;
        this.end = val;
    }

    public TimeRange(NDateTime rangeStart, NDateTime rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public TimeRange(Range<NDateTime> range) {
        this.start = range.start();
        this.end = range.end();
    }

    public void set(NDateTime start, NDateTime end) {
        this.start = start;
        this.end = end;
    }

    public void set(TimeRange range) {
        this.start = range.start;
        this.end = range.end;
    }

    public void set(Range<NDateTime> range) {
        this.start = range.start();
        this.end = range.end();
    }

    public NDateTime start() {
        return this.start;
    }

    public NDateTime end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start == null || this.end == null;
    }

    public boolean isNormal() {
        return this.start.getTicks() <= this.end.getTicks();
    }

    public void reverse() {
        NDateTime tmp = this.start;
        this.start = this.end;
        this.end = tmp;
    }

    public TimeRange reversed() {
        return new TimeRange(this.end, this.start);
    }

    public void normalize() {
        if (!this.isNormal()) {
            this.reverse();
        }
    }

    public TimeRange normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public void expand(NDateTime val) {
        if (this.isNormal()) {
            this.start.set(Math.min(this.start.getTicks(), val.getTicks()));
            this.end.set(Math.max(this.end.getTicks(), val.getTicks()));
        } else {
            this.start.set(Math.max(this.start.getTicks(), val.getTicks()));
            this.end.set(Math.min(this.end.getTicks(), val.getTicks()));
        }
    }

    public TimeRange expanded(NDateTime val) {
        return this.expanded(new TimeRange(val));
    }

    public void expand(TimeRange range) {
        this.expand(range.start);
        this.expand(range.end);
    }

    public TimeRange expanded(TimeRange range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        TimeRange r1 = this.normalized();
        TimeRange r2 = range.normalized();
        NDateTime ustart = r2.start.getTicks() < r1.start.getTicks() ? r2.start() : r1.start();
        NDateTime uend = r2.end.getTicks() > r1.end.getTicks() ? r2.end() : r1.end();
        return new TimeRange(ustart, uend);
    }

    public TimeRange condensed(TimeRange rng) {
        if (rng.isEmpty()) {
            return this;
        }
        TimeRange r1 = this.normalized();
        TimeRange r2 = rng.normalized();
        NDateTime start = r2.start.getTicks() > r1.start.getTicks() ? r2.start : r1.start;
        NDateTime end = r2.end.getTicks() < r1.end.getTicks() ? r2.end : r1.end;
        return new TimeRange(start, end).normalized();
    }

    public boolean contains(NDateTime val) {
        if (this.isNormal()) {
            return val.getTicks() >= this.start.getTicks() && val.getTicks() <= this.end.getTicks();
        }
        return val.getTicks() <= this.start.getTicks() && val.getTicks() >= this.end.getTicks();
    }

    public boolean contains(TimeRange range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(TimeRange range) {
        if (this.isEmpty() || range.isEmpty()) {
            return false;
        }
        return this.contains(range.start) || this.contains(range.end) || range.contains(this.start) || range.contains(this.end);
    }

    public boolean equals(TimeRange other) {
        return this.start.equals(other.start()) && this.end.equals(other.end);
    }

    public boolean equals(Object other) {
        if (other instanceof TimeRange) {
            return this.equals((TimeRange)other);
        }
        return false;
    }

    public int hashCode() {
        return Float.valueOf(this.start.getTicks()).hashCode() * 37 + Float.valueOf(this.end.getTicks()).hashCode();
    }

    public String toString() {
        return String.format("[%s, %s]", this.start, this.end);
    }

    public static List<Range<NDateTime>> remove(Range<NDateTime> r1, Range<NDateTime> r2) {
        Range<NDateTime> rngright;
        ArrayList<Range<NDateTime>> resultRanges = new ArrayList<Range<NDateTime>>();
        if (!r1.intersects(r2)) {
            resultRanges.add(r1);
            return resultRanges;
        }
        Range<NDateTime> rngleft = Range.of(r1.start(), r2.start().AddDays(-1.0));
        if (rngleft.isNormal()) {
            resultRanges.add(rngleft);
        }
        if ((rngright = Range.of(r2.end().AddDays(1.0), r1.end())).isNormal()) {
            resultRanges.add(rngright);
        }
        return resultRanges;
    }

    public static Range<NDateTime> intersection(Range<NDateTime> r1, Range<NDateTime> r2) {
        if (r1.isEmpty() || r2.isEmpty() || !r1.intersects(r2)) {
            return Range.empty();
        }
        NDateTime sdt = r1.start().compareTo(r2.start()) > 0 ? r1.start() : r2.start();
        NDateTime edt = r1.end().compareTo(r2.end()) < 0 ? r1.end() : r2.end();
        return Range.of(sdt, edt);
    }
}

