/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

public class Range<T extends Comparable<? super T>> {
    private final T start;
    private final T end;
    private final boolean empty;

    public static <T extends Comparable<? super T>> Range<T> empty() {
        return new Range<T>();
    }

    public static <T extends Comparable<? super T>> Range<T> of(T start, T end) {
        return new Range<T>(start, end);
    }

    public static <T extends Comparable<? super T>> Range<T> of(T val) {
        return new Range<T>(val);
    }

    public Range() {
        this.start = null;
        this.end = null;
        this.empty = true;
    }

    public Range(T val) {
        if (val == null) {
            this.start = null;
            this.end = null;
            this.empty = true;
        } else {
            this.start = val;
            this.end = val;
            this.empty = false;
        }
    }

    public Range(T rangeStart, T rangeEnd) {
        if (rangeStart == null || rangeEnd == null) {
            this.start = null;
            this.end = null;
            this.empty = true;
        } else {
            this.start = rangeStart;
            this.end = rangeEnd;
            this.empty = false;
        }
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isNormal() {
        return this.empty || this.start.compareTo(this.end) <= 0;
    }

    public Range<T> reversed() {
        return new Range<T>(this.end, this.start);
    }

    public Range<T> normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public Range<T> expanded(T val) {
        return this.expanded(new Range<T>(val));
    }

    public Range<T> expanded(Range<T> range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        Range<T> r1 = this.normalized();
        Range<T> r2 = range.normalized();
        T ustart = r2.start().compareTo(r1.start()) < 0 ? r2.start() : r1.start();
        T uend = r2.end().compareTo(r1.end()) > 0 ? r2.end() : r1.end();
        return new Range<T>(ustart, uend);
    }

    public Range<T> condensed(Range<T> rng) {
        if (this.isEmpty()) {
            return this;
        }
        if (rng.isEmpty()) {
            return this;
        }
        Range<T> r1 = this.normalized();
        Range<T> r2 = rng.normalized();
        T start = r2.start.compareTo(r1.start) > 0 ? r2.start : r1.start;
        T end = r2.end.compareTo(r1.end) < 0 ? r2.end : r1.end;
        return new Range<T>(start, end).normalized();
    }

    public boolean contains(T val) {
        if (this.empty) {
            return false;
        }
        if (this.isNormal()) {
            return val.compareTo(this.start) >= 0 && val.compareTo(this.end) <= 0;
        }
        return val.compareTo(this.start) <= 0 && val.compareTo(this.end) >= 0;
    }

    public boolean contains(Range<T> range) {
        if (this.empty || range.empty) {
            return false;
        }
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(Range<T> range) {
        if (this.empty || range.empty) {
            return false;
        }
        Range<T> r1 = this.normalized();
        Range<T> r2 = range.normalized();
        return r1.contains(r2.start) || r1.contains(r2.end) || r2.contains(r1.start) || r2.contains(r1.end);
    }

    public boolean equals(Range<T> other) {
        if (other == null) {
            return false;
        }
        if (this.empty && other.empty) {
            return true;
        }
        if (this.empty ^ other.empty) {
            return false;
        }
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    public boolean equals(Object other) {
        if (other instanceof Range) {
            return this.equals((Range)other);
        }
        return false;
    }

    public int hashCode() {
        if (this.empty || this.start == null || this.end == null) {
            return 0;
        }
        return this.start.hashCode() * 37 + this.end.hashCode();
    }

    public String toString() {
        if (this.empty) {
            return "[<empty>]";
        }
        return String.format("[%s, %s]", this.start, this.end);
    }
}

