/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.definitions.priceconversion.Price;

public class PriceRange {
    public Price start;
    public Price end;

    public static PriceRange empty() {
        return new PriceRange(Price.Zero);
    }

    public static PriceRange of(Price start, Price end) {
        return new PriceRange(start, end);
    }

    public static PriceRange of(Price val) {
        return new PriceRange(val);
    }

    public PriceRange() {
        this.start = Price.Zero;
        this.end = Price.Zero;
    }

    public PriceRange(Price val) {
        this.start = val;
        this.end = val;
    }

    public PriceRange(Price rangeStart, Price rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public void set(Price start, Price end) {
        this.start = start;
        this.end = end;
    }

    public void set(PriceRange range) {
        this.start = range.start;
        this.end = range.end;
    }

    public Price start() {
        return this.start;
    }

    public Price end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start.equals(Price.Zero) && this.end.equals(Price.Zero);
    }

    public boolean isNormal() {
        return this.start.compareTo(this.end) <= 0;
    }

    public void reverse() {
        Price tmp = this.start;
        this.start = this.end;
        this.end = tmp;
    }

    public PriceRange reversed() {
        return new PriceRange(this.end, this.start);
    }

    public void normalize() {
        if (!this.isNormal()) {
            this.reverse();
        }
    }

    public PriceRange normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public void expand(Price val) {
        if (this.isNormal()) {
            this.start = this.start.compareTo(val) < 0 ? this.start : val;
            this.end = this.end.compareTo(val) > 0 ? this.end : val;
        } else {
            this.start = this.start.compareTo(val) > 0 ? this.start : val;
            this.end = this.end.compareTo(val) < 0 ? this.end : val;
        }
    }

    public PriceRange expanded(Price val) {
        return this.expanded(new PriceRange(val));
    }

    public void expand(PriceRange range) {
        this.expand(range.start);
        this.expand(range.end);
    }

    public PriceRange expanded(PriceRange range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        PriceRange r1 = this.normalized();
        PriceRange r2 = range.normalized();
        Price ustart = r2.start.compareTo(r1.start) < 0 ? r2.start() : r1.start();
        Price uend = r2.end.compareTo(r1.end) > 0 ? r2.end() : r1.end();
        return new PriceRange(ustart, uend);
    }

    public PriceRange condensed(PriceRange rng) {
        if (rng.isEmpty()) {
            return this;
        }
        PriceRange r1 = this.normalized();
        PriceRange r2 = rng.normalized();
        Price start = r2.start.compareTo(r1.start) > 0 ? r2.start() : r1.start();
        Price end = r2.end.compareTo(r1.end) < 0 ? r2.end() : r1.end();
        return new PriceRange(start, end).normalized();
    }

    public boolean contains(Price val) {
        if (this.isNormal()) {
            return val.compareTo(this.start) >= 0 && val.compareTo(this.end) <= 0;
        }
        return val.compareTo(this.start) <= 0 && val.compareTo(this.end) >= 0;
    }

    public boolean contains(PriceRange range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(PriceRange range) {
        return this.contains(range.start) || this.contains(range.end);
    }

    public boolean equals(PriceRange other) {
        return this.start == other.start() && this.end == other.end;
    }

    public boolean equals(Object other) {
        if (other instanceof PriceRange) {
            return this.equals((PriceRange)other);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() * 37 + this.end.hashCode();
    }

    public String toString() {
        return String.format("[%s, %s]", this.start, this.end);
    }
}

