/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public final class MathUtil {
    private MathUtil() {
    }

    public static final float RoundAwayFromZero(float value) {
        if (value < 0.0f) {
            return -1.0f * (float)Math.round(Math.abs(value));
        }
        return Math.round(value);
    }

    public static final double RoundAwayFromZero(double value) {
        if (value < 0.0) {
            return -1.0 * (double)Math.round(Math.abs(value));
        }
        return Math.round(value);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

