/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearRegression {
    private static final String TAG = "LinearRegression";
    private List<RegressionPoint> mPoints = new ArrayList<RegressionPoint>();
    boolean mComputed = false;
    double mB = 0.0;
    double mA = 0.0;
    double mStdDevX = 0.0;
    double mStdDevY = 0.0;
    double mStdError = 0.0;

    public LinearRegression() {
    }

    public LinearRegression(Collection<RegressionPoint> points) {
        this.mPoints.addAll(points);
        this.compute();
    }

    public boolean isComputed() {
        return this.mComputed;
    }

    public double b() {
        return this.mB;
    }

    public double a() {
        return this.mA;
    }

    public double stdDevX() {
        return this.mStdDevX;
    }

    public double stdDevY() {
        return this.mStdDevY;
    }

    public double stdError() {
        return this.mStdError;
    }

    public void addPoint(double x, double y) {
        this.mPoints.add(new RegressionPoint(this, x, y));
    }

    public double computeX(double y) {
        if (!this.mComputed || this.mB == 0.0) {
            return 0.0;
        }
        return (y - this.mA) / this.mB;
    }

    public double computeY(double x) {
        if (!this.mComputed) {
            return 0.0;
        }
        return this.mA + this.mB * x;
    }

    public void compute() {
        this.mComputed = false;
        this.mB = 0.0;
        this.mA = 0.0;
        try {
            if (this.mPoints.size() < 2) {
                Log.e(TAG, "compute(), Insufficient points to compute regression.");
                return;
            }
            double sumX = 0.0;
            double sumY = 0.0;
            double sumXY = 0.0;
            double sumXX = 0.0;
            double sumYY = 0.0;
            double n = this.mPoints.size();
            int i = 0;
            while ((double)i < n) {
                RegressionPoint pt = this.mPoints.get(i);
                sumX += pt.X;
                sumY += pt.Y;
                sumXY += pt.X * pt.Y;
                sumXX += pt.X * pt.X;
                sumYY += pt.Y * pt.Y;
                ++i;
            }
            this.mB = (n * sumXY - sumX * sumY) / (n * sumXX - sumX * sumX);
            this.mA = (sumY - this.b() * sumX) / n;
            double sumError = 0.0;
            int i2 = 0;
            while ((double)i2 < n) {
                RegressionPoint pt = this.mPoints.get(i2);
                double yreg = this.mA + this.mB * pt.X;
                double residual = pt.Y - yreg;
                sumError += residual * residual;
                ++i2;
            }
            this.mStdDevX = Math.sqrt((n * sumXX - sumX * sumX) / (n * n - 1.0));
            this.mStdDevY = Math.sqrt((n * sumYY - sumY * sumY) / (n * n - 1.0));
            this.mStdError = Math.sqrt(sumError / n);
            this.mComputed = true;
        }
        catch (Exception ex) {
            Log.e(TAG, "compute(), Computation Error.", ex);
        }
    }

    public class RegressionPoint {
        public final double X;
        public final double Y;

        public RegressionPoint(LinearRegression this$0, double x, double y) {
            this.X = x;
            this.Y = y;
        }
    }
}

