/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

public class IntRange {
    public int start;
    public int end;

    public static IntRange empty() {
        return new IntRange(0);
    }

    public static IntRange of(int start, int end) {
        return new IntRange(start, end);
    }

    public static IntRange of(int val) {
        return new IntRange(val);
    }

    public IntRange() {
        this.start = 0;
        this.end = 0;
    }

    public IntRange(int val) {
        this.start = val;
        this.end = val;
    }

    public IntRange(int rangeStart, int rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public boolean isEmpty() {
        return (float)this.start == 0.0f && (float)this.end == 0.0f;
    }

    public boolean isNormal() {
        return this.start <= this.end;
    }

    public void reverse() {
        int tmp = this.start;
        this.start = this.end;
        this.end = tmp;
    }

    public IntRange reversed() {
        return new IntRange(this.end, this.start);
    }

    public void normalize() {
        if (!this.isNormal()) {
            this.reverse();
        }
    }

    public IntRange normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public void expand(int val) {
        if (this.isNormal()) {
            this.start = Math.min(this.start, val);
            this.end = Math.max(this.end, val);
        } else {
            this.start = Math.max(this.start, val);
            this.end = Math.min(this.end, val);
        }
    }

    public IntRange expanded(int val) {
        return this.expanded(new IntRange(val));
    }

    public void expand(IntRange range) {
        this.expand(range.start);
        this.expand(range.end);
    }

    public IntRange expanded(IntRange range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        IntRange r1 = this.normalized();
        IntRange r2 = range.normalized();
        int ustart = r2.start < r1.start ? r2.start() : r1.start();
        int uend = r2.end > r1.end ? r2.end() : r1.end();
        return new IntRange(ustart, uend);
    }

    public IntRange condensed(IntRange rng) {
        if (rng.isEmpty()) {
            return this;
        }
        IntRange r1 = this.normalized();
        IntRange r2 = rng.normalized();
        int start = r2.start > r1.start ? r2.start : r1.start;
        int end = r2.end < r1.end ? r2.end : r1.end;
        return new IntRange(start, end).normalized();
    }

    public boolean contains(int val) {
        if (this.isNormal()) {
            return val >= this.start && val <= this.end;
        }
        return val <= this.start && val >= this.end;
    }

    public boolean contains(IntRange range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(IntRange range) {
        return this.contains(range.start) || this.contains(range.end);
    }

    public boolean equals(IntRange other) {
        return this.start == other.start() && this.end == other.end;
    }

    public boolean equals(Object other) {
        if (other instanceof IntRange) {
            return this.equals((IntRange)other);
        }
        return false;
    }

    public int hashCode() {
        return Integer.valueOf(this.start).hashCode() * 37 + Integer.valueOf(this.end).hashCode();
    }

    public String toString() {
        return String.format("[%d, %d]", this.start, this.end);
    }
}

