/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import java.util.concurrent.TimeUnit;

public class FreqCounterEMA {
    private final int n;
    private final double mult;
    private long lastNanos = 0L;
    private double avgNanos = 0.0;
    private boolean init = false;

    public FreqCounterEMA() {
        this(20);
    }

    public FreqCounterEMA(int periods) {
        this.n = periods;
        this.mult = 2.0 / ((double)this.n + 1.0);
    }

    public void increment() {
        long nanoTime = System.nanoTime();
        if (this.lastNanos == 0L) {
            this.lastNanos = nanoTime;
        } else if (!this.init) {
            this.avgNanos = nanoTime - this.lastNanos;
            this.lastNanos = nanoTime;
            this.init = true;
        } else {
            double diffNanos = nanoTime - this.lastNanos;
            this.avgNanos = (diffNanos - this.avgNanos) * this.mult + this.avgNanos;
            this.lastNanos = nanoTime;
        }
    }

    public void incrementBy(long nanos) {
        long nanoTime = nanos;
        if (this.lastNanos == 0L) {
            this.lastNanos = nanoTime;
        } else if (!this.init) {
            this.avgNanos = nanoTime - this.lastNanos;
            this.lastNanos = nanoTime;
            this.init = true;
        } else {
            double diffNanos = nanoTime - this.lastNanos;
            this.avgNanos = (diffNanos - this.avgNanos) * this.mult + this.avgNanos;
            this.lastNanos = nanoTime;
        }
    }

    public double getAvgRate() {
        if (!this.init) {
            return 0.0;
        }
        return 1.0 / (this.avgNanos / (double)TimeUnit.SECONDS.toNanos(1L));
    }
}

