/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import java.util.concurrent.TimeUnit;

public class FreqCounter {
    private final int n;
    private final long[] eventTimes;
    private long eventCount = 0L;
    private final double mult;

    public FreqCounter() {
        this(100);
    }

    public FreqCounter(int nseconds) {
        this.n = nseconds;
        this.eventTimes = new long[this.n];
        this.mult = 2.0 / ((double)this.n + 1.0);
    }

    public void increment() {
        long nanoTime = System.nanoTime();
        ++this.eventCount;
        this.eventTimes[(int)(this.eventCount % (long)this.n)] = nanoTime;
    }

    public void incrementBy(long nanos) {
        this.eventTimes[(int)(this.eventCount % (long)this.n)] = nanos;
        ++this.eventCount;
    }

    public double getAvgRate() {
        int f = (int)((this.eventCount - 1L) % (long)this.n);
        int s = 0;
        double c = (double)this.n - 1.0;
        if (this.eventCount >= (long)this.n) {
            s = (int)(this.eventCount % (long)this.n);
        } else {
            c = (double)this.eventCount - 1.0;
        }
        long diff = this.eventTimes[f] - this.eventTimes[s];
        double avg = c / ((double)diff / (double)TimeUnit.SECONDS.toNanos(1L));
        return avg;
    }

    public double getAvgRateEMA() {
        if (this.eventCount < (long)this.n) {
            return this.getAvgRate();
        }
        int s = (int)(this.eventCount % (long)this.n);
        long lastNanos = this.eventTimes[s];
        double avgNanos = 0.0;
        for (int j = 1; j < this.n; ++j) {
            int i = (s + j) % this.n;
            long diffNanos = this.eventTimes[i] - lastNanos;
            lastNanos = this.eventTimes[i];
            avgNanos = j == 1 ? (double)diffNanos : ((double)diffNanos - avgNanos) * this.mult + avgNanos;
        }
        return 1.0 / (avgNanos / (double)TimeUnit.SECONDS.toNanos(1L));
    }
}

