/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

public class FloatRange {
    public float start;
    public float end;

    public static FloatRange empty() {
        return new FloatRange(0.0f);
    }

    public static FloatRange of(float start, float end) {
        return new FloatRange(start, end);
    }

    public static FloatRange of(float val) {
        return new FloatRange(val);
    }

    public FloatRange() {
        this.start = 0.0f;
        this.end = 0.0f;
    }

    public FloatRange(float val) {
        this.start = val;
        this.end = val;
    }

    public FloatRange(float rangeStart, float rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public void set(float start, float end) {
        this.start = start;
        this.end = end;
    }

    public void set(FloatRange range) {
        this.start = range.start;
        this.end = range.end;
    }

    public float start() {
        return this.start;
    }

    public float end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start == 0.0f && this.end == 0.0f;
    }

    public boolean isNormal() {
        return this.start <= this.end;
    }

    public void reverse() {
        float tmp = this.start;
        this.start = this.end;
        this.end = tmp;
    }

    public FloatRange reversed() {
        return new FloatRange(this.end, this.start);
    }

    public void normalize() {
        if (!this.isNormal()) {
            this.reverse();
        }
    }

    public FloatRange normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public void expand(float val) {
        if (this.isNormal()) {
            this.start = Math.min(this.start, val);
            this.end = Math.max(this.end, val);
        } else {
            this.start = Math.max(this.start, val);
            this.end = Math.min(this.end, val);
        }
    }

    public FloatRange expanded(float val) {
        return this.expanded(new FloatRange(val));
    }

    public void expand(FloatRange range) {
        this.expand(range.start);
        this.expand(range.end);
    }

    public FloatRange expanded(FloatRange range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        FloatRange r1 = this.normalized();
        FloatRange r2 = range.normalized();
        float ustart = r2.start < r1.start ? r2.start() : r1.start();
        float uend = r2.end > r1.end ? r2.end() : r1.end();
        return new FloatRange(ustart, uend);
    }

    public FloatRange condensed(FloatRange rng) {
        if (rng.isEmpty()) {
            return this;
        }
        FloatRange r1 = this.normalized();
        FloatRange r2 = rng.normalized();
        float start = r2.start > r1.start ? r2.start : r1.start;
        float end = r2.end < r1.end ? r2.end : r1.end;
        return new FloatRange(start, end).normalized();
    }

    public boolean contains(float val) {
        if (this.isNormal()) {
            return val >= this.start && val <= this.end;
        }
        return val <= this.start && val >= this.end;
    }

    public boolean contains(FloatRange range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(FloatRange range) {
        return this.contains(range.start) || this.contains(range.end);
    }

    public boolean equals(FloatRange other) {
        return this.start == other.start() && this.end == other.end;
    }

    public boolean equals(Object other) {
        if (other instanceof FloatRange) {
            return this.equals((FloatRange)other);
        }
        return false;
    }

    public int hashCode() {
        return Float.valueOf(this.start).hashCode() * 37 + Float.valueOf(this.end).hashCode();
    }

    public String toString() {
        return String.format("[%f, %f]", Float.valueOf(this.start), Float.valueOf(this.end));
    }
}

