/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class EventBuffer<T> {
    private static final String TAG = "EventBuffer<>";
    public final Object lock = new Object();
    private final Consumer<Collection<T>> callback;
    private final int bufferMS;
    private List<T> pendingArgs = new ArrayList<T>();
    private long lastExecuted = System.nanoTime();
    ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public EventBuffer(Consumer<Collection<T>> runnable, int bufferMS) {
        this.callback = runnable;
        this.bufferMS = bufferMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.executor.shutdown();
            this.pendingArgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(T arg) {
        Object object = this.lock;
        synchronized (object) {
            long deltaMS = (System.nanoTime() - this.lastExecuted) / 1000000L;
            if (deltaMS < (long)this.bufferMS) {
                if (this.pendingArgs.size() == 0) {
                    this.pendingArgs.add(arg);
                    this.executor.schedule(this::onInterval, (long)this.bufferMS, TimeUnit.MILLISECONDS);
                } else {
                    this.pendingArgs.add(arg);
                }
            } else {
                Log.d(TAG, "run(), (%dms) **** Executing immediately", deltaMS);
                this.pendingArgs.add(arg);
                this.onInterval();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInterval() {
        Object object = this.lock;
        synchronized (object) {
            List<T> args = this.pendingArgs;
            this.pendingArgs = new ArrayList<T>();
            this.callback.accept(args);
            this.lastExecuted = System.nanoTime();
        }
    }
}

