/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.Log;
import com.t4login.definitions.priceconversion.Price;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class EncodingUtil {
    private EncodingUtil() {
    }

    public static byte[] encode7BitInt(int value) {
        if (value >= 0) {
            byte[] buffer = new byte[5];
            int n = 0;
            while (value >= 128) {
                buffer[n] = (byte)(value | 0x80);
                ++n;
                value >>= 7;
            }
            buffer[n] = (byte)value;
            byte[] retbuf = new byte[++n];
            System.arraycopy(buffer, 0, retbuf, 0, n);
            return retbuf;
        }
        byte[] buffer = new byte[]{(byte)(value | 0x80), (byte)((value >>= 7) | 0x80), (byte)((value >>= 7) | 0x80), (byte)((value >>= 7) | 0x80), (byte)((value >>= 7) & 0xF)};
        return buffer;
    }

    public static byte[] encode7BitLong(long value) {
        if (value >= 0L) {
            byte[] buffer = new byte[9];
            int n = 0;
            while (value >= 128L) {
                buffer[n] = (byte)(value | 0x80L);
                ++n;
                value >>= 7;
            }
            buffer[n] = (byte)value;
            byte[] retbuf = new byte[++n];
            System.arraycopy(buffer, 0, retbuf, 0, n);
            return retbuf;
        }
        byte[] buffer = new byte[]{(byte)(value | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) | 0x80L), (byte)((value >>= 7) & 0xFL)};
        return buffer;
    }

    public static void encode7BitInt(int value, OutputStream out) {
        try {
            if (value >= 0) {
                while (value >= 128) {
                    out.write((byte)(value | 0x80));
                    value >>= 7;
                }
                out.write((byte)value);
            } else {
                out.write((byte)(value | 0x80));
                out.write((byte)((value >>= 7) | 0x80));
                out.write((byte)((value >>= 7) | 0x80));
                out.write((byte)((value >>= 7) | 0x80));
                out.write((byte)((value >>= 7) & 0xF));
            }
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "encode7BitInt(), IO error.", ioex);
        }
    }

    public static void encode7BitLong(long value, OutputStream out) {
        try {
            if (value >= 0L) {
                while (value >= 128L) {
                    out.write((byte)(value | 0x80L));
                    value >>= 7;
                }
                out.write((byte)value);
            } else {
                out.write((byte)(value | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) | 0x80L));
                out.write((byte)((value >>= 7) & 0xFL));
            }
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "encode7BitLong(), IO error.", ioex);
        }
    }

    public static int decode7BitInt(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return EncodingUtil.decode7BitInt(in);
    }

    public static long decode7BitLong(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return EncodingUtil.decode7BitLong(in);
    }

    public static int decode7BitInt(InputStream in) {
        int count = 0;
        int shift = 0;
        try {
            int b;
            do {
                b = in.read();
                count |= (b & 0x7F) << shift;
                shift += 7;
            } while ((b & 0x80) != 0);
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "decode7BitInt(), IO error.", ioex);
        }
        return count;
    }

    public static long decode7BitLong(InputStream in) {
        long count = 0L;
        long shift = 0L;
        try {
            byte b;
            do {
                b = (byte)in.read();
                count |= (long)(b & 0x7F) << (int)shift;
                shift += 7L;
            } while ((b & 0x80) != 0);
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "decode7BitLong(), IO error.", ioex);
        }
        return count;
    }

    public static byte[] encodeDecimal(BigDecimal value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EncodingUtil.encodeDecimal(value, outputStream);
        return outputStream.toByteArray();
    }

    public static void encodeDecimal(BigDecimal value, OutputStream out) {
        int[] priceBits = new int[4];
        priceBits[3] = value.scale() << 16;
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            priceBits[3] = priceBits[3] | Integer.MIN_VALUE;
        }
        BigInteger mask = new BigInteger(new byte[]{-1, -1, -1, -1});
        BigInteger unscaled = value.unscaledValue().abs();
        priceBits[2] = unscaled.shiftRight(64).intValue();
        priceBits[1] = unscaled.and(mask.shiftLeft(32)).shiftRight(32).intValue();
        priceBits[0] = unscaled.and(mask).intValue();
        int hdr = 0;
        hdr = (byte)(hdr | (priceBits[0] == Integer.MIN_VALUE ? 192 : (priceBits[0] < 0 ? 128 : (priceBits[0] > 0 ? 64 : 0))));
        hdr = (byte)(hdr | (priceBits[1] == Integer.MIN_VALUE ? 48 : (priceBits[1] < 0 ? 32 : (priceBits[1] > 0 ? 16 : 0))));
        hdr = (byte)(hdr | (priceBits[2] == Integer.MIN_VALUE ? 12 : (priceBits[2] < 0 ? 8 : (priceBits[2] > 0 ? 4 : 0))));
        hdr = (byte)(hdr | (priceBits[3] == Integer.MIN_VALUE ? 3 : (priceBits[3] < 0 ? 2 : (priceBits[3] > 0 ? 1 : 0))));
        try {
            out.write(hdr);
            if (priceBits[0] != 0 && priceBits[0] != Integer.MIN_VALUE) {
                EncodingUtil.encode7BitInt(Math.abs(priceBits[0]), out);
            }
            if (priceBits[1] != 0 && priceBits[1] != Integer.MIN_VALUE) {
                EncodingUtil.encode7BitInt(Math.abs(priceBits[1]), out);
            }
            if (priceBits[2] != 0 && priceBits[2] != Integer.MIN_VALUE) {
                EncodingUtil.encode7BitInt(Math.abs(priceBits[2]), out);
            }
            if (priceBits[3] != 0 && priceBits[3] != Integer.MIN_VALUE) {
                EncodingUtil.encode7BitInt(Math.abs(priceBits[3]), out);
            }
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "encodeDecimal(), IO error.", ioex);
        }
    }

    public static BigDecimal decodeDecimal(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return EncodingUtil.decodeDecimal(in);
    }

    public static BigDecimal decodeDecimal(InputStream in) {
        int[] priceBits = new int[4];
        try {
            int hdr = in.read();
            if ((hdr & 0xC0) == 192) {
                priceBits[0] = Integer.MIN_VALUE;
            } else if ((hdr & 0x80) == 128) {
                priceBits[0] = -1 * EncodingUtil.decode7BitInt(in);
            } else if ((hdr & 0x40) == 64) {
                priceBits[0] = EncodingUtil.decode7BitInt(in);
            }
            if ((hdr & 0x30) == 48) {
                priceBits[1] = Integer.MIN_VALUE;
            } else if ((hdr & 0x20) == 32) {
                priceBits[1] = -1 * EncodingUtil.decode7BitInt(in);
            } else if ((hdr & 0x10) == 16) {
                priceBits[1] = EncodingUtil.decode7BitInt(in);
            }
            if ((hdr & 0xC) == 12) {
                priceBits[2] = Integer.MIN_VALUE;
            } else if ((hdr & 8) == 8) {
                priceBits[2] = -1 * EncodingUtil.decode7BitInt(in);
            } else if ((hdr & 4) == 4) {
                priceBits[2] = EncodingUtil.decode7BitInt(in);
            }
            if ((hdr & 3) == 3) {
                priceBits[3] = Integer.MIN_VALUE;
            } else if ((hdr & 2) == 2) {
                priceBits[3] = -1 * EncodingUtil.decode7BitInt(in);
            } else if ((hdr & 1) == 1) {
                priceBits[3] = EncodingUtil.decode7BitInt(in);
            }
            BigInteger int2 = BigInteger.valueOf((long)priceBits[2] & 0xFFFFFFFFL).shiftLeft(32);
            BigInteger int1 = int2.add(BigInteger.valueOf((long)priceBits[1] & 0xFFFFFFFFL)).shiftLeft(32);
            BigInteger integer = int1.add(BigInteger.valueOf((long)priceBits[0] & 0xFFFFFFFFL));
            BigDecimal decimal = new BigDecimal(integer, (priceBits[3] & 0xFF0000) >> 16);
            if (priceBits[3] < 0) {
                decimal = decimal.negate();
            }
            return decimal;
        }
        catch (IOException ioex) {
            Log.e("EncodingUtil", "decodeDecimal(), IO error.", ioex);
            return BigDecimal.ZERO;
        }
    }

    public static Price decodePrice(InputStream in) {
        return new Price(EncodingUtil.decodeDecimal(in));
    }

    public static Price decodePriceN(InputStream in) {
        try {
            int hdr = in.read();
            if ((hdr & 1) == 1) {
                return new Price(EncodingUtil.decodeDecimal(in).setScale(18, RoundingMode.HALF_EVEN));
            }
            return null;
        }
        catch (IOException e) {
            Log.e("EncodingUtil", "decodePriceN(), IO error.", e);
            return null;
        }
    }
}

