/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

public class DoubleRange {
    public double start;
    public double end;

    public static DoubleRange empty() {
        return new DoubleRange(0.0);
    }

    public static DoubleRange of(double start, double end) {
        return new DoubleRange(start, end);
    }

    public static DoubleRange of(double val) {
        return new DoubleRange(val);
    }

    public DoubleRange() {
        this.start = 0.0;
        this.end = 0.0;
    }

    public DoubleRange(double val) {
        this.start = val;
        this.end = val;
    }

    public DoubleRange(double rangeStart, double rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public void set(double start, double end) {
        this.start = start;
        this.end = end;
    }

    public void set(DoubleRange range) {
        this.start = range.start;
        this.end = range.end;
    }

    public double start() {
        return this.start;
    }

    public double end() {
        return this.end;
    }

    public boolean isEmpty() {
        return this.start == 0.0 && this.end == 0.0;
    }

    public boolean isNormal() {
        return this.start <= this.end;
    }

    public void reverse() {
        double tmp = this.start;
        this.start = this.end;
        this.end = tmp;
    }

    public DoubleRange reversed() {
        return new DoubleRange(this.end, this.start);
    }

    public void normalize() {
        if (!this.isNormal()) {
            this.reverse();
        }
    }

    public DoubleRange normalized() {
        if (!this.isNormal()) {
            return this.reversed();
        }
        return this;
    }

    public void expand(double val) {
        if (this.isNormal()) {
            this.start = Math.min(this.start, val);
            this.end = Math.max(this.end, val);
        } else {
            this.start = Math.max(this.start, val);
            this.end = Math.min(this.end, val);
        }
    }

    public DoubleRange expanded(double val) {
        return this.expanded(new DoubleRange(val));
    }

    public void expand(DoubleRange range) {
        this.expand(range.start);
        this.expand(range.end);
    }

    public DoubleRange expanded(DoubleRange range) {
        if (this.isEmpty() && !range.isEmpty()) {
            return range.normalized();
        }
        if (!this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        if (this.isEmpty() && range.isEmpty()) {
            return this.normalized();
        }
        DoubleRange r1 = this.normalized();
        DoubleRange r2 = range.normalized();
        double ustart = r2.start < r1.start ? r2.start() : r1.start();
        double uend = r2.end > r1.end ? r2.end() : r1.end();
        return new DoubleRange(ustart, uend);
    }

    public DoubleRange condensed(DoubleRange rng) {
        if (rng.isEmpty()) {
            return this;
        }
        DoubleRange r1 = this.normalized();
        DoubleRange r2 = rng.normalized();
        double start = r2.start > r1.start ? r2.start : r1.start;
        double end = r2.end < r1.end ? r2.end : r1.end;
        return new DoubleRange(start, end).normalized();
    }

    public boolean contains(double val) {
        if (this.isNormal()) {
            return val >= this.start && val <= this.end;
        }
        return val <= this.start && val >= this.end;
    }

    public boolean contains(DoubleRange range) {
        return this.contains(range.start) && this.contains(range.end);
    }

    public boolean intersects(DoubleRange range) {
        return this.contains(range.start) || this.contains(range.end);
    }

    public boolean equals(DoubleRange other) {
        return this.start == other.start() && this.end == other.end;
    }

    public boolean equals(Object other) {
        if (other instanceof DoubleRange) {
            return this.equals((DoubleRange)other);
        }
        return false;
    }

    public int hashCode() {
        return Float.valueOf((float)this.start).hashCode() * 37 + Float.valueOf((float)this.end).hashCode();
    }

    public String toString() {
        return String.format("[%f, %f]", this.start, this.end);
    }
}

