/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.util;

import com.t4login.connection.CountingInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class CryptoUtil {
    private static final byte DER_TAG_INTEGER = 2;
    private static final byte DER_TAG_BIT_STRING = 3;
    private static final byte DER_TAG_OCTET_STRING = 4;
    private static final byte DER_TAG_OBJECT_IDENTIFIER = 6;
    private static final byte DER_TAG_SEQUENCE = 48;
    private static final byte[] OBJECT_IDENTIFIER_RSAENCRYPT = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] OBJECT_IDENTIFIER_ECDH_ECDSA = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDH256 = new byte[]{69, 67, 75, 49};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDH384 = new byte[]{69, 67, 75, 51};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDH521 = new byte[]{69, 67, 75, 53};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDSA256 = new byte[]{69, 67, 83, 49};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDSA384 = new byte[]{69, 67, 83, 51};
    private static final byte[] BCRYPT_MAGIC_NUMBER_ECDSA521 = new byte[]{69, 67, 83, 53};

    private CryptoUtil() {
    }

    public static PublicKeyRawData decodeX509SubjectPublicKeyInfo(byte[] keyBytes) throws IOException {
        ByteArrayInputStream inBytes = new ByteArrayInputStream(keyBytes);
        CountingInputStream in = new CountingInputStream(inBytes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (in.read() != 48) {
            throw new IOException("Invalid DER header. Expected 0x30 SEQUENCE.");
        }
        CryptoUtil.readASN1TagLength(in);
        if (in.read() != 48) {
            throw new IOException("DER container does not contain SubjectPublicKeyInfo.");
        }
        int algorithmInformationLength = CryptoUtil.readASN1TagLength(in);
        in.resetCount();
        if (in.read() != 6) {
            throw new IOException("DER container does not contain SubjectPublicKeyInfo (algorithm information missing)");
        }
        int oidLength = CryptoUtil.readASN1TagLength(in);
        byte[] oidRaw = new byte[oidLength];
        if (in.read(oidRaw, 0, oidLength) != oidLength) {
            throw new IOException("DER container does not contain SubjectPublicKeyInfo (algorithm information corrupt)");
        }
        in.skip((long)algorithmInformationLength - in.getCount());
        X509Algorithm algorithm = X509Algorithm.Unknown;
        if (Arrays.equals(OBJECT_IDENTIFIER_RSAENCRYPT, oidRaw)) {
            return PublicKeyRawData.decodeRSA(in);
        }
        if (Arrays.equals(OBJECT_IDENTIFIER_ECDH_ECDSA, oidRaw)) {
            return PublicKeyRawData.decodeECDSA(in);
        }
        throw new IOException("Could not parse public key: unsupported algorithm");
    }

    public static byte[] decodeECDSADERSignature(byte[] signature) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(signature);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (in.read() != 48) {
            throw new IOException("Invalid DER header. Expected 0x30 SEQUENCE.");
        }
        CryptoUtil.readASN1TagLength(in);
        if (in.read() != 2) {
            throw new IOException("Invalid DER format.");
        }
        int rLen = CryptoUtil.readASN1TagLength(in);
        byte[] r = new byte[rLen];
        in.read(r, 0, rLen);
        if (r[0] == 0 && (r[1] & 0x80) != 0) {
            out.write(r, 1, r.length - 1);
        } else {
            out.write(r);
        }
        if (in.read() != 2) {
            throw new IOException("Invalid DER format.");
        }
        int sLen = CryptoUtil.readASN1TagLength(in);
        byte[] s = new byte[sLen];
        in.read(s, 0, sLen);
        if (s[0] == 0 && (s[1] & 0x80) != 0) {
            out.write(s, 1, s.length - 1);
        } else {
            out.write(s);
        }
        return out.toByteArray();
    }

    private static int readASN1TagLength(InputStream in) throws IOException {
        int len = in.read();
        if ((len & 0x80) != 0) {
            int trail = len & 0xF;
            if (trail > 4) {
                throw new IOException("Tag lengths exceeding 4 bytes are not supported.");
            }
            byte[] buff = new byte[4];
            if (in.read(buff, 0, 4) != trail) {
                throw new IOException("ASN.1 encoded tag length could not be read.");
            }
            len = ByteBuffer.wrap(buff).getInt();
        }
        return len;
    }

    public static byte[] decodeRawECDSA256PublicKey(byte[] raw) throws IOException {
        if (raw == null || raw.length != 65) {
            throw new IOException("Invalid key format.");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(raw);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int format = in.read();
        if (format != 4) {
            throw new IOException("Invalid key format.");
        }
        out.write(BCRYPT_MAGIC_NUMBER_ECDSA256);
        out.write(32);
        out.write(0);
        out.write(0);
        out.write(0);
        byte[] key = new byte[64];
        in.read(key, 0, 64);
        out.write(key);
        return out.toByteArray();
    }

    public static enum X509Algorithm {
        Unknown,
        RSA,
        ECDH_ECDSA_256,
        ECDH_ECDSA_384,
        ECDH_ECDSA_521;

    }

    public static final class PublicKeyRawData {
        public final X509Algorithm algorithm;
        public final byte[] encodedBytes;

        public PublicKeyRawData(X509Algorithm alg, byte[] bytes) {
            this.algorithm = alg;
            this.encodedBytes = bytes;
        }

        private static PublicKeyRawData decodeRSA(InputStream in) throws IOException {
            return null;
        }

        private static PublicKeyRawData decodeECDSA(InputStream in) throws IOException {
            X509Algorithm algorithm;
            if (in.read() != 3) {
                throw new IOException("DER container does not contain SubjectPublicKeyInfo (ECDSA public key data is missing)");
            }
            int eccPointLength = CryptoUtil.readASN1TagLength(in);
            in.read();
            if (in.read() != 4) {
                throw new IOException("DER container does not contain SubjectPublicKeyInfo (ECDSA public key data is corrupt)");
            }
            byte[] eccPoint = new byte[eccPointLength -= 2];
            if (in.read(eccPoint, 0, eccPointLength) != eccPointLength) {
                throw new IOException("DER container does not contain SubjectPublicKeyInfo (ECDSA public key data is corrupt)");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            switch (eccPointLength) {
                case 64: {
                    algorithm = X509Algorithm.ECDH_ECDSA_256;
                    out.write(BCRYPT_MAGIC_NUMBER_ECDSA256);
                    out.write(32);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(eccPoint);
                    break;
                }
                case 96: {
                    algorithm = X509Algorithm.ECDH_ECDSA_384;
                    out.write(BCRYPT_MAGIC_NUMBER_ECDSA384);
                    out.write(48);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(eccPoint);
                    break;
                }
                case 130: {
                    algorithm = X509Algorithm.ECDH_ECDSA_521;
                    out.write(BCRYPT_MAGIC_NUMBER_ECDSA521);
                    out.write(65);
                    out.write(0);
                    out.write(0);
                    out.write(0);
                    out.write(eccPoint);
                    break;
                }
                default: {
                    throw new IOException("Could not parse ECDH / ECDSA public key: unsupported key-size or compressed key format");
                }
            }
            return new PublicKeyRawData(algorithm, out.toByteArray());
        }
    }
}

