/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.remoteservices.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.t4login.Log;
import com.t4login.api.MarketPickerGroup;
import com.t4login.api.MarketPickerGroupDeserializer;
import com.t4login.api.MarketPickerMarket;
import com.t4login.api.MarketPickerMarketDeserializer;
import com.t4login.api.T4HostService;
import com.t4login.connection.IMessageHandler;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.messages.Message;
import com.t4login.messages.MsgAuthenticationTokenRequest;
import com.t4login.messages.MsgAuthenticationTokenResponse;
import com.t4login.messages.MsgMarketDetails;
import com.t4login.remoteservices.model.MarketResponse;
import com.t4login.remoteservices.model.MarketResponseDeserializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class T4MarketsService
implements IMessageHandler {
    private static final String TAG = "T4MarketsService";
    public static final Gson gson;
    private final T4HostService service;
    private String jwtToken;
    private NDateTime tokenExpiryUTC = NDateTime.MinValue;
    private boolean isRefreshingToken = false;

    public T4MarketsService(T4HostService s) {
        this.service = s;
        this.service.registerMessageHandler(this);
    }

    public void destroy() {
        this.service.unregisterMessageHandler(this);
    }

    @Override
    public void onMessage(Message msg) {
        switch (msg.getMessageType()) {
            case AuthenticationTokenResponse: {
                this.processAuthenticationTokenResponse((MsgAuthenticationTokenResponse)msg);
            }
        }
    }

    private synchronized void processAuthenticationTokenResponse(MsgAuthenticationTokenResponse msg) {
        if (msg.Token.length() > 0) {
            this.jwtToken = msg.Token;
            this.tokenExpiryUTC = msg.ExpiresUTC;
            Log.d(TAG, "processAuthenticationTokenResponse(), Auth token reqponse received. Token: %s", msg.Token.substring(0, 20));
        } else if (msg.FailureReason.length() > 0) {
            Log.e(TAG, "processAuthenticationTokenResponse(), Request failed: " + msg.FailureReason);
        }
        this.isRefreshingToken = false;
        this.notifyAll();
    }

    private synchronized void refreshJwtToken() {
        if (!this.isRefreshingToken) {
            this.isRefreshingToken = true;
            MsgAuthenticationTokenRequest req = new MsgAuthenticationTokenRequest();
            req.UserID = this.service.getUserData().getUser().getUserID();
            this.service.sendMessage(req);
            Log.d(TAG, "refreshJwtToken(), Auth token request sent for userid %s", req.UserID);
        }
    }

    private synchronized void checkAndRefreshTokenIfNeeded() {
        if (NDateTime.utcNow().AddSeconds(30.0).isAfter(this.tokenExpiryUTC)) {
            if (this.isRefreshingToken) {
                Log.d(TAG, "checkAndRefreshTokenIfNeeded(), Auth token is not valid and a refresh is in progress. Waiting...");
            } else {
                Log.d(TAG, "checkAndRefreshTokenIfNeeded(), Auth token is not valid, Refreshing from the host.");
                this.refreshJwtToken();
            }
            try {
                this.wait();
                Log.d(TAG, "checkAndRefreshTokenIfNeeded(), Auth token refreshed, continuing.");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Log.e(TAG, "checkAndRefreshTokenIfNeeded(), Threead interuption while refreshing auth token.");
            }
        }
    }

    public List<MarketPickerGroup> requestMarketPickerGroups(String exchangeID, String contractID) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/picker/groups?exchangeid=%s&contractid=%s", baseURL, exchangeIDEnc, contractIDEnc);
        Log.d(TAG, "requestMarketPickerGroups(), [e: %s, c: %s], GET: %s", exchangeID, contractID, urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "requestMarketPickerGroups(), [e: %s, c: %s], Status: %d", exchangeID, contractID, status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                long responseTimeMS = System.currentTimeMillis() - startTime;
                int responseSize = content.length();
                Log.d(TAG, "requestMarketPickerGroups(), [e: %s, c: %s], Completed in %d ms, %d bytes", exchangeID, contractID, responseTimeMS, responseSize);
                Type listType = new TypeToken<List<MarketPickerGroup>>(this){}.getType();
                List marketPickerGroups = (List)gson.fromJson(content.toString(), listType);
                return marketPickerGroups;
            }
            Log.e(TAG, "requestMarketPickerGroups(), [e: %s, c: %s], Request Failed. GET: %s", exchangeID, contractID, urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "requestMarketPickerGroups(), [e: %s, c: %s], GET: %s, Failed: %s", exchangeID, contractID, urlString, e.toString());
            return null;
        }
    }

    public List<MarketPickerMarket> requestMarketPickerList(String exchangeID, String contractID, MarketPickerGroup group) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String strategyTypeEnc = URLEncoder.encode(group.StrategyType.name(), StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/picker?exchangeid=%s&contractid=%s&strategytype=%s", baseURL, exchangeIDEnc, contractIDEnc, strategyTypeEnc);
        Log.d(TAG, "requestMarketPickerList(), [e: %s, c: %s, st: %s], GET: %s", exchangeID, contractID, group.StrategyType.name(), urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "requestMarketPickerList(), [e: %s, c: %s, st: %s], Status: %d", exchangeID, contractID, group.StrategyType.name(), status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                long responseTimeMS = System.currentTimeMillis() - startTime;
                int responseSize = content.length();
                Log.d(TAG, "requestMarketPickerList(), [e: %s, c: %s, st: %s], Completed in %d ms, %d bytes", exchangeID, contractID, group.StrategyType.name(), responseTimeMS, responseSize);
                Type listType = new TypeToken<List<MarketPickerMarket>>(this){}.getType();
                List marketPickerMarkets = (List)gson.fromJson(content.toString(), listType);
                return marketPickerMarkets;
            }
            Log.e(TAG, "requestMarketPickerList(), [e: %s, c: %s, st: %s], Request Failed. GET: %s", exchangeID, contractID, group.StrategyType.name(), urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "requestMarketPickerList(), [e: %s, c: %s, st: %s], GET: %s, Failed: %s", exchangeID, contractID, group.StrategyType.name(), urlString, e.toString());
            return null;
        }
    }

    public MarketResponse getFirstMarket(String exchangeID, String contractID, ContractType contractType, StrategyType strategyType) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String contractNameEnc = URLEncoder.encode(contractType.name(), StandardCharsets.UTF_8);
        String strategyTypeEnc = URLEncoder.encode(strategyType.name(), StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/picker/firstmarket?exchangeid=%s&contractid=%s&contractType=%s&strategytype=%s", baseURL, exchangeIDEnc, contractIDEnc, contractNameEnc, strategyTypeEnc);
        Log.d(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], GET: %s", exchangeID, contractID, contractType.name(), strategyType.name(), urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], Status: %d", exchangeID, contractID, contractType.name(), strategyType.name(), status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                long responseTimeMS = System.currentTimeMillis() - startTime;
                int responseSize = content.length();
                Log.d(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], Completed in %d ms, %d bytes", exchangeID, contractID, contractType.name(), strategyType.name(), responseTimeMS, responseSize);
                MarketResponse market = (MarketResponse)gson.fromJson(content.toString(), MarketResponse.class);
                return market;
            }
            Log.e(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], Request Failed. GET: %s", exchangeID, contractID, contractType.name(), strategyType.name(), urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "getFirstMarket(), [e: %s, c: %s, ct: %s, st: %s], GET: %s, Failed: %s", exchangeID, contractID, contractType.name(), strategyType.name(), urlString, e.toString());
            return null;
        }
    }

    public MarketResponse getNextMarket(String exchangeID, String contractID, String marketID) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String marketIDEnc = URLEncoder.encode(marketID, StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/picker/nextmarket?exchangeid=%s&contractid=%s&marketid=%s", baseURL, exchangeIDEnc, contractIDEnc, marketIDEnc);
        Log.d(TAG, "getNextMarket(), [e: %s, c: %s, m: %s], GET: %s", exchangeID, contractID, marketID, urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "getNextMarket(), [e: %s, c: %s, m: %s], Status: %d", exchangeID, contractID, marketID, status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                long responseTimeMS = System.currentTimeMillis() - startTime;
                int responseSize = content.length();
                Log.d(TAG, "getNextMarket(), [e: %s, c: %s, m: %s], Completed in %d ms, %d bytes", exchangeID, contractID, marketID, responseTimeMS, responseSize);
                MarketResponse market = (MarketResponse)gson.fromJson(content.toString(), MarketResponse.class);
                return market;
            }
            Log.e(TAG, "getNextMarket(), [e: %s, c: %s, m: %s], Request Failed. GET: %s", exchangeID, contractID, marketID, urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "getNextMarket(), [e: %s, c: %s, m: %s], GET: %s, Failed: %s", exchangeID, contractID, marketID, urlString, e.toString());
            return null;
        }
    }

    public MarketResponse getNextExpiry(String exchangeID, String contractID, String marketID) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String marketIDEnc = URLEncoder.encode(marketID, StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/picker/nextexpiry?exchangeid=%s&contractid=%s&marketid=%s", baseURL, exchangeIDEnc, contractIDEnc, marketIDEnc);
        Log.d(TAG, "getNextExpiry(), [e: %s, c: %s, m: %s], GET: %s", exchangeID, contractID, marketID, urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "getNextExpiry(), [e: %s, c: %s, m: %s], Status: %d", exchangeID, contractID, marketID, status);
            if (status == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder content = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    content.append(inputLine);
                }
                in.close();
                long responseTimeMS = System.currentTimeMillis() - startTime;
                int responseSize = content.length();
                Log.d(TAG, "getNextExpiry(), [e: %s, c: %s, m: %s], Completed in %d ms, %d bytes", exchangeID, contractID, marketID, responseTimeMS, responseSize);
                MarketResponse market = (MarketResponse)gson.fromJson(content.toString(), MarketResponse.class);
                return market;
            }
            Log.e(TAG, "getNextExpiry(), [e: %s, c: %s, m: %s], Request Failed. GET: %s", exchangeID, contractID, marketID, urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "getNextExpiry(), [e: %s, c: %s, m: %s], GET: %s, Failed: %s", exchangeID, contractID, marketID, urlString, e.toString());
            return null;
        }
    }

    public MsgMarketDetails getMarketDefinition(String exchangeID, String contractID, String marketID) {
        this.checkAndRefreshTokenIfNeeded();
        String baseURL = this.service.getUserData().getServerType().getAPIBaseURL();
        String exchangeIDEnc = URLEncoder.encode(exchangeID, StandardCharsets.UTF_8);
        String contractIDEnc = URLEncoder.encode(contractID, StandardCharsets.UTF_8);
        String marketIDEnc = URLEncoder.encode(marketID, StandardCharsets.UTF_8);
        String urlString = String.format("%s/markets/marketdetails?exchangeid=%s&contractid=%s&marketid=%s", baseURL, exchangeIDEnc, contractIDEnc, marketIDEnc);
        Log.d(TAG, "getMarketDefinition(), [e: %s, c: %s, m: %s], GET: %s", exchangeID, contractID, marketID, urlString);
        long startTime = System.currentTimeMillis();
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer " + this.jwtToken);
            connection.setRequestProperty("Accept", "application/octet-stream");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.d(TAG, "getMarketDefinition(), [e: %s, c: %s, m: %s], Status: %d", exchangeID, contractID, marketID, status);
            if (status == 200) {
                Message msg = Message.getMessage(connection.getInputStream());
                return (MsgMarketDetails)msg;
            }
            Log.e(TAG, "getMarketDefinition(), [e: %s, c: %s, m: %s], Request Failed. GET: %s", exchangeID, contractID, marketID, urlString);
            return null;
        }
        catch (IOException e) {
            Log.e(TAG, "getMarketDefinition(), [e: %s, c: %s, m: %s], GET: %s, Failed: %s", exchangeID, contractID, marketID, urlString, e.toString());
            return null;
        }
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(MarketPickerMarket.class, (Object)new MarketPickerMarketDeserializer()).registerTypeAdapter(MarketPickerGroup.class, (Object)new MarketPickerGroupDeserializer()).registerTypeAdapter(MarketResponse.class, (Object)new MarketResponseDeserializer()).registerTypeAdapter(ContractType.class, (json, typeOfT, context) -> ContractType.valueOf(json.getAsString())).registerTypeAdapter(StrategyType.class, (json, typeOfT, context) -> StrategyType.valueOf(json.getAsString()));
        gson = gsonBuilder.create();
    }
}

