/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.remoteservices.model;

import com.t4login.messages.Message;
import com.t4login.messages.MessageArray;
import com.t4login.messages.MessageType;
import com.t4login.messages.MsgCompressed;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class OrderHistoryResponse {
    public int version;
    public int start;
    public int count;
    public int totalCount;
    public List<Message> messages;

    public static OrderHistoryResponse fromData(InputStream in) throws IOException {
        int ver = Message.read7BitInteger(in);
        int start = Message.read7BitInteger(in);
        int count = Message.read7BitInteger(in);
        int totalCount = Message.read7BitInteger(in);
        short msgTypeVal = Message.readShort(in);
        MessageType msgType = MessageType.get(msgTypeVal);
        short msgVer = Message.readShort(in);
        int msgLen = Message.readInteger(in);
        byte[] data = new byte[msgLen];
        in.read(data, 0, msgLen);
        MsgCompressed msgCompressed = (MsgCompressed)Message.getMessage(msgType, msgVer, data);
        MessageArray msgArray = (MessageArray)msgCompressed.PackedMessage;
        List<Message> messages = msgArray.getMessages();
        for (Message msg : messages) {
            msg.TagData1 = "history";
        }
        OrderHistoryResponse response = new OrderHistoryResponse();
        response.version = ver;
        response.start = start;
        response.count = count;
        response.totalCount = totalCount;
        response.messages = messages;
        return response;
    }
}

