/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.remoteservices.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.StrategyType;
import com.t4login.remoteservices.model.MarketResponse;
import java.lang.reflect.Type;

public class MarketResponseDeserializer
implements JsonDeserializer<MarketResponse> {
    public MarketResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String exchangeID = jsonObject.get("exchangeID").getAsString();
        String contractID = jsonObject.get("contractID").getAsString();
        String marketID = jsonObject.get("marketID").getAsString();
        String description = jsonObject.get("description").getAsString();
        int expiryDate = jsonObject.get("expiryDate").getAsInt();
        ContractType contractType = ContractType.valueOf(jsonObject.get("contractType").getAsString());
        StrategyType strategyType = StrategyType.valueOf(jsonObject.get("strategyType").getAsString());
        NDateTime lastTradingDate = NDateTime.fromDateString(jsonObject.get("lastTradingDate").getAsString());
        return new MarketResponse(exchangeID, contractID, marketID, description, expiryDate, contractType, strategyType, lastTradingDate);
    }
}

