/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.definitions.ThreeState;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MsgUserMessagingToken
extends Message {
    public boolean Success = false;
    public String UserID = "";
    public String DeviceID = "";
    public String MessaginToken = "";
    public byte[] MessagingPKey = new byte[0];
    public ThreeState DeliverPositionUpdates = ThreeState.NotSpecified;
    public String ConfigJSON = "";
    public ThreeState DeliverUserAlerts = ThreeState.NotSpecified;

    public MsgUserMessagingToken() {
        super(MessageType.UserMessagingToken);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.Success = MsgUserMessagingToken.readBooleanAlt(in);
        this.UserID = MsgUserMessagingToken.readString(in);
        this.DeviceID = MsgUserMessagingToken.readString(in);
        this.MessaginToken = MsgUserMessagingToken.readString(in);
        int len = MsgUserMessagingToken.readInteger(in);
        this.MessagingPKey = new byte[len];
        MsgUserMessagingToken.fillBuffer(in, this.MessagingPKey);
        this.DeliverPositionUpdates = ThreeState.get(MsgUserMessagingToken.readIntBytes(in, 1));
        this.DeliverUserAlerts = ThreeState.get(MsgUserMessagingToken.readIntBytes(in, 1));
        this.ConfigJSON = MsgUserMessagingToken.readString(in);
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgUserMessagingToken.writeBooleanAlt(out, this.Success);
        MsgUserMessagingToken.writeString(out, this.UserID);
        MsgUserMessagingToken.writeString(out, this.DeviceID);
        MsgUserMessagingToken.writeString(out, this.MessaginToken);
        MsgUserMessagingToken.writeInteger(out, this.MessagingPKey.length);
        out.write(this.MessagingPKey);
        this.writeIntBytes(out, this.DeliverPositionUpdates.getValue(), 1);
        this.writeIntBytes(out, this.DeliverUserAlerts.getValue(), 1);
        MsgUserMessagingToken.writeString(out, this.ConfigJSON);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgUserMessagingToken[");
        sb.append("Success: ").append(this.Success).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("DeviceID: ").append(this.DeviceID).append(", ");
        sb.append("MessaginToken: ").append(this.MessaginToken).append(", ");
        sb.append("MessagingPKey: ").append(Base64.encodeBytes(this.MessagingPKey));
        sb.append("DeliverPositionUpdates: ").append(this.DeliverPositionUpdates).append(", ");
        sb.append("DeliverUserAlerts: ").append(this.DeliverUserAlerts).append(", ");
        sb.append("ConfigJSON: ").append(this.ConfigJSON);
        sb.append("]");
        return sb.toString();
    }
}

