/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AccountCode;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.ApplicationType;
import com.t4login.definitions.AvgPriceIndicatorType;
import com.t4login.definitions.BillingFee;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.CTI;
import com.t4login.definitions.ClearingTradePriceType;
import com.t4login.definitions.CustOrderHandlingInstType;
import com.t4login.definitions.MasterType;
import com.t4login.definitions.OpenClose;
import com.t4login.definitions.OrderLink;
import com.t4login.definitions.OrderSource;
import com.t4login.definitions.OrderSourceMethod;
import com.t4login.definitions.Origin;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.PrimaryUserType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.messages.MsgOrderUpdateBaseD;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class MsgOrderUpdateD
extends MsgOrderUpdateBaseD {
    public String ExchangeOrderID = "";
    public NDateTime SubmitTime = NDateTime.MinValue;
    public NDateTime TradeDate = NDateTime.MinValue;
    public String ExchangeID = "";
    public String ExchangeLoginID = "";
    public String ExecutingLoginID = "";
    public String ExchangeLocation = "";
    public String UserID = "";
    public String UserName = "";
    public String UserAddress = "";
    public String SessionID = "";
    public String AppID = "";
    public String AppName = "";
    public BuySell BuySell = com.t4login.definitions.BuySell.Undefined;
    public PriceType PriceType = com.t4login.definitions.PriceType.Undefined;
    public TimeType TimeType;
    public int CurrentVolume;
    public Price CurrentLimitPrice;
    public Price CurrentStopPrice;
    public int NewVolume;
    public Price NewLimitPrice;
    public Price NewStopPrice;
    public OpenClose OpenClose = com.t4login.definitions.OpenClose.Undefined;
    public String AccountNumber = "";
    public CTI CTI = com.t4login.definitions.CTI.Undefined;
    public Origin Origin = com.t4login.definitions.Origin.Undefined;
    public AccountCode AccountCode = com.t4login.definitions.AccountCode.Undefined;
    public String MemberAllocation = "";
    public String TraderAllocation = "";
    public String CustomerReference = "";
    public BillingFee BillingFee = com.t4login.definitions.BillingFee.Undefined;
    public String OmnibusAccount = "";
    public String ExecutingGroupID = "";
    public String Tag = "";
    public int TotalFillVolume;
    public int WorkingVolume;
    public int TrailTicks;
    public Price TrailPrice;
    public int TrailRevisionInterval;
    public int TrailRevisionChange;
    public OrderLink OrderLink = com.t4login.definitions.OrderLink.None;
    public String OrdersLinked = "";
    public ActivationType ActivationType = com.t4login.definitions.ActivationType.Undefined;
    public String ActivationDetails = "";
    public PrimaryUserType PrimaryUser = PrimaryUserType.Primary;
    public int CurrentMaxShow;
    public int NewMaxShow;
    public String RoutingUserID = "";
    public String RoutingUserName = "";
    public OrderSource OrderSource = com.t4login.definitions.OrderSource.Unknown;
    public OrderSourceMethod OrderSourceMethod = com.t4login.definitions.OrderSourceMethod.Unknown;
    public ApplicationType AppType = ApplicationType.Manual;
    public MasterType MasterType = com.t4login.definitions.MasterType.Master;
    public String TagClOrdID = "";
    public String TagOrigClOrdID = "";
    public String TagRelationID = "";
    public String SMPID = "";
    public int SequenceOrder;
    public String ATSRegulatoryID = "";
    public int MaxVolume;
    public String AuthorizedTraderID = "";
    public LinkedHashMap<String, String> InstructionExtra = new LinkedHashMap();
    public NDateTime ReceiveTime;
    public CustOrderHandlingInstType CustOrderHandlingInst;
    public AvgPriceIndicatorType AvgPriceIndicator;
    public String AvgPriceGroupID;
    public ClearingTradePriceType ClearingTradePrice;
    public List<Trade> Trades = new ArrayList<Trade>();
    public List<TradeLeg> TradeLegs = new ArrayList<TradeLeg>();

    public MsgOrderUpdateD() {
        super(MessageType.OrderUpdateD);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.baseParseMessageStream(ver, in);
        this.ExchangeOrderID = MsgOrderUpdateD.readShortString(in);
        this.TradeDate = MsgOrderUpdateD.read7BitDateTime(in);
        this.ExchangeID = MsgOrderUpdateD.readShortString(in);
        this.ExchangeLoginID = MsgOrderUpdateD.readShortString(in);
        this.UserID = MsgOrderUpdateD.readShortString(in).toUpperCase(Locale.US);
        this.UserName = MsgOrderUpdateD.readShortString(in);
        this.UserAddress = MsgOrderUpdateD.readShortString(in);
        this.BuySell = com.t4login.definitions.BuySell.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.PriceType = com.t4login.definitions.PriceType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.TimeType = com.t4login.definitions.TimeType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.CurrentVolume = MsgOrderUpdateD.read7BitInteger(in);
        this.NewVolume = MsgOrderUpdateD.read7BitInteger(in);
        this.OpenClose = com.t4login.definitions.OpenClose.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.AccountNumber = MsgOrderUpdateD.readShortString(in);
        this.CTI = com.t4login.definitions.CTI.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.Origin = com.t4login.definitions.Origin.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.AccountCode = com.t4login.definitions.AccountCode.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.MemberAllocation = MsgOrderUpdateD.readShortString(in);
        this.TraderAllocation = MsgOrderUpdateD.readShortString(in);
        this.CustomerReference = MsgOrderUpdateD.readShortString(in);
        this.Tag = MsgOrderUpdateD.readShortString(in);
        this.TotalFillVolume = MsgOrderUpdateD.read7BitInteger(in);
        this.WorkingVolume = MsgOrderUpdateD.read7BitInteger(in);
        this.ExecutingLoginID = MsgOrderUpdateD.readShortString(in);
        this.TrailRevisionInterval = MsgOrderUpdateD.read7BitInteger(in);
        this.TrailRevisionChange = MsgOrderUpdateD.read7BitInteger(in);
        this.OrderLink = com.t4login.definitions.OrderLink.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.OrdersLinked = MsgOrderUpdateD.readShortString(in);
        this.SubmitTime = MsgOrderUpdateD.read7BitDateTime(in);
        this.BillingFee = com.t4login.definitions.BillingFee.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.OmnibusAccount = MsgOrderUpdateD.readShortString(in);
        this.ExecutingGroupID = MsgOrderUpdateD.readShortString(in).toUpperCase(Locale.US);
        this.SessionID = MsgOrderUpdateD.readShortString(in).toUpperCase(Locale.US);
        this.AppID = MsgOrderUpdateD.readShortString(in).toUpperCase(Locale.US);
        this.AppName = MsgOrderUpdateD.readShortString(in);
        this.ActivationType = com.t4login.definitions.ActivationType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.Trades.clear();
        int nTrades = MsgOrderUpdateD.read7BitInteger(in);
        int i = 0;
        while (i < nTrades) {
            Trade trade = new Trade();
            trade.SequenceOrder = i++;
            trade.Volume = MsgOrderUpdateD.read7BitInteger(in);
            trade.Price = MsgOrderUpdateD.read7BitPrice(in);
            trade.ResidualVolume = MsgOrderUpdateD.read7BitInteger(in);
            trade.Time = MsgOrderUpdateD.read7BitDateTime(in);
            trade.ExchangeTradeID = MsgOrderUpdateD.readShortString(in);
            trade.ExchangeTime = MsgOrderUpdateD.read7BitDateTime(in);
            trade.ContraTrader = MsgOrderUpdateD.readShortString(in);
            trade.ContraBroker = MsgOrderUpdateD.readShortString(in);
            trade.TradeDate = MsgOrderUpdateD.read7BitDateTime(in);
            this.Trades.add(trade);
        }
        this.TradeLegs.clear();
        int nTradeLegs = MsgOrderUpdateD.read7BitInteger(in);
        int i2 = 0;
        while (i2 < nTradeLegs) {
            TradeLeg tradeLeg = new TradeLeg();
            tradeLeg.SequenceOrder = i2++;
            tradeLeg.LegIndex = MsgOrderUpdateD.read7BitInteger(in);
            tradeLeg.Volume = MsgOrderUpdateD.read7BitInteger(in);
            tradeLeg.Price = MsgOrderUpdateD.read7BitPrice(in);
            tradeLeg.Time = MsgOrderUpdateD.read7BitDateTime(in);
            tradeLeg.ExchangeTradeID = MsgOrderUpdateD.readShortString(in);
            tradeLeg.ExchangeTime = MsgOrderUpdateD.read7BitDateTime(in);
            tradeLeg.ContraTrader = MsgOrderUpdateD.readShortString(in);
            tradeLeg.ContraBroker = MsgOrderUpdateD.readShortString(in);
            tradeLeg.ResidualVolume = MsgOrderUpdateD.read7BitInteger(in);
            tradeLeg.TradeDate = MsgOrderUpdateD.read7BitDateTime(in);
            this.TradeLegs.add(tradeLeg);
        }
        this.PrimaryUser = PrimaryUserType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.CurrentMaxShow = MsgOrderUpdateD.read7BitInteger(in);
        this.NewMaxShow = MsgOrderUpdateD.read7BitInteger(in);
        this.RoutingUserID = MsgOrderUpdateD.readShortString(in);
        this.RoutingUserName = MsgOrderUpdateD.readShortString(in);
        this.ExchangeLocation = MsgOrderUpdateD.readShortString(in);
        this.OrderSource = com.t4login.definitions.OrderSource.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.AppType = ApplicationType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.MasterType = com.t4login.definitions.MasterType.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.OrderSourceMethod = com.t4login.definitions.OrderSourceMethod.get(MsgOrderUpdateD.readIntBytes(in, 1));
        this.TagClOrdID = MsgOrderUpdateD.readShortString(in);
        this.TagOrigClOrdID = MsgOrderUpdateD.readShortString(in);
        this.TagRelationID = MsgOrderUpdateD.readShortString(in);
        this.SMPID = MsgOrderUpdateD.readShortString(in);
        this.SequenceOrder = MsgOrderUpdateD.read7BitInteger(in);
        this.ATSRegulatoryID = MsgOrderUpdateD.readShortString(in);
        this.MaxVolume = MsgOrderUpdateD.read7BitInteger(in);
        this.AuthorizedTraderID = MsgOrderUpdateD.readShortString(in);
        this.ReceiveTime = MsgOrderUpdateD.read7BitDateTime(in);
        this.CurrentLimitPrice = MsgOrderUpdateD.read7BitPriceN(in);
        this.CurrentStopPrice = MsgOrderUpdateD.read7BitPriceN(in);
        this.NewLimitPrice = MsgOrderUpdateD.read7BitPriceN(in);
        this.NewStopPrice = MsgOrderUpdateD.read7BitPriceN(in);
        this.TrailPrice = MsgOrderUpdateD.read7BitPriceN(in);
        this.InstructionExtra = MsgOrderUpdateD.readStringDictionary(in);
        this.ActivationDetails = MsgOrderUpdateD.readString(in);
        this.CustOrderHandlingInst = CustOrderHandlingInstType.get(MsgOrderUpdateD.read7BitInteger(in));
        this.AvgPriceIndicator = AvgPriceIndicatorType.get(MsgOrderUpdateD.read7BitInteger(in));
        this.AvgPriceGroupID = MsgOrderUpdateD.readShortString(in);
        this.ClearingTradePrice = ClearingTradePriceType.get(MsgOrderUpdateD.read7BitInteger(in));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgOrderUpdateD[");
        this.baseToString(sb);
        sb.append("; ");
        sb.append("ExchangeOrderID: ").append(this.ExchangeOrderID).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ExchangeLoginID: ").append(this.ExchangeLoginID).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("UserAddress: ").append(this.UserAddress).append(", ");
        sb.append("BuySell: ").append(this.BuySell).append(", ");
        sb.append("PriceType: ").append(this.PriceType).append(", ");
        sb.append("TimeType: ").append(this.TimeType).append(", ");
        sb.append("CurrentVolume: ").append(this.CurrentVolume).append(", ");
        sb.append("CurrentLimitPrice: ").append(this.CurrentLimitPrice).append(", ");
        sb.append("CurrentStopPrice: ").append(this.CurrentStopPrice).append(", ");
        sb.append("NewVolume: ").append(this.NewVolume).append(", ");
        sb.append("NewLimitPrice: ").append(this.NewLimitPrice).append(", ");
        sb.append("NewStopPrice: ").append(this.NewStopPrice).append(", ");
        sb.append("OpenClose: ").append(this.OpenClose).append(", ");
        sb.append("AccountNumber: ").append(this.AccountNumber).append(", ");
        sb.append("CTI: ").append(this.CTI).append(", ");
        sb.append("Origin: ").append(this.Origin).append(", ");
        sb.append("AccountCode: ").append(this.AccountCode).append(", ");
        sb.append("MemberAllocation: ").append(this.MemberAllocation).append(", ");
        sb.append("TraderAllocation: ").append(this.TraderAllocation).append(", ");
        sb.append("CustomerReference: ").append(this.CustomerReference).append(", ");
        sb.append("Tag: ").append(this.Tag).append(", ");
        sb.append("TotalFillVolume: ").append(this.TotalFillVolume).append(", ");
        sb.append("WorkingVolume: ").append(this.WorkingVolume).append(", ");
        sb.append("ExecutingLoginID: ").append(this.ExecutingLoginID).append(", ");
        sb.append("TrailTicks: ").append(this.TrailTicks).append(", ");
        sb.append("TrailPrice: ").append(this.TrailPrice).append(", ");
        sb.append("TrailRevisionInterval: ").append(this.TrailRevisionInterval).append(", ");
        sb.append("TrailRevisionChange: ").append(this.TrailRevisionChange).append(", ");
        sb.append("OrderLink: ").append(this.OrderLink).append(", ");
        sb.append("OrdersLinked: ").append(this.OrdersLinked).append(", ");
        sb.append("SubmitTime: ").append(this.SubmitTime).append(", ");
        sb.append("BillingFee: ").append(this.BillingFee).append(", ");
        sb.append("OmnibusAccount: ").append(this.OmnibusAccount).append(", ");
        sb.append("ExecutingGroupID: ").append(this.ExecutingGroupID).append(", ");
        sb.append("SessionID: ").append(this.SessionID).append(", ");
        sb.append("AppID: ").append(this.AppID).append(", ");
        sb.append("AppName: ").append(this.AppName).append(", ");
        sb.append("ActivationType: ").append(this.ActivationType).append(", ");
        sb.append("ActivationDetails: ").append(this.ActivationDetails).append(", ");
        sb.append("PrimaryUser: ").append(this.PrimaryUser).append(", ");
        sb.append("CurrentMaxShow: ").append(this.CurrentMaxShow).append(", ");
        sb.append("NewMaxShow: ").append(this.NewMaxShow).append(", ");
        sb.append("RoutingUserID: ").append(this.RoutingUserID).append(", ");
        sb.append("RoutingUserName: ").append(this.RoutingUserName).append(", ");
        sb.append("ExchangeLocation: ").append(this.ExchangeLocation).append(", ");
        sb.append("OrderSource: ").append(this.OrderSource).append(", ");
        sb.append("AppType: ").append(this.AppType).append(", ");
        sb.append("MasterType: ").append(this.MasterType).append(", ");
        sb.append("OrderSourceMethod: ").append(this.OrderSourceMethod).append(", ");
        sb.append("TagClOrdID: ").append(this.TagClOrdID).append(", ");
        sb.append("TagOrigClOrdID: ").append(this.TagOrigClOrdID).append(", ");
        sb.append("TagRelationID: ").append(this.TagRelationID).append(", ");
        sb.append("SMPID: ").append(this.SMPID).append(", ");
        sb.append("SequenceOrder: ").append(this.SequenceOrder).append(", ");
        sb.append("ATSRegulatoryID: ").append(this.ATSRegulatoryID).append(", ");
        sb.append("MaxVolume: ").append(this.MaxVolume).append(", ");
        sb.append("AuthorizedTraderID: ").append(this.AuthorizedTraderID).append(", ");
        sb.append("ReceiveTime: ").append(this.ReceiveTime).append(", ");
        sb.append("InstructionExtra: ").append(this.InstructionExtra).append(",");
        sb.append("CustOrderHandlingInst: ").append(this.CustOrderHandlingInst).append(",");
        sb.append("AvgPriceIndicator: ").append(this.AvgPriceIndicator).append(",");
        sb.append("AvgPriceGroupID: ").append(this.AvgPriceGroupID).append(",");
        sb.append("ClearingTradePrice: ").append(this.ClearingTradePrice).append(",");
        sb.append("nTrades: ").append(this.Trades.size()).append(", ");
        sb.append("nTradeLegs: ").append(this.TradeLegs.size());
        sb.append("]");
        return sb.toString();
    }

    public static class Trade {
        public int Volume;
        public Price Price;
        public int ResidualVolume;
        public NDateTime Time;
        public String ExchangeTradeID;
        public NDateTime ExchangeTime;
        public String ContraTrader;
        public String ContraBroker;
        public NDateTime TradeDate;
        public int SequenceOrder;
    }

    public static class TradeLeg {
        public int LegIndex;
        public int Volume;
        public Price Price;
        public NDateTime Time;
        public String ExchangeTradeID;
        public NDateTime ExchangeTime;
        public String ContraTrader;
        public String ContraBroker;
        public int ResidualVolume;
        public NDateTime TradeDate;
        public int SequenceOrder;
    }
}

