/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AccountCode;
import com.t4login.definitions.ActivationType;
import com.t4login.definitions.ApplicationType;
import com.t4login.definitions.AutoPullType;
import com.t4login.definitions.AvgPriceIndicatorType;
import com.t4login.definitions.BillingFee;
import com.t4login.definitions.BuySell;
import com.t4login.definitions.CTI;
import com.t4login.definitions.ClearingTradePriceType;
import com.t4login.definitions.CustOrderHandlingInstType;
import com.t4login.definitions.MasterType;
import com.t4login.definitions.OpenClose;
import com.t4login.definitions.OrderLink;
import com.t4login.definitions.OrderSource;
import com.t4login.definitions.OrderSourceMethod;
import com.t4login.definitions.Origin;
import com.t4login.definitions.PriceType;
import com.t4login.definitions.PrimaryUserType;
import com.t4login.definitions.TimeType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class MsgOrderSubmission2
extends Message {
    public String AccountID;
    public String ExchangeID;
    public String MarketID;
    public String ExchangeLoginID;
    public String ExecutingLoginID;
    public String ExchangeLocation;
    public String UserID;
    public String UserName;
    public String UserAddress;
    public String SessionID;
    public String AppID;
    public String AppName;
    public String UserRoles;
    public NDateTime Time;
    public NDateTime TradeDate;
    public String AccountNumber;
    public CTI CTI;
    public Origin Origin;
    public AccountCode AccountCode;
    public String MemberAllocation;
    public String TraderAllocation;
    public String CustomerReference;
    public BillingFee BillingFee;
    public String OmnibusAccount;
    public String ExecutingGroupID;
    public OrderLink OrderLink = com.t4login.definitions.OrderLink.None;
    public String OrdersLinked;
    public String UserSvr;
    public PrimaryUserType PrimaryUser;
    public String RoutingUserID;
    public String RoutingUserName;
    public OrderSource OrderSource = com.t4login.definitions.OrderSource.JavaAPI;
    public OrderSourceMethod OrderSourceMethod = com.t4login.definitions.OrderSourceMethod.Unknown;
    public ApplicationType AppType = ApplicationType.Manual;
    public AutoPullType AutoPull = AutoPullType.None;
    public MasterType MasterType = com.t4login.definitions.MasterType.Master;
    public String SMPID;
    public String ATSRegulatoryID;
    public List<Order> Orders = new ArrayList<Order>();
    public String AuthorizedTraderID = "";
    public boolean HasDecimalPrices = true;
    public LinkedHashMap<String, String> InstructionExtra = new LinkedHashMap();
    public CustOrderHandlingInstType CustOrderHandlingInst = CustOrderHandlingInstType.None;
    public AvgPriceIndicatorType AvgPriceIndicator = AvgPriceIndicatorType.None;
    public String AvgPriceGroupID;
    public ClearingTradePriceType ClearingTradePrice = ClearingTradePriceType.ExecutionPrice;

    public MsgOrderSubmission2() {
        super(MessageType.OrderSubmission2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        throw new MessageDecodingNotSupported(this.getMessageType());
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgOrderSubmission2.writeShortString(out, this.AccountID);
        MsgOrderSubmission2.writeShortString(out, this.ExchangeID);
        MsgOrderSubmission2.writeShortString(out, this.MarketID);
        MsgOrderSubmission2.writeShortString(out, this.ExchangeLoginID);
        MsgOrderSubmission2.writeShortString(out, this.UserID);
        MsgOrderSubmission2.writeShortString(out, this.UserName);
        MsgOrderSubmission2.writeShortString(out, this.UserAddress);
        MsgOrderSubmission2.writeDateTime(out, this.Time);
        MsgOrderSubmission2.writeDateTime(out, this.TradeDate);
        MsgOrderSubmission2.writeShortString(out, this.AccountNumber);
        this.writeIntBytes(out, this.CTI.getValue(), 1);
        this.writeIntBytes(out, this.Origin.getValue(), 1);
        this.writeIntBytes(out, this.AccountCode.getValue(), 1);
        MsgOrderSubmission2.writeShortString(out, this.MemberAllocation);
        MsgOrderSubmission2.writeShortString(out, this.TraderAllocation);
        MsgOrderSubmission2.writeShortString(out, this.CustomerReference);
        this.writeIntBytes(out, this.BillingFee.getValue(), 1);
        MsgOrderSubmission2.writeShortString(out, this.OmnibusAccount);
        MsgOrderSubmission2.writeShortString(out, this.ExecutingGroupID);
        this.writeIntBytes(out, this.OrderLink.getValue(), 1);
        MsgOrderSubmission2.writeShortString(out, this.ExecutingLoginID);
        MsgOrderSubmission2.writeShortString(out, this.SessionID);
        MsgOrderSubmission2.writeShortString(out, this.AppID);
        MsgOrderSubmission2.writeShortString(out, this.AppName);
        MsgOrderSubmission2.writeShortString(out, this.UserSvr);
        this.writeIntBytes(out, this.PrimaryUser.getValue(), 1);
        MsgOrderSubmission2.writeShortString(out, this.RoutingUserID);
        MsgOrderSubmission2.writeShortString(out, this.RoutingUserName);
        MsgOrderSubmission2.writeShortString(out, this.ExchangeLocation);
        MsgOrderSubmission2.writeShortString(out, this.OrdersLinked);
        MsgOrderSubmission2.writeShortString(out, this.UserRoles);
        this.writeIntBytes(out, this.OrderSource.getValue(), 1);
        this.writeIntBytes(out, this.AppType.getValue(), 1);
        this.writeIntBytes(out, this.MasterType.getValue(), 1);
        this.writeIntBytes(out, this.OrderSourceMethod.getValue(), 1);
        this.writeIntBytes(out, this.AutoPull.getValue(), 1);
        int nSend = 0;
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            ++nSend;
        }
        MsgOrderSubmission2.writeInteger(out, nSend);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderSubmission2.writeShortString(out, order.UniqueID);
            MsgOrderSubmission2.writeShortString(out, order.ExchangeOrderID);
            this.writeIntBytes(out, order.BuySell.getValue(), 1);
            this.writeIntBytes(out, order.PriceType.getValue(), 1);
            this.writeIntBytes(out, order.TimeType.getValue(), 1);
            MsgOrderSubmission2.writeInteger(out, order.Volume);
            MsgOrderSubmission2.writeInteger(out, order.LimitTicks);
            MsgOrderSubmission2.writeInteger(out, order.StopTicks);
            this.writeIntBytes(out, order.OpenClose.getValue(), 1);
            MsgOrderSubmission2.writeShortString(out, order.Tag);
            MsgOrderSubmission2.writeInteger(out, order.TrailTicks);
            MsgOrderSubmission2.writeInteger(out, order.TrailRevisionInterval);
            MsgOrderSubmission2.writeInteger(out, order.TrailRevisionChange);
            this.writeIntBytes(out, order.ActivationType.getValue(), 1);
            MsgOrderSubmission2.writeShortString(out, order.ActivationValue);
            MsgOrderSubmission2.writeInteger(out, order.MaxShow);
            MsgOrderSubmission2.writeShortString(out, order.TagClOrdId);
            MsgOrderSubmission2.writeShortString(out, order.TagRelationID);
        }
        MsgOrderSubmission2.writeShortString(out, this.SMPID);
        MsgOrderSubmission2.writeShortString(out, this.ATSRegulatoryID);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderSubmission2.writeInteger(out, order.MaxVolume);
        }
        MsgOrderSubmission2.writeShortString(out, this.AuthorizedTraderID);
        MsgOrderSubmission2.writeBooleanAlt(out, this.HasDecimalPrices);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderSubmission2.writePrice(out, order.LimitPrice);
            MsgOrderSubmission2.writePrice(out, order.StopPrice);
            MsgOrderSubmission2.writePrice(out, order.TrailPrice);
        }
        MsgOrderSubmission2.writeStringDictionary(out, this.InstructionExtra);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderSubmission2.writeString(out, order.ActivationDetails);
        }
        MsgOrderSubmission2.write7BitInteger(this.CustOrderHandlingInst.getValue(), out);
        MsgOrderSubmission2.write7BitInteger(this.AvgPriceIndicator.getValue(), out);
        MsgOrderSubmission2.writeShortString(out, this.AvgPriceGroupID);
        MsgOrderSubmission2.write7BitInteger(this.ClearingTradePrice.getValue(), out);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgOrderSubmission2[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("ExchangeLoginID: ").append(this.ExchangeLoginID).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("UserAddress: ").append(this.UserAddress).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate).append(", ");
        sb.append("AccountNumber: ").append(this.AccountNumber).append(", ");
        sb.append("CTI: ").append(this.CTI).append(", ");
        sb.append("Origin: ").append(this.Origin).append(", ");
        sb.append("MemberAllocation: ").append(this.MemberAllocation).append(", ");
        sb.append("TraderAllocation: ").append(this.TraderAllocation).append(", ");
        sb.append("CustomerReference: ").append(this.CustomerReference).append(", ");
        sb.append("BillingFee: ").append(this.BillingFee).append(", ");
        sb.append("OmnibusAccount: ").append(this.OmnibusAccount).append(", ");
        sb.append("ExecutingGroupID: ").append(this.ExecutingGroupID).append(", ");
        sb.append("OrderLink: ").append(this.OrderLink).append(", ");
        sb.append("ExecutingLoginID: ").append(this.ExecutingLoginID).append(", ");
        sb.append("SessionID: ").append(this.SessionID).append(", ");
        sb.append("AppID: ").append(this.AppID).append(", ");
        sb.append("AppName: ").append(this.AppName).append(", ");
        sb.append("UserSvr: ").append(this.UserSvr).append(", ");
        sb.append("PrimaryUser: ").append(this.PrimaryUser).append(", ");
        sb.append("RoutingUserID: ").append(this.RoutingUserID).append(", ");
        sb.append("RoutingUserName: ").append(this.RoutingUserName).append(", ");
        sb.append("ExchangeLocation: ").append(this.ExchangeLocation).append(", ");
        sb.append("OrdersLinked: ").append(this.OrdersLinked).append(", ");
        sb.append("UserRoles: ").append(this.UserRoles).append(", ");
        sb.append("OrderSource: ").append(this.OrderSource).append(", ");
        sb.append("AppType: ").append(this.AppType).append(", ");
        sb.append("MasterType: ").append(this.MasterType).append(", ");
        sb.append("OrderSourceMethod: ").append(this.OrderSourceMethod).append(", ");
        sb.append("AutoPull: ").append(this.AutoPull).append(", ");
        sb.append("SMPID: ").append(this.SMPID).append(", ");
        sb.append("ATSRegulatoryID: ").append(this.ATSRegulatoryID).append(",");
        sb.append("AuthorizedTraderID: ").append(this.AuthorizedTraderID).append(",");
        sb.append("HasDecimalPrices: ").append(this.HasDecimalPrices).append(",");
        sb.append("InstructionExtra: ").append(this.InstructionExtra).append(",");
        sb.append("CustOrderHandlingInst: ").append(this.CustOrderHandlingInst).append(",");
        sb.append("AvgPriceIndicator: ").append(this.AvgPriceIndicator).append(",");
        sb.append("AvgPriceGroupID: ").append(this.AvgPriceGroupID).append(",");
        sb.append("ClearingTradePrice: ").append(this.ClearingTradePrice).append(",");
        sb.append("Orders: ").append(",\n");
        for (Order order : this.Orders) {
            sb.append("  Order[");
            sb.append("UniqueID: ").append(order.UniqueID).append(", ");
            sb.append("ExchangeOrderID: ").append(order.ExchangeOrderID).append(", ");
            sb.append("BuySell: ").append(order.BuySell).append(", ");
            sb.append("PriceType: ").append(order.PriceType).append(", ");
            sb.append("TimeType: ").append(order.TimeType).append(", ");
            sb.append("Volume: ").append(order.Volume).append(", ");
            sb.append("MaxVolume: ").append(order.MaxVolume).append(", ");
            sb.append("LimitPrice: ").append(order.LimitPrice).append(", ");
            sb.append("StopTicks: ").append(order.StopTicks).append(", ");
            sb.append("StopPrice: ").append(order.StopPrice).append(", ");
            sb.append("OpenClose: ").append(order.OpenClose).append(", ");
            sb.append("Tag: ").append(order.Tag).append(", ");
            sb.append("TrailPrice: ").append(order.TrailPrice).append(", ");
            sb.append("TrailRevisionInterval: ").append(order.TrailRevisionInterval).append(", ");
            sb.append("TrailRevisionChange: ").append(order.TrailRevisionChange).append(", ");
            sb.append("ActivationType: ").append(order.ActivationType).append(", ");
            sb.append("ActivationValue: ").append(order.ActivationValue).append(", ");
            sb.append("MaxShow: ").append(order.MaxShow).append(", ");
            sb.append("TagClOrdId").append(order.TagClOrdId).append(", ");
            sb.append("TagRelationID: ").append(order.TagRelationID).append(", ");
            sb.append("Send: ").append(order.Send);
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static class Order {
        public String UniqueID = "";
        public String ExchangeOrderID = "";
        public BuySell BuySell;
        public PriceType PriceType;
        public TimeType TimeType;
        public int Volume;
        public int MaxVolume = 0;
        public int LimitTicks;
        public Price LimitPrice;
        public int StopTicks;
        public Price StopPrice;
        public int MaxShow;
        public OpenClose OpenClose;
        public String Tag = "";
        public int TrailTicks = 0;
        public Price TrailPrice = null;
        public int TrailRevisionInterval;
        public int TrailRevisionChange;
        public ActivationType ActivationType;
        public String ActivationValue = "";
        public String TagClOrdId = "";
        public String TagRelationID = "";
        public boolean Send = true;
        public String ActivationDetails = "";
    }
}

