/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ApplicationType;
import com.t4login.definitions.AutoPullType;
import com.t4login.definitions.CustOrderHandlingInstType;
import com.t4login.definitions.PrimaryUserType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class MsgOrderRevision2
extends Message {
    public String AccountID;
    public String ExchangeID;
    public String MarketID;
    public String ExchangeLoginID;
    public String ExecutingLoginID;
    public String ExchangeLocation;
    public String UserID;
    public String UserName;
    public String UserAddress;
    public String SessionID;
    public String AppID;
    public String AppName;
    public String UserRoles;
    public NDateTime Time;
    public String UserSvr;
    public PrimaryUserType PrimaryUser;
    public String RoutingUserID;
    public String RoutingUserName;
    public ApplicationType AppType = ApplicationType.Manual;
    public AutoPullType AutoPull = AutoPullType.None;
    public String SMPID;
    public String ATSRegulatoryID;
    public List<Order> Orders = new ArrayList<Order>();
    public String AuthorizedTraderID = "";
    public LinkedHashMap<String, String> InstructionExtra = new LinkedHashMap();
    public boolean HasDecimalPrices = true;
    public CustOrderHandlingInstType CustOrderHandlingInst = CustOrderHandlingInstType.None;

    public MsgOrderRevision2() {
        super(MessageType.OrderRevision2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        throw new MessageDecodingNotSupported(this.getMessageType());
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgOrderRevision2.writeShortString(out, this.AccountID);
        MsgOrderRevision2.writeShortString(out, this.ExchangeID);
        MsgOrderRevision2.writeShortString(out, this.MarketID);
        MsgOrderRevision2.writeShortString(out, this.ExchangeLoginID);
        MsgOrderRevision2.writeShortString(out, this.UserID);
        MsgOrderRevision2.writeShortString(out, this.UserName);
        MsgOrderRevision2.writeShortString(out, this.UserAddress);
        MsgOrderRevision2.writeDateTime(out, this.Time);
        MsgOrderRevision2.writeShortString(out, this.ExecutingLoginID);
        MsgOrderRevision2.writeShortString(out, this.SessionID);
        MsgOrderRevision2.writeShortString(out, this.AppID);
        MsgOrderRevision2.writeShortString(out, this.AppName);
        MsgOrderRevision2.writeShortString(out, this.UserSvr);
        this.writeIntBytes(out, this.PrimaryUser.getValue(), 1);
        MsgOrderRevision2.writeShortString(out, this.RoutingUserID);
        MsgOrderRevision2.writeShortString(out, this.RoutingUserName);
        MsgOrderRevision2.writeShortString(out, this.ExchangeLocation);
        MsgOrderRevision2.writeShortString(out, this.UserRoles);
        this.writeIntBytes(out, this.AppType.getValue(), 1);
        this.writeIntBytes(out, this.AutoPull.getValue(), 1);
        int nSend = 0;
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            ++nSend;
        }
        MsgOrderRevision2.writeInteger(out, nSend);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderRevision2.writeShortString(out, order.UniqueID);
            MsgOrderRevision2.writeShortString(out, order.ExchangeOrderID);
            MsgOrderRevision2.writeInteger(out, order.Volume);
            MsgOrderRevision2.writeInteger(out, order.LimitTicks);
            MsgOrderRevision2.writeInteger(out, order.StopTicks);
            MsgOrderRevision2.writeInteger(out, order.RevisionType);
            MsgOrderRevision2.writeShortString(out, order.Tag);
            MsgOrderRevision2.writeInteger(out, order.TrailTicks);
            MsgOrderRevision2.writeInteger(out, order.TrailRevisionInterval);
            MsgOrderRevision2.writeInteger(out, order.TrailRevisionChange);
            MsgOrderRevision2.writeShortString(out, order.ActivationValue);
            MsgOrderRevision2.writeLong(out, Long.getLong(order.FirstExchangeTag, 0L));
            MsgOrderRevision2.writeLong(out, Long.getLong(order.LastExchangeTag, 0L));
            MsgOrderRevision2.writeInteger(out, order.WorkingVolume);
            MsgOrderRevision2.writeInteger(out, order.MaxShow);
            MsgOrderRevision2.writeShortString(out, order.TagClOrdId);
        }
        MsgOrderRevision2.writeShortString(out, this.SMPID);
        MsgOrderRevision2.writeShortString(out, this.ATSRegulatoryID);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderRevision2.writeInteger(out, order.MaxVolume);
        }
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderRevision2.writeShortString(out, order.FirstExchangeTag);
            MsgOrderRevision2.writeShortString(out, order.LastExchangeTag);
        }
        MsgOrderRevision2.writeShortString(out, this.AuthorizedTraderID);
        MsgOrderRevision2.writeBooleanAlt(out, this.HasDecimalPrices);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderRevision2.writePrice(out, order.LimitPrice);
            MsgOrderRevision2.writePrice(out, order.StopPrice);
            MsgOrderRevision2.writePrice(out, order.TrailPrice);
        }
        MsgOrderRevision2.writeStringDictionary(out, this.InstructionExtra);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderRevision2.writeString(out, order.ActivationDetails);
        }
        MsgOrderRevision2.write7BitInteger(this.CustOrderHandlingInst.getValue(), out);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgOrderRevision2[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("ExchangeLoginID: ").append(this.ExchangeLoginID).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("UserAddress: ").append(this.UserAddress).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("ExecutingLoginID: ").append(this.ExecutingLoginID).append(", ");
        sb.append("SessionID: ").append(this.SessionID).append(", ");
        sb.append("AppID: ").append(this.AppID).append(", ");
        sb.append("AppName: ").append(this.AppName).append(", ");
        sb.append("UserSvr: ").append(this.UserSvr).append(", ");
        sb.append("PrimaryUser: ").append(this.PrimaryUser).append(", ");
        sb.append("RoutingUserID: ").append(this.RoutingUserID).append(", ");
        sb.append("RoutingUserName: ").append(this.RoutingUserName).append(", ");
        sb.append("ExchangeLocation: ").append(this.ExchangeLocation).append(", ");
        sb.append("UserRoles: ").append(this.UserRoles).append(", ");
        sb.append("AppType: ").append(this.AppType).append(", ");
        sb.append("AutoPull: ").append(this.AutoPull).append(", ");
        sb.append("SMPID: ").append(this.SMPID).append(", ");
        sb.append("ATSRegulatoryID: ").append(this.ATSRegulatoryID).append(",");
        sb.append("AuthorizedTraderID: ").append(this.AuthorizedTraderID).append(",");
        sb.append("HasDecimalPrices: ").append(this.HasDecimalPrices).append(",");
        sb.append("InstructionExtra: ").append(this.InstructionExtra).append(",");
        sb.append("CustOrderHandlingInst: ").append(this.CustOrderHandlingInst).append(",");
        sb.append("Orders: ").append(",\n");
        for (Order order : this.Orders) {
            sb.append("  Order[");
            sb.append("UniqueID: ").append(order.UniqueID).append(", ");
            sb.append("ExchangeOrderID: ").append(order.ExchangeOrderID).append(", ");
            sb.append("Volume: ").append(order.Volume).append(", ");
            sb.append("MaxVolume: ").append(order.MaxVolume).append(", ");
            sb.append("LimitPrice: ").append(order.LimitPrice).append(", ");
            sb.append("StopPrice: ").append(order.StopPrice).append(", ");
            sb.append("RevisionType: ").append(order.RevisionType).append(", ");
            sb.append("Tag: ").append(order.Tag).append(", ");
            sb.append("TrailPrice: ").append(order.TrailPrice).append(", ");
            sb.append("TrailRevisionInterval: ").append(order.TrailRevisionInterval).append(", ");
            sb.append("TrailRevisionChange: ").append(order.TrailRevisionChange).append(", ");
            sb.append("ActivationValue: ").append(order.ActivationValue).append(", ");
            sb.append("FirstExchangeTag: ").append(order.FirstExchangeTag).append(", ");
            sb.append("LastExchangeTag: ").append(order.LastExchangeTag).append(", ");
            sb.append("WorkingVolume: ").append(order.WorkingVolume).append(", ");
            sb.append("MaxShow: ").append(order.MaxShow).append(", ");
            sb.append("TagClOrdId").append(order.TagClOrdId).append(", ");
            sb.append("Send: ").append(order.Send);
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static class Order {
        public String UniqueID = "";
        public String ExchangeOrderID = "";
        public int Volume;
        public int MaxVolume = 0;
        public int WorkingVolume;
        public int LimitTicks;
        public Price LimitPrice;
        public int StopTicks;
        public Price StopPrice;
        public int RevisionType;
        public int MaxShow;
        public String Tag = "";
        public int TrailTicks = 0;
        public Price TrailPrice = null;
        public int TrailRevisionInterval;
        public int TrailRevisionChange;
        public String ActivationValue = "";
        public String FirstExchangeTag = "";
        public String LastExchangeTag = "";
        public String TagClOrdId = "";
        public boolean Send = true;
        public String ActivationDetails = "";
    }
}

