/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ApplicationType;
import com.t4login.definitions.PrimaryUserType;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class MsgOrderPull2
extends Message {
    public String AccountID;
    public String ExchangeID;
    public String MarketID;
    public String ExchangeLoginID;
    public String ExecutingLoginID;
    public String ExchangeLocation;
    public String UserID;
    public String UserName;
    public String UserAddress;
    public String SessionID;
    public String AppID;
    public String AppName;
    public String UserRoles;
    public NDateTime Time;
    public String UserSvr;
    public PrimaryUserType PrimaryUser = PrimaryUserType.Primary;
    public String RoutingUserID;
    public String RoutingUserName;
    public ApplicationType AppType = ApplicationType.Manual;
    public String ATSRegulatoryID;
    public List<Order> Orders = new ArrayList<Order>();
    public LinkedHashMap<String, String> InstructionExtra = new LinkedHashMap();

    public MsgOrderPull2() {
        super(MessageType.OrderPull2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        throw new MessageDecodingNotSupported(this.getMessageType());
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgOrderPull2.writeShortString(out, this.AccountID);
        MsgOrderPull2.writeShortString(out, this.ExchangeID);
        MsgOrderPull2.writeShortString(out, this.MarketID);
        MsgOrderPull2.writeShortString(out, this.ExchangeLoginID);
        MsgOrderPull2.writeShortString(out, this.UserID);
        MsgOrderPull2.writeShortString(out, this.UserName);
        MsgOrderPull2.writeShortString(out, this.UserAddress);
        MsgOrderPull2.writeDateTime(out, this.Time);
        MsgOrderPull2.writeShortString(out, this.ExecutingLoginID);
        MsgOrderPull2.writeShortString(out, this.SessionID);
        MsgOrderPull2.writeShortString(out, this.AppID);
        MsgOrderPull2.writeShortString(out, this.AppName);
        MsgOrderPull2.writeShortString(out, this.UserSvr);
        this.writeIntBytes(out, this.PrimaryUser.getValue(), 1);
        MsgOrderPull2.writeShortString(out, this.RoutingUserID);
        MsgOrderPull2.writeShortString(out, this.RoutingUserName);
        MsgOrderPull2.writeShortString(out, this.ExchangeLocation);
        MsgOrderPull2.writeShortString(out, this.UserRoles);
        this.writeIntBytes(out, this.AppType.getValue(), 1);
        int nSend = 0;
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            ++nSend;
        }
        MsgOrderPull2.writeInteger(out, nSend);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderPull2.writeShortString(out, order.UniqueID);
            MsgOrderPull2.writeShortString(out, order.ExchangeOrderID);
            MsgOrderPull2.writeShortString(out, order.Tag);
            MsgOrderPull2.writeLong(out, Long.getLong(order.FirstExchangeTag, 0L));
            MsgOrderPull2.writeLong(out, Long.getLong(order.LastExchangeTag, 0L));
            MsgOrderPull2.writeShortString(out, order.TagClOrdId);
        }
        MsgOrderPull2.writeShortString(out, this.ATSRegulatoryID);
        for (Order order : this.Orders) {
            if (!order.Send) continue;
            MsgOrderPull2.writeShortString(out, order.FirstExchangeTag);
            MsgOrderPull2.writeShortString(out, order.LastExchangeTag);
        }
        MsgOrderPull2.writeStringDictionary(out, this.InstructionExtra);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgOrderPull2[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("ExchangeLoginID: ").append(this.ExchangeLoginID).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("UserAddress: ").append(this.UserAddress).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("ExecutingLoginID: ").append(this.ExecutingLoginID).append(", ");
        sb.append("SessionID: ").append(this.SessionID).append(", ");
        sb.append("AppID: ").append(this.AppID).append(", ");
        sb.append("AppName: ").append(this.AppName).append(", ");
        sb.append("UserSvr: ").append(this.UserSvr).append(", ");
        sb.append("PrimaryUser: ").append(this.PrimaryUser).append(", ");
        sb.append("RoutingUserID: ").append(this.RoutingUserID).append(", ");
        sb.append("RoutingUserName: ").append(this.RoutingUserName).append(", ");
        sb.append("ExchangeLocation: ").append(this.ExchangeLocation).append(", ");
        sb.append("UserRoles: ").append(this.UserRoles).append(", ");
        sb.append("AppType: ").append(this.AppType).append(", ");
        sb.append("ATSRegulatoryID: ").append(this.ATSRegulatoryID).append(",");
        sb.append("InstructionExtra: ").append(this.InstructionExtra).append(",");
        sb.append("Orders: ").append(",\n");
        for (Order order : this.Orders) {
            sb.append("  Order[");
            sb.append("UniqueID: ").append(order.UniqueID).append(", ");
            sb.append("ExchangeOrderID: ").append(order.ExchangeOrderID).append(", ");
            sb.append("Tag: ").append(order.Tag).append(", ");
            sb.append("FirstExchangeTag: ").append(order.FirstExchangeTag).append(", ");
            sb.append("LastExchangeTag: ").append(order.LastExchangeTag).append(", ");
            sb.append("TagClOrdId").append(order.TagClOrdId).append(", ");
            sb.append("Send: ").append(order.Send);
            sb.append("]\n");
        }
        return sb.toString();
    }

    public static class Order {
        public String UniqueID = "";
        public String ExchangeOrderID = "";
        public String Tag = "";
        public String FirstExchangeTag = "";
        public String LastExchangeTag = "";
        public String TagClOrdId = "";
        public boolean Send = true;
    }
}

