/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MsgOrderPerformance3
extends Message {
    public String AccountID;
    public String MarketID;
    public boolean Historical;
    public List<Order> Orders = new ArrayList<Order>();

    public MsgOrderPerformance3() {
        super(MessageType.OrderPerformance3);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.AccountID = MsgOrderPerformance3.readShortString(in).toUpperCase(Locale.US);
        this.MarketID = MsgOrderPerformance3.readShortString(in);
        this.Historical = MsgOrderPerformance3.readBooleanAlt(in);
        int n = MsgOrderPerformance3.readInteger(in);
        for (int i = 0; i < n; ++i) {
            Order order = new Order();
            order.UniqueID = MsgOrderPerformance3.readShortString(in);
            order.APIDuration = MsgOrderPerformance3.readInteger(in);
            order.UHDuration = MsgOrderPerformance3.readInteger(in);
            order.AHDuration = MsgOrderPerformance3.readInteger(in);
            order.EHDuration = MsgOrderPerformance3.readInteger(in);
            this.Orders.add(order);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgOrderPerformance3.writeShortString(out, this.AccountID);
        MsgOrderPerformance3.writeShortString(out, this.MarketID);
        MsgOrderPerformance3.writeBooleanAlt(out, this.Historical);
        MsgOrderPerformance3.writeInteger(out, this.Orders.size());
        for (Order order : this.Orders) {
            MsgOrderPerformance3.writeShortString(out, order.UniqueID);
            MsgOrderPerformance3.writeInteger(out, order.APIDuration);
            MsgOrderPerformance3.writeInteger(out, order.UHDuration);
            MsgOrderPerformance3.writeInteger(out, order.AHDuration);
            MsgOrderPerformance3.writeInteger(out, order.EHDuration);
        }
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgOrderPerformance3[");
        sb.append("AccountID: ").append(this.AccountID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Historical: ").append(this.Historical).append(", ");
        sb.append("Orders: ");
        int n = this.Orders.size();
        for (int i = 0; i < n; ++i) {
            Order order = this.Orders.get(i);
            sb.append("[");
            sb.append("UniqueID: ").append(order.UniqueID).append(", ");
            sb.append("APIDuration: ").append(order.APIDuration).append(", ");
            sb.append("UHDuration: ").append(order.UHDuration).append(", ");
            sb.append("AHDuration: ").append(order.AHDuration).append(", ");
            sb.append("EHDuration: ").append(order.EHDuration);
            sb.append("]");
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class Order {
        public String UniqueID;
        public int APIDuration;
        public int UHDuration;
        public int AHDuration;
        public int EHDuration;
    }
}

