/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;

public class MsgNotification
extends Message {
    public String MessageID;
    public String ExchangeID;
    public String MarketID;
    public String Text;
    public String FirmID;
    public String UserID;
    public boolean Important;
    public boolean IsT500NotificationSignal = false;

    public MsgNotification() {
        super(MessageType.Notification);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.ExchangeID = MsgNotification.readString(in);
        this.MarketID = MsgNotification.readString(in);
        this.Text = MsgNotification.readString(in);
        this.Important = MsgNotification.readBoolean(in);
        this.FirmID = MsgNotification.readString(in);
        this.UserID = MsgNotification.readString(in);
        this.MessageID = MsgNotification.readString(in);
        if (ver > 2) {
            this.IsT500NotificationSignal = MsgNotification.readBoolean(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgNotification[");
        sb.append("MessageID: ").append(this.MessageID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Text: ").append(this.Text).append(", ");
        sb.append("FirmID: ").append(this.FirmID).append(", ");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("Important: ").append(this.Important).append(", ");
        sb.append("IsT500NotificationSignal: ").append(this.IsT500NotificationSignal);
        sb.append("]");
        return sb.toString();
    }
}

