/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MsgMarketTradeVolumeD
extends Message {
    public String MarketID = "";
    public int MarketIdent;
    public boolean Complete;
    public List<TradeVolume> Volume = new ArrayList<TradeVolume>();
    public NDateTime TradeDate;
    public boolean Delayed;

    public MsgMarketTradeVolumeD() {
        super(MessageType.MarketTradeVolumeD);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketIdent = MsgMarketTradeVolumeD.read7BitInteger(in);
        if (this.MarketIdent == 0) {
            this.MarketID = MsgMarketTradeVolumeD.readShortString(in);
        }
        this.TradeDate = MsgMarketTradeVolumeD.read7BitDateTime(in);
        this.Delayed = MsgMarketTradeVolumeD.readBooleanAlt(in);
        this.Complete = MsgMarketTradeVolumeD.readBooleanAlt(in);
        int volumeCount = MsgMarketTradeVolumeD.read7BitInteger(in);
        for (int i = 0; i < volumeCount; ++i) {
            Price price = MsgMarketTradeVolumeD.read7BitPrice(in);
            int volume = MsgMarketTradeVolumeD.read7BitInteger(in);
            NDateTime time = MsgMarketTradeVolumeD.read7BitDateTime(in);
            this.Volume.add(new TradeVolume(price, volume, time));
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketTradeVolumeD[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate).append(", ");
        sb.append("Delayed: ").append(this.Delayed).append(", ");
        sb.append("Complete: ").append(this.Complete).append(", ");
        sb.append("n: ").append(this.Volume.size()).append(",\n");
        for (TradeVolume volume : this.Volume) {
            sb.append("   TradeVolume[").append(", ");
            sb.append("Ticks: ").append(volume.Ticks).append(", ");
            sb.append("Price: ").append(volume.Price).append(", ");
            sb.append("Volume: ").append(volume.Volume).append(", ");
            sb.append("Time: ").append(volume.Time).append("],\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class TradeVolume {
        public final int Ticks;
        public Price Price;
        public final int Volume;
        public final NDateTime Time;
        public boolean Increment;

        public TradeVolume(int ticks, Price price, int volume, NDateTime time) {
            this.Ticks = ticks;
            this.Price = price;
            this.Volume = volume;
            this.Time = time;
        }

        public TradeVolume(Price price, int volume, NDateTime time) {
            this.Ticks = 0;
            this.Price = price;
            this.Volume = volume;
            this.Time = time;
        }
    }
}

