/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MsgMarketTradeHistoryD
extends Message {
    public String MarketID = "";
    public int MarketIdent;
    public List<TradeHistory> History = new ArrayList<TradeHistory>();
    public NDateTime TradeDate;
    public boolean Delayed;

    public MsgMarketTradeHistoryD() {
        super(MessageType.MarketTradeHistoryD);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketIdent = MsgMarketTradeHistoryD.read7BitInteger(in);
        if (this.MarketIdent == 0) {
            this.MarketID = MsgMarketTradeHistoryD.readShortString(in);
        }
        this.TradeDate = MsgMarketTradeHistoryD.read7BitDateTime(in);
        this.Delayed = MsgMarketTradeHistoryD.readBooleanAlt(in);
        int historyCount = MsgMarketTradeHistoryD.read7BitInteger(in);
        for (int i = 0; i < historyCount; ++i) {
            Price price = MsgMarketTradeHistoryD.read7BitPrice(in);
            int volume = MsgMarketTradeHistoryD.read7BitInteger(in);
            NDateTime time = MsgMarketTradeHistoryD.read7BitDateTime(in);
            this.History.add(new TradeHistory(price, volume, time));
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketTradeHistoryD[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("tradeDate: ").append(this.TradeDate).append(", ");
        sb.append("Delayed: ").append(this.Delayed).append(", ");
        sb.append("n: ").append(this.History.size()).append(",\n");
        for (TradeHistory history : this.History) {
            sb.append("   TradeHistory[").append(", ");
            sb.append("Price: ").append(history.Price).append(", ");
            sb.append("Volume: ").append(history.Volume).append(", ");
            sb.append("Time: ").append(history.Time).append("],\n");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class TradeHistory {
        public final Price Price;
        public final int Volume;
        public final NDateTime Time;

        public TradeHistory(Price price, int volume, NDateTime time) {
            this.Price = price;
            this.Volume = volume;
            this.Time = time;
        }
    }
}

