/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.OrderType;
import com.t4login.definitions.StrategyType;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MsgMarketDetails
extends Message {
    public final boolean IsCachedDetails;
    public String MarketID = "";
    public int MarketIdent;
    public String Description = "";
    public String ExchangeID = "";
    public String ContractID = "";
    public int ExpiryDate;
    public NDateTime LastTradingDate = NDateTime.MinValue;
    public NDateTime DelistDate = NDateTime.MinValue;
    public NDateTime ExchangeDelistDate = NDateTime.MinValue;
    public int Numerator = 1;
    public int Denominator = 1;
    public String PriceCode = "";
    public double TickValue = 1.0;
    public Set<OrderType> OrderTypes = new HashSet<OrderType>();
    public ContractType ContractType = com.t4login.definitions.ContractType.Unknown;
    public StrategyType StrategyType = com.t4login.definitions.StrategyType.None;
    public String RTSPriceCode = "";
    public int RTSNumerator;
    public int RTSDenominator;
    public double RTSTickValue;
    public String MarketRef = "";
    public int RealDecimals;
    public int DisplayDecimals;
    public int VolumeIncrement;
    public double StrategyRatio;
    public boolean Disabled;
    public String Group = "";
    public String MarketRef2 = "";
    public String Details = "";
    public String VTT = "";
    public NDateTime LastUpdateTime = NDateTime.MinValue;
    public List<LegItem> Legs = new ArrayList<LegItem>();
    public String UnderlyingMarketID = "";
    public NDateTime LastClientUpdateTime = NDateTime.now();
    public double MaintIntraMargin;
    public double MaintMargin;
    public NDateTime ActivationDate = NDateTime.MinValue;
    public int ClearingDecimals;
    public Price MinCabPrice = null;
    public Price StrikePrice = null;
    public int Decimals = 0;
    public Price MinPriceIncrement = Price.of(1);
    public String SecurityGroup;
    public String ExchangeDetailsJSON;
    public double MaintVolScan;

    public MsgMarketDetails() {
        super(MessageType.MarketDetails);
        this.IsCachedDetails = false;
    }

    public MsgMarketDetails(boolean isCachedDetails) {
        super(MessageType.MarketDetails);
        this.IsCachedDetails = isCachedDetails;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        int i;
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketID = MsgMarketDetails.readShortString(in);
        this.Description = MsgMarketDetails.readShortString(in);
        this.ExchangeID = MsgMarketDetails.readShortString(in);
        this.ContractID = MsgMarketDetails.readShortString(in);
        this.ExpiryDate = MsgMarketDetails.readInteger(in);
        this.LastTradingDate = MsgMarketDetails.readDateTime(in);
        this.Numerator = MsgMarketDetails.readInteger(in);
        this.Denominator = MsgMarketDetails.readInteger(in);
        this.PriceCode = MsgMarketDetails.readShortString(in);
        this.TickValue = MsgMarketDetails.readDouble(in);
        this.OrderTypes = OrderType.fromFlags(MsgMarketDetails.readInteger(in));
        this.ContractType = com.t4login.definitions.ContractType.get(MsgMarketDetails.readIntBytes(in, 1));
        this.StrategyType = com.t4login.definitions.StrategyType.get(MsgMarketDetails.readIntBytes(in, 1));
        this.RTSDenominator = MsgMarketDetails.readInteger(in);
        if (this.RTSDenominator > 0) {
            this.RTSPriceCode = MsgMarketDetails.readShortString(in);
            this.RTSNumerator = MsgMarketDetails.readInteger(in);
            this.RTSTickValue = MsgMarketDetails.readDouble(in);
        } else {
            this.RTSDenominator = this.Denominator;
            this.RTSPriceCode = "";
            this.RTSNumerator = this.Numerator;
            this.RTSTickValue = this.TickValue;
        }
        this.MarketRef = MsgMarketDetails.readShortString(in);
        this.RealDecimals = MsgMarketDetails.readInteger(in);
        int legCount = MsgMarketDetails.readInteger(in);
        String[] legMarketIDs = new String[legCount];
        int[] legVolumes = new int[legCount];
        String[] legMarketRefs = new String[legCount];
        String[] legDeltas = new String[legCount];
        String[] legPrices = new String[legCount];
        int[] legGroups = new int[legCount];
        for (i = 0; i < legCount; ++i) {
            legMarketIDs[i] = MsgMarketDetails.readShortString(in);
            legVolumes[i] = MsgMarketDetails.readInteger(in);
            legMarketRefs[i] = MsgMarketDetails.readShortString(in);
        }
        this.VolumeIncrement = MsgMarketDetails.readInteger(in);
        this.StrategyRatio = MsgMarketDetails.readDouble(in);
        this.Disabled = MsgMarketDetails.readBooleanAlt(in);
        this.Group = MsgMarketDetails.readShortString(in);
        this.MarketRef2 = MsgMarketDetails.readShortString(in);
        this.Details = MsgMarketDetails.readShortString(in);
        this.VTT = MsgMarketDetails.readShortString(in);
        this.DisplayDecimals = MsgMarketDetails.readInteger(in);
        this.LastUpdateTime = MsgMarketDetails.readDateTime(in);
        for (i = 0; i < legCount; ++i) {
            legDeltas[i] = MsgMarketDetails.readShortString(in);
            legPrices[i] = MsgMarketDetails.readShortString(in);
        }
        this.UnderlyingMarketID = MsgMarketDetails.readShortString(in);
        this.LastClientUpdateTime = MsgMarketDetails.readDateTime(in);
        this.MaintIntraMargin = MsgMarketDetails.readDouble(in);
        this.MaintMargin = MsgMarketDetails.readDouble(in);
        this.ActivationDate = MsgMarketDetails.readDateTime(in);
        this.ClearingDecimals = MsgMarketDetails.readInteger(in);
        this.DelistDate = MsgMarketDetails.readDateTime(in);
        this.ExchangeDelistDate = MsgMarketDetails.readDateTime(in);
        for (i = 0; i < legCount; ++i) {
            legGroups[i] = MsgMarketDetails.readIntBytes(in, 1);
        }
        this.MinCabPrice = MsgMarketDetails.readPrice(in);
        this.StrikePrice = MsgMarketDetails.readPrice(in);
        this.Decimals = MsgMarketDetails.read7BitInteger(in);
        this.MinPriceIncrement = MsgMarketDetails.read7BitPrice(in);
        this.SecurityGroup = MsgMarketDetails.readShortString(in);
        this.ExchangeDetailsJSON = MsgMarketDetails.readString(in);
        this.MaintVolScan = MsgMarketDetails.readDouble(in);
        for (i = 0; i < legCount; ++i) {
            this.Legs.add(new LegItem(legMarketIDs[i], legMarketRefs[i], legVolumes[i], legDeltas[i], legPrices[i], legGroups[i]));
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgMarketDetails.writeShortString(out, this.MarketID);
        MsgMarketDetails.writeShortString(out, this.Description);
        MsgMarketDetails.writeShortString(out, this.ExchangeID);
        MsgMarketDetails.writeShortString(out, this.ContractID);
        MsgMarketDetails.writeInteger(out, this.ExpiryDate);
        MsgMarketDetails.writeDateTime(out, this.LastTradingDate);
        MsgMarketDetails.writeInteger(out, this.Numerator);
        MsgMarketDetails.writeInteger(out, this.Denominator);
        MsgMarketDetails.writeShortString(out, this.PriceCode);
        MsgMarketDetails.writeDouble(out, this.TickValue);
        MsgMarketDetails.writeInteger(out, OrderType.toFlags(this.OrderTypes));
        this.writeIntBytes(out, this.ContractType.getValue(), 1);
        this.writeIntBytes(out, this.StrategyType.getValue(), 1);
        MsgMarketDetails.writeInteger(out, this.RTSDenominator);
        if (this.RTSDenominator > 0) {
            MsgMarketDetails.writeShortString(out, this.RTSPriceCode);
            MsgMarketDetails.writeInteger(out, this.RTSNumerator);
            MsgMarketDetails.writeDouble(out, this.RTSTickValue);
        }
        MsgMarketDetails.writeShortString(out, this.MarketRef);
        MsgMarketDetails.writeInteger(out, this.RealDecimals);
        MsgMarketDetails.writeInteger(out, this.Legs.size());
        for (LegItem leg : this.Legs) {
            MsgMarketDetails.writeShortString(out, leg.MarketID);
            MsgMarketDetails.writeInteger(out, leg.Volume);
            MsgMarketDetails.writeShortString(out, leg.MarketRef);
        }
        MsgMarketDetails.writeInteger(out, this.VolumeIncrement);
        MsgMarketDetails.writeDouble(out, this.StrategyRatio);
        MsgMarketDetails.writeBooleanAlt(out, this.Disabled);
        MsgMarketDetails.writeShortString(out, this.Group);
        MsgMarketDetails.writeShortString(out, this.MarketRef2);
        MsgMarketDetails.writeShortString(out, this.Details);
        MsgMarketDetails.writeShortString(out, this.VTT);
        MsgMarketDetails.writeInteger(out, this.DisplayDecimals);
        MsgMarketDetails.writeDateTime(out, this.LastUpdateTime);
        for (LegItem leg : this.Legs) {
            MsgMarketDetails.writeShortString(out, leg.Delta);
            MsgMarketDetails.writeShortString(out, leg.Price);
        }
        MsgMarketDetails.writeShortString(out, this.UnderlyingMarketID);
        MsgMarketDetails.writeDateTime(out, this.LastClientUpdateTime);
        MsgMarketDetails.writeDouble(out, this.MaintIntraMargin);
        MsgMarketDetails.writeDouble(out, this.MaintMargin);
        MsgMarketDetails.writeDateTime(out, this.ActivationDate);
        MsgMarketDetails.writeInteger(out, this.ClearingDecimals);
        MsgMarketDetails.writeDateTime(out, this.DelistDate);
        MsgMarketDetails.writeDateTime(out, this.ExchangeDelistDate);
        for (LegItem leg : this.Legs) {
            this.writeIntBytes(out, leg.Group, 1);
        }
        MsgMarketDetails.writePrice(out, this.MinCabPrice);
        MsgMarketDetails.writePrice(out, this.StrikePrice);
        MsgMarketDetails.write7BitInteger(this.Decimals, out);
        MsgMarketDetails.write7BitPrice(this.MinPriceIncrement, out);
        MsgMarketDetails.writeShortString(out, this.SecurityGroup);
        MsgMarketDetails.writeString(out, this.ExchangeDetailsJSON);
        MsgMarketDetails.writeDouble(out, this.MaintVolScan);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketDetails[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Description: ").append(this.Description).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.ContractID).append(", ");
        sb.append("ExpiryDate: ").append(this.ExpiryDate).append(", ");
        sb.append("LastTradingDate: ").append(this.LastTradingDate).append(", ");
        sb.append("DelistDate: ").append(this.DelistDate).append(", ");
        sb.append("ExchangeDelistDate: ").append(this.ExchangeDelistDate).append(", ");
        sb.append("Numerator: ").append(this.Numerator).append(", ");
        sb.append("Denominator: ").append(this.Denominator).append(", ");
        sb.append("PriceCode: ").append(this.PriceCode).append(", ");
        sb.append("TickValue: ").append(this.TickValue).append(", ");
        sb.append("OrderTypes: ").append(this.OrderTypes).append(", ");
        sb.append("ContractType: ").append(this.ContractType).append(", ");
        sb.append("StrategyType: ").append(this.StrategyType).append(", ");
        sb.append("RTSPriceCode: ").append(this.RTSPriceCode).append(", ");
        sb.append("RTSNumerator: ").append(this.RTSNumerator).append(", ");
        sb.append("RTSDenominator: ").append(this.RTSDenominator).append(", ");
        sb.append("RTSTickValue: ").append(this.RTSTickValue).append(", ");
        sb.append("MarketRef: ").append(this.MarketRef).append(", ");
        sb.append("RealDecimals: ").append(this.RealDecimals).append(", ");
        sb.append("DisplayDecimals: ").append(this.DisplayDecimals).append(", ");
        sb.append("VolumeIncrement: ").append(this.VolumeIncrement).append(", ");
        sb.append("StrategyRatio: ").append(this.StrategyRatio).append(", ");
        sb.append("Disabled: ").append(this.Disabled).append(", ");
        sb.append("Group: ").append(this.Group).append(", ");
        sb.append("MarketRef2: ").append(this.MarketRef2).append(", ");
        sb.append("Details: ").append(this.Details).append(", ");
        sb.append("VTT: ").append(this.VTT).append(", ");
        sb.append("LastUpdateTime: ").append(this.LastUpdateTime).append(", ");
        sb.append("UnderlyingMarketID: ").append(this.UnderlyingMarketID).append(", ");
        sb.append("n Legs: ").append(this.Legs.size()).append(", ");
        sb.append("LastClientUpdateTime: ").append(this.LastClientUpdateTime).append(", ");
        sb.append("MaintIntraMargin: ").append(this.MaintIntraMargin).append(", ");
        sb.append("MaintMargin: ").append(this.MaintMargin).append(", ");
        sb.append("ActivationDate: ").append(this.ActivationDate).append(", ");
        sb.append("ClearingDecimals: ").append(this.ClearingDecimals).append(", ");
        sb.append("MinCabPrice: ").append(this.MinCabPrice).append(", ");
        sb.append("StrikePrice: ").append(this.StrikePrice).append(", ");
        sb.append("MinCabPrice: ").append(this.Decimals).append(", ");
        sb.append("MinPriceIncrement: ").append(this.MinPriceIncrement).append(", ");
        sb.append("SecurityGroup: ").append(this.SecurityGroup).append(", ");
        sb.append("ExchangeDetailsJSON: ").append(this.ExchangeDetailsJSON).append(", ");
        sb.append("MaintVolScan: ").append(this.MaintVolScan);
        sb.append("]");
        return sb.toString();
    }

    public static class LegItem {
        public String MarketID;
        public String MarketRef;
        public int Volume;
        public String Delta;
        public String Price;
        public int Group;

        public LegItem() {
        }

        public LegItem(String marketID, String marketRef, int volume, String delta, String price, int group) {
            this.MarketID = marketID;
            this.MarketRef = marketRef;
            this.Volume = volume;
            this.Delta = delta;
            this.Price = price;
            this.Group = group;
        }
    }
}

