/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class MsgMarketDepthTradeD
extends Message {
    public String MarketID;
    public NDateTime Time;
    public int TotalTradedVolume;
    public int TotalTradeCount;
    public Price LastTradePrice;
    public int LastTradeVolume;
    public boolean DueToSpread;
    public BidOffer AtBidOrOffer;
    public boolean Delayed = false;
    public int[] OrderVolumes = new int[0];
    public MarketMode MarketMode;

    public MsgMarketDepthTradeD() {
        super(MessageType.MarketDepthTradeD);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketID = MsgMarketDepthTradeD.readShortString(in);
        this.Time = MsgMarketDepthTradeD.readDateTime(in);
        this.TotalTradedVolume = MsgMarketDepthTradeD.readInteger(in);
        this.LastTradeVolume = MsgMarketDepthTradeD.readInteger(in);
        this.DueToSpread = MsgMarketDepthTradeD.readBooleanAlt(in);
        this.AtBidOrOffer = BidOffer.get(MsgMarketDepthTradeD.readIntBytes(in, 1));
        this.Delayed = MsgMarketDepthTradeD.readBooleanAlt(in);
        this.OrderVolumes = MsgMarketDepthTradeD.readIntegerArray(in);
        this.TotalTradeCount = MsgMarketDepthTradeD.readInteger(in);
        this.LastTradePrice = MsgMarketDepthTradeD.readPrice(in);
        this.MarketMode = com.t4login.definitions.MarketMode.get(MsgMarketDepthTradeD.readIntBytes(in, 1));
        if (this.LastTradePrice == null) {
            this.LastTradePrice = Price.Zero;
        }
        for (int i = 0; i < this.OrderVolumes.length; ++i) {
            this.OrderVolumes[i] = Math.abs(this.OrderVolumes[i]);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketDepthTradeD[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("TotalTradedVolume: ").append(this.TotalTradedVolume).append(", ");
        sb.append("TotalTradeCount: ").append(this.TotalTradeCount).append(", ");
        sb.append("LastTradePrice: ").append(this.LastTradePrice).append(", ");
        sb.append("LastTradeVolume: ").append(this.LastTradeVolume).append(", ");
        sb.append("DueToSpread: ").append(this.DueToSpread).append(", ");
        sb.append("AtBidOrOffer: ").append(this.AtBidOrOffer).append(", ");
        sb.append("OrderVolumes: ").append(Arrays.toString(this.OrderVolumes)).append(", ");
        sb.append("Delayed: ").append(this.Delayed).append(", ");
        sb.append("MarketMode: ").append(this.MarketMode).append("]");
        return sb.toString();
    }
}

