/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.DepthBuffer;
import com.t4login.definitions.DepthLevels;
import com.t4login.definitions.MarketFlags2;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;

public class MsgMarketDepthD
extends Message {
    public int MarketIdent;
    public String MarketID = "";
    public int Numerator;
    public DepthLevels IncludedDepthLevels = DepthLevels.Undefined;
    public DepthLevels ChangeLevel = DepthLevels.Undefined;
    public DepthBuffer ChangeBuffer = DepthBuffer.NoSubscription;
    public NDateTime Time;
    public boolean Delayed;
    public DepthData Depth = new DepthData();
    public TradeData DepthTrade = new TradeData();
    public ModeData DepthMode = new ModeData();
    public IndicativeOpenData IndicativeOpen = new IndicativeOpenData();

    public MsgMarketDepthD() {
        super(MessageType.MarketDepthD);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.Depth = new DepthData();
        this.DepthTrade = new TradeData();
        this.DepthMode = new ModeData();
        this.IndicativeOpen = new IndicativeOpenData();
        this.MarketIdent = MsgMarketDepthD.read7BitInteger(in);
        if (this.MarketIdent == 0) {
            this.MarketID = MsgMarketDepthD.readShortString(in);
        }
        this.Delayed = MsgMarketDepthD.readBooleanAlt(in);
        this.Time = MsgMarketDepthD.read7BitDateTime(in);
        this.ChangeBuffer = DepthBuffer.get(MsgMarketDepthD.readIntBytes(in, 1));
        this.ChangeLevel = DepthLevels.get(MsgMarketDepthD.readIntBytes(in, 1));
        this.DepthMode.Mode = MarketMode.get(MsgMarketDepthD.read7BitInteger(in));
        this.DepthMode.Flags = MarketFlags2.fromFlags(MsgMarketDepthD.read7BitInteger(in));
        this.DepthTrade.TotalTradedVolume = MsgMarketDepthD.read7BitInteger(in);
        this.DepthTrade.TotalTradeCount = MsgMarketDepthD.read7BitInteger(in);
        this.DepthTrade.DueToSpread = MsgMarketDepthD.readBooleanAlt(in);
        this.DepthTrade.AtBidOrOffer = BidOffer.get(MsgMarketDepthD.readIntBytes(in, 1));
        this.DepthTrade.LastTradePrice = MsgMarketDepthD.read7BitPriceN(in);
        this.DepthTrade.LastTradeTotalVolume = MsgMarketDepthD.read7BitInteger(in);
        this.DepthTrade.LastTradeVolume = MsgMarketDepthD.read7BitInteger(in);
        boolean lastTradeAndSpread = MsgMarketDepthD.readBooleanAlt(in);
        if (!lastTradeAndSpread) {
            this.DepthTrade.LastTradeSpdPrice = MsgMarketDepthD.read7BitPriceN(in);
            this.DepthTrade.LastTradeSpdTotalVolume = MsgMarketDepthD.read7BitInteger(in);
            this.DepthTrade.LastTradeSpdVolume = MsgMarketDepthD.read7BitInteger(in);
        } else {
            this.DepthTrade.LastTradeSpdPrice = this.DepthTrade.LastTradePrice;
            this.DepthTrade.LastTradeSpdTotalVolume = this.DepthTrade.LastTradeTotalVolume;
            this.DepthTrade.LastTradeSpdVolume = this.DepthTrade.LastTradeVolume;
        }
        int bidCount = MsgMarketDepthD.readIntBytes(in, 1);
        this.Depth.Bids.ensureCapacity(bidCount);
        for (int i = 0; i < bidCount; ++i) {
            Price depthPrice = MsgMarketDepthD.read7BitPrice(in);
            int depthVolume = MsgMarketDepthD.read7BitInteger(in);
            int depthOrders = MsgMarketDepthD.read7BitInteger(in);
            this.Depth.Bids.add(new DepthLine(depthPrice, depthVolume, depthOrders));
        }
        int offerCount = MsgMarketDepthD.readIntBytes(in, 1);
        this.Depth.Offers.ensureCapacity(offerCount);
        for (int i = 0; i < offerCount; ++i) {
            Price depthPrice = MsgMarketDepthD.read7BitPrice(in);
            int depthVolume = MsgMarketDepthD.read7BitInteger(in);
            int depthOrders = MsgMarketDepthD.read7BitInteger(in);
            this.Depth.Offers.add(new DepthLine(depthPrice, depthVolume, depthOrders));
        }
        int impliedBidCount = MsgMarketDepthD.readIntBytes(in, 1);
        this.Depth.ImpliedBids.ensureCapacity(impliedBidCount);
        for (int i = 0; i < impliedBidCount; ++i) {
            Price depthPrice = MsgMarketDepthD.read7BitPrice(in);
            int depthVolume = MsgMarketDepthD.read7BitInteger(in);
            int depthOrders = MsgMarketDepthD.read7BitInteger(in);
            this.Depth.ImpliedBids.add(new DepthLine(depthPrice, depthVolume, depthOrders));
        }
        int impliedOfferCount = MsgMarketDepthD.readIntBytes(in, 1);
        this.Depth.ImpliedOffers.ensureCapacity(impliedOfferCount);
        for (int i = 0; i < impliedOfferCount; ++i) {
            Price depthPrice = MsgMarketDepthD.read7BitPrice(in);
            int depthVolume = MsgMarketDepthD.read7BitInteger(in);
            int depthOrders = MsgMarketDepthD.read7BitInteger(in);
            this.Depth.ImpliedOffers.add(new DepthLine(depthPrice, depthVolume, depthOrders));
        }
        this.DepthTrade.Time = MsgMarketDepthD.read7BitDateTime(in);
        this.IndicativeOpen.Volume = MsgMarketDepthD.read7BitInteger(in);
        if (this.IndicativeOpen.Volume > 0) {
            this.IndicativeOpen.Price = MsgMarketDepthD.read7BitPriceN(in);
            this.IndicativeOpen.Time = MsgMarketDepthD.read7BitDateTime(in, this.Time);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketDepthD[");
        sb.append("MarketIdent: ").append(this.MarketIdent).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("Numerator: ").append(this.Numerator).append(", ");
        sb.append("IncludedDepthLevels: ").append(this.IncludedDepthLevels).append(", ");
        sb.append("ChangeLevel: ").append(this.ChangeLevel).append(", ");
        sb.append("ChangeBuffer: ").append(this.ChangeBuffer).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("Delayed: ").append(this.Delayed).append(", ");
        sb.append("Mode: ").append(this.DepthMode.Mode).append(", ");
        sb.append("ModeFlags: ").append(this.DepthMode.Flags).append(", ");
        sb.append("DepthTrade.TotalTradedVolume: ").append(this.DepthTrade.TotalTradedVolume).append(", ");
        sb.append("DepthTrade.LastTradePrice: ").append(this.DepthTrade.LastTradePrice).append(", ");
        sb.append("DepthTrade.LastTradeVolume: ").append(this.DepthTrade.LastTradeVolume).append(", ");
        sb.append("DepthTrade.LastTradeTotalVolume: ").append(this.DepthTrade.LastTradeTotalVolume).append(", ");
        sb.append("DepthTrade.LastTradeSpdPrice: ").append(this.DepthTrade.LastTradeSpdPrice).append(", ");
        sb.append("DepthTrade.LastTradeSpdVolume: ").append(this.DepthTrade.LastTradeSpdVolume).append(", ");
        sb.append("DepthTrade.LastTradeSpdTotalVolume: ").append(this.DepthTrade.LastTradeSpdTotalVolume).append(", ");
        sb.append("DepthTrade.DueToSpread: ").append(this.DepthTrade.DueToSpread).append(", ");
        sb.append("DepthTrade.AtBidOrOffer: ").append(this.DepthTrade.AtBidOrOffer).append(", ");
        sb.append("DepthTrade.Time: ").append(this.DepthTrade.Time).append(", ");
        sb.append("Bid Count: ").append(this.Depth.Bids.size()).append(", ");
        sb.append("Offer Count: ").append(this.Depth.Offers.size()).append(", ");
        sb.append("ImpliedBid Count: ").append(this.Depth.ImpliedBids.size()).append(", ");
        sb.append("ImpliedOffer Count: ").append(this.Depth.ImpliedOffers.size()).append(", ");
        sb.append("IndicativeOpen Volume: ").append(this.IndicativeOpen.Volume).append(", ");
        sb.append("IndicativeOpen Count: ").append(this.IndicativeOpen.Price).append(", ");
        sb.append("IndicativeOpen Count: ").append(this.IndicativeOpen.Time);
        sb.append("]");
        return sb.toString();
    }

    public static class DepthData {
        public ArrayList<DepthLine> Bids = new ArrayList();
        public ArrayList<DepthLine> Offers = new ArrayList();
        public ArrayList<DepthLine> ImpliedBids = new ArrayList();
        public ArrayList<DepthLine> ImpliedOffers = new ArrayList();
    }

    public static class TradeData {
        public int TotalTradedVolume;
        public int TotalTradeCount;
        public Price LastTradePrice;
        public int LastTradeVolume;
        public int LastTradeTotalVolume;
        public Price LastTradeSpdPrice;
        public int LastTradeSpdVolume;
        public int LastTradeSpdTotalVolume;
        public boolean DueToSpread;
        public BidOffer AtBidOrOffer = BidOffer.Undefined;
        public NDateTime Time;
    }

    public static class ModeData {
        public MarketMode Mode = MarketMode.Undefined;
        public Set<MarketFlags2> Flags;
    }

    public static class IndicativeOpenData {
        public int Volume;
        public Price Price;
        public NDateTime Time;
    }

    public static class DepthLine {
        public Price Price;
        public int Volume;
        public int NumOfOrders;

        public DepthLine(Price price, int volume, int orders) {
            this.Price = price;
            this.Volume = volume;
            this.NumOfOrders = orders;
        }
    }
}

