/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MsgMarketByOrderUpdate
extends Message {
    public int MarketIdent;
    public String MarketID;
    public NDateTime Time;
    public MarketMode Mode;
    public List<Update> Updates = new ArrayList<Update>();

    public MsgMarketByOrderUpdate() {
        super(MessageType.MarketByOrderUpdate);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketIdent = MsgMarketByOrderUpdate.read7BitInteger(in);
        if (this.MarketIdent == 0) {
            this.MarketID = MsgMarketByOrderUpdate.readShortString(in);
        }
        this.Time = MsgMarketByOrderUpdate.read7BitDateTime(in);
        this.Mode = MarketMode.get(MsgMarketByOrderUpdate.read7BitInteger(in));
        this.Updates = new ArrayList<Update>();
        int count = MsgMarketByOrderUpdate.read7BitInteger(in);
        for (int i = 0; i < count; ++i) {
            Update update = new Update();
            update.Update = UpdateType.fromInteger(MsgMarketByOrderUpdate.read7BitInteger(in));
            switch (update.Update) {
                case Delete: {
                    update.OrderID = MsgMarketByOrderUpdate.read7BitULong(in);
                    break;
                }
                case Clear: {
                    break;
                }
                default: {
                    update.OrderID = MsgMarketByOrderUpdate.read7BitULong(in);
                    update.BidOffer = BidOffer.get(MsgMarketByOrderUpdate.read7BitInteger(in));
                    update.Price = MsgMarketByOrderUpdate.read7BitPrice(in);
                    update.Volume = MsgMarketByOrderUpdate.read7BitInteger(in);
                    update.Priority = MsgMarketByOrderUpdate.read7BitULong(in);
                }
            }
            this.Updates.add(update);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketByOrderUpdate[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("MarketIdent: ").append(this.MarketIdent).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("Mode: ").append(this.Mode).append(", ");
        sb.append("Updates (count): ").append(this.Updates.size()).append("]");
        return sb.toString();
    }

    public static class Update {
        public UpdateType Update;
        public BigInteger OrderID;
        public BidOffer BidOffer;
        public Price Price;
        public int Volume;
        public BigInteger Priority;
    }

    public static enum UpdateType {
        AddOrUpdate,
        Delete,
        Clear;


        public static UpdateType fromInteger(int x) {
            return switch (x) {
                case 0 -> AddOrUpdate;
                case 1 -> Delete;
                case 2 -> Clear;
                default -> null;
            };
        }
    }
}

