/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.BidOffer;
import com.t4login.definitions.MarketMode;
import com.t4login.definitions.priceconversion.Price;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class MsgMarketByOrderSnapshot
extends Message {
    public int MarketIdent;
    public String MarketID;
    public NDateTime Time;
    public MarketMode Mode;
    public boolean DueToConnection;
    public List<Order> Orders = new ArrayList<Order>();

    public MsgMarketByOrderSnapshot() {
        super(MessageType.MarketByOrderSnapshot);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.MarketIdent = MsgMarketByOrderSnapshot.read7BitInteger(in);
        if (this.MarketIdent == 0) {
            this.MarketID = MsgMarketByOrderSnapshot.readShortString(in);
        }
        this.Time = MsgMarketByOrderSnapshot.read7BitDateTime(in);
        this.Mode = MarketMode.get(MsgMarketByOrderSnapshot.read7BitInteger(in));
        this.DueToConnection = MsgMarketByOrderSnapshot.readBooleanAlt(in);
        this.Orders = new ArrayList<Order>();
        int count = MsgMarketByOrderSnapshot.read7BitInteger(in);
        for (int i = 0; i < count; ++i) {
            Order order = new Order();
            order.OrderID = MsgMarketByOrderSnapshot.read7BitULong(in);
            order.BidOffer = BidOffer.get(MsgMarketByOrderSnapshot.read7BitInteger(in));
            order.Price = MsgMarketByOrderSnapshot.read7BitPrice(in);
            order.Volume = MsgMarketByOrderSnapshot.read7BitInteger(in);
            order.Priority = MsgMarketByOrderSnapshot.read7BitULong(in);
            this.Orders.add(order);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgMarketByOrderSnapshot[");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("MarketIdent: ").append(this.MarketIdent).append(", ");
        sb.append("Time: ").append(this.Time).append(", ");
        sb.append("Mode: ").append(this.Mode).append(", ");
        sb.append("DueToConnection: ").append(this.DueToConnection).append(", ");
        sb.append("Orders (count): ").append(this.Orders.size()).append("]");
        return sb.toString();
    }

    public static class Order {
        public BigInteger OrderID;
        public BidOffer BidOffer;
        public Price Price;
        public int Volume;
        public BigInteger Priority;
    }
}

