/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.AccountMode;
import com.t4login.definitions.AutoPullType;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.LoginResult;
import com.t4login.definitions.MarketDataType;
import com.t4login.messages.Message;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MsgLoginResponse2
extends Message
implements Iterable<Message> {
    public String UserID = "";
    public LoginResult Result = LoginResult.Unknown;
    public String Roles = "";
    public String BrandName = "";
    public String UserName = "";
    public String ServerName = "";
    public boolean PwdComplexity;
    public int PwdExpireDays;
    public int PwdHistoryDays;
    public AutoPullType AutoPull = AutoPullType.None;
    public NDateTime PwdExpiresAt = NDateTime.MinValue;
    public String ServerVersion = "";
    public List<Exchange> Exchanges = new ArrayList<Exchange>();
    public List<Account> Accounts = new ArrayList<Account>();
    public List<Message> Messages = new ArrayList<Message>();
    public String FirmID = "";
    public String Firm = "";
    public String ParentFirmID = "";
    public String ParentFirm = "";
    public boolean DeviceAuthorized = false;
    public boolean EmailVerified = false;

    public MsgLoginResponse2() {
        super(MessageType.LoginResponse2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException {
        int i;
        int i2;
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.UserID = MsgLoginResponse2.readShortString(in).toUpperCase(Locale.US);
        this.Result = LoginResult.get(MsgLoginResponse2.readIntBytes(in, 1));
        this.Roles = this.readMediumString(in);
        this.BrandName = MsgLoginResponse2.readShortString(in);
        this.UserName = MsgLoginResponse2.readShortString(in);
        this.ServerName = MsgLoginResponse2.readShortString(in);
        this.PwdComplexity = MsgLoginResponse2.readBooleanAlt(in);
        this.PwdExpireDays = MsgLoginResponse2.readInteger(in);
        this.PwdHistoryDays = MsgLoginResponse2.readInteger(in);
        this.PwdExpiresAt = MsgLoginResponse2.readDateTime(in);
        this.AutoPull = AutoPullType.get(MsgLoginResponse2.readIntBytes(in, 1));
        this.ServerVersion = MsgLoginResponse2.readShortString(in);
        this.Exchanges.clear();
        int numExchanges = MsgLoginResponse2.readInteger(in);
        for (int i3 = 0; i3 < numExchanges; ++i3) {
            Exchange exch = new Exchange();
            exch.ExchangeID = MsgLoginResponse2.readShortString(in);
            exch.Description = MsgLoginResponse2.readShortString(in);
            exch.Disabled = MsgLoginResponse2.readBooleanAlt(in);
            exch.ContractType = ContractType.get(MsgLoginResponse2.readIntBytes(in, 1));
            exch.HasPermission = MsgLoginResponse2.readBooleanAlt(in);
            exch.HasChartPermission = MsgLoginResponse2.readBooleanAlt(in);
            this.Exchanges.add(exch);
        }
        this.Accounts.clear();
        int numAccounts = MsgLoginResponse2.readInteger(in);
        for (i2 = 0; i2 < numAccounts; ++i2) {
            Account acct = new Account();
            acct.AccountID = MsgLoginResponse2.readShortString(in);
            acct.AccountNumber = MsgLoginResponse2.readShortString(in);
            this.Accounts.add(acct);
        }
        for (i2 = 0; i2 < numExchanges; ++i2) {
            this.Exchanges.get((int)i2).UDS = MsgLoginResponse2.readBooleanAlt(in);
        }
        this.Messages.clear();
        int numMessages = MsgLoginResponse2.readInteger(in);
        for (i = 0; i < numMessages; ++i) {
            Message msg = Message.getMessage(in);
            if (msg == null) continue;
            this.Messages.add(msg);
        }
        for (i = 0; i < numExchanges; ++i) {
            int flagsVal = MsgLoginResponse2.readIntBytes(in, 1);
            this.Exchanges.get((int)i).MarketDataType = MarketDataType.fromFlags(flagsVal);
        }
        for (i = 0; i < numExchanges; ++i) {
            this.Exchanges.get((int)i).ClearingExchange = MsgLoginResponse2.readShortString(in);
        }
        for (i = 0; i < numAccounts; ++i) {
            this.Accounts.get((int)i).AccountName = MsgLoginResponse2.readShortString(in);
            this.Accounts.get((int)i).DisplayName = MsgLoginResponse2.readShortString(in);
        }
        this.FirmID = MsgLoginResponse2.readShortString(in);
        this.Firm = MsgLoginResponse2.readShortString(in);
        this.ParentFirmID = MsgLoginResponse2.readShortString(in);
        this.ParentFirm = MsgLoginResponse2.readShortString(in);
        if (ver > 7) {
            this.DeviceAuthorized = MsgLoginResponse2.readBooleanAlt(in);
        }
        if (ver > 8) {
            for (i = 0; i < numAccounts; ++i) {
                this.Accounts.get((int)i).Mode = AccountMode.get(MsgLoginResponse2.read7BitInteger(in));
            }
        }
        if (ver > 9) {
            this.EmailVerified = MsgLoginResponse2.readBooleanAlt(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgLoginResponse2.writeShortString(out, this.UserID);
        this.writeIntBytes(out, this.Result.getValue(), 1);
        this.writeMediumString(out, this.Roles);
        MsgLoginResponse2.writeShortString(out, this.BrandName);
        MsgLoginResponse2.writeShortString(out, this.UserName);
        MsgLoginResponse2.writeShortString(out, this.ServerName);
        MsgLoginResponse2.writeBooleanAlt(out, this.PwdComplexity);
        MsgLoginResponse2.writeInteger(out, this.PwdExpireDays);
        MsgLoginResponse2.writeInteger(out, this.PwdHistoryDays);
        MsgLoginResponse2.writeDateTime(out, this.PwdExpiresAt);
        this.writeIntBytes(out, this.AutoPull.getValue(), 1);
        MsgLoginResponse2.writeShortString(out, this.ServerVersion);
        MsgLoginResponse2.writeInteger(out, 0);
        MsgLoginResponse2.writeInteger(out, 0);
        MsgLoginResponse2.writeInteger(out, 0);
        MsgLoginResponse2.writeShortString(out, this.FirmID);
        MsgLoginResponse2.writeShortString(out, this.Firm);
        MsgLoginResponse2.writeShortString(out, this.ParentFirmID);
        MsgLoginResponse2.writeShortString(out, this.ParentFirm);
        MsgLoginResponse2.writeBoolean(out, this.DeviceAuthorized);
        MsgLoginResponse2.writeBoolean(out, this.EmailVerified);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgLoginResponse[");
        sb.append("UserID: ").append(this.UserID).append(", ");
        sb.append("Result: ").append(this.Result).append(", ");
        sb.append("Roles: ").append(this.Roles).append(", ");
        sb.append("BrandName: ").append(this.BrandName).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("ServerName: ").append(this.ServerName).append(", ");
        sb.append("PwdComplexity: ").append(this.PwdComplexity).append(", ");
        sb.append("PwdExpireDays: ").append(this.PwdExpireDays).append(", ");
        sb.append("PwdHistoryDays: ").append(this.PwdHistoryDays).append(", ");
        sb.append("AutoPull: ").append(this.AutoPull).append(", ");
        sb.append("PwdExpiresAt: ").append(this.PwdExpiresAt).append(", ");
        sb.append("ServerVersion: ").append(this.ServerVersion).append(", ");
        sb.append("n Exchanges: ").append(this.Exchanges.size()).append(", ");
        sb.append("n Accounts: ").append(this.Accounts.size()).append(", ");
        sb.append("n Messages: ").append(this.Messages.size()).append(", ");
        sb.append("FirmID: ").append(this.FirmID).append(", ");
        sb.append("Firm: ").append(this.Firm).append(", ");
        sb.append("ParentFirmID: ").append(this.ParentFirmID).append(", ");
        sb.append("ParentFirm: ").append(this.ParentFirm).append(", ");
        sb.append("DeviceAuthorized: ").append(this.DeviceAuthorized).append("]");
        sb.append("DeviceAuthorized: ").append(this.DeviceAuthorized).append(", ");
        sb.append("EmailVerified: ").append(this.EmailVerified).append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Message> iterator() {
        return this.Messages.iterator();
    }

    public static class Exchange
    implements Serializable {
        public String ExchangeID;
        public String Description;
        public boolean Disabled;
        public ContractType ContractType;
        public boolean HasPermission;
        public boolean HasChartPermission;
        public boolean UDS;
        public Set<MarketDataType> MarketDataType = new HashSet<MarketDataType>();
        public String ClearingExchange;
    }

    public static class Account {
        public String AccountID;
        public String AccountNumber;
        public String AccountName;
        public String DisplayName;
        public AccountMode Mode;
    }
}

