/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.definitions.LoginMode;
import com.t4login.definitions.SimpleSignInMethod;
import com.t4login.messages.Message;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MsgLogin
extends Message {
    public static final int APISYSTEM_UNKNOWN = 0;
    public static final int APISYSTEM_API = 1;
    public static final int APISYSTEM_APIPLUS = 2;
    public static final int APISYSTEM_FIX42 = 3;
    public static final int APISYSTEM_ANDROID = 4;
    public static final int APISYSTEM_IOS = 5;
    public String Firm = "";
    public String UserName = "";
    public String Password = "";
    public String Version = "";
    public String AppName = "";
    public String AppLicense = "";
    public boolean FirstLogin = true;
    public boolean AdditionalUser = false;
    public String NewPassword = "";
    public int APISystem;
    public String MACAddress = "";
    public String ClientIP = "";
    public String Culture = "";
    public String OSPlatform = "";
    public String OSVersion = "";
    public boolean VirtualMachine = false;
    public boolean AutoAccountSubscribe = false;
    public String UserSettingsFile = "";
    public InternetProviderPing InternetProviders = new InternetProviderPing();
    public SimpleSignInMethod SSIMethod = SimpleSignInMethod.None;
    public boolean CreateAccount = false;
    public String APIVersion = "";
    public LoginMode Mode = LoginMode.Login;
    public String EULASignature = "";
    public String CompatibilityVersion = "4.7.72.108";

    public MsgLogin() {
        super(MessageType.Login);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.Firm = MsgLogin.readString(in);
        this.UserName = MsgLogin.readString(in);
        this.Password = MsgLogin.readString(in);
        this.Version = MsgLogin.readString(in);
        this.AppName = MsgLogin.readString(in);
        this.AppLicense = MsgLogin.readString(in);
        this.FirstLogin = MsgLogin.readBoolean(in);
        this.AdditionalUser = MsgLogin.readBoolean(in);
        this.NewPassword = MsgLogin.readString(in);
        this.APISystem = MsgLogin.readInteger(in);
        this.MACAddress = MsgLogin.readString(in);
        this.ClientIP = MsgLogin.readString(in);
        this.Culture = MsgLogin.readShortString(in);
        this.OSPlatform = MsgLogin.readShortString(in);
        this.OSVersion = MsgLogin.readShortString(in);
        this.VirtualMachine = MsgLogin.readBooleanAlt(in);
        this.AutoAccountSubscribe = MsgLogin.readBooleanAlt(in);
        this.UserSettingsFile = MsgLogin.readShortString(in);
        this.InternetProviders.Internap = MsgLogin.readLong(in);
        this.InternetProviders.Level3 = MsgLogin.readLong(in);
        this.InternetProviders.Yipes = MsgLogin.readLong(in);
        this.InternetProviders.ATT = MsgLogin.readLong(in);
        this.SSIMethod = SimpleSignInMethod.get(MsgLogin.readIntBytes(in, 1));
        this.CreateAccount = MsgLogin.readBoolean(in);
        this.APIVersion = MsgLogin.readString(in);
        if (ver > 14) {
            this.Mode = LoginMode.get(MsgLogin.readIntBytes(in, 1));
        }
        if (ver > 15) {
            this.EULASignature = MsgLogin.readString(in);
        }
        if (ver > 16) {
            this.CompatibilityVersion = MsgLogin.readString(in);
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgLogin.writeString(out, this.Firm);
        MsgLogin.writeString(out, this.UserName);
        MsgLogin.writeString(out, this.Password);
        MsgLogin.writeString(out, this.Version);
        MsgLogin.writeString(out, this.AppName);
        MsgLogin.writeString(out, this.AppLicense);
        MsgLogin.writeBoolean(out, this.FirstLogin);
        MsgLogin.writeBoolean(out, this.AdditionalUser);
        MsgLogin.writeString(out, this.NewPassword);
        MsgLogin.writeInteger(out, this.APISystem);
        MsgLogin.writeShortString(out, this.MACAddress);
        MsgLogin.writeShortString(out, this.ClientIP);
        MsgLogin.writeShortString(out, this.Culture);
        MsgLogin.writeShortString(out, this.OSPlatform);
        MsgLogin.writeShortString(out, this.OSVersion);
        MsgLogin.writeBooleanAlt(out, this.VirtualMachine);
        MsgLogin.writeBooleanAlt(out, this.AutoAccountSubscribe);
        MsgLogin.writeShortString(out, this.UserSettingsFile);
        MsgLogin.writeLong(out, this.InternetProviders.Internap);
        MsgLogin.writeLong(out, this.InternetProviders.Level3);
        MsgLogin.writeLong(out, this.InternetProviders.Yipes);
        MsgLogin.writeLong(out, this.InternetProviders.ATT);
        this.writeIntBytes(out, this.SSIMethod.getValue(), 1);
        MsgLogin.writeBoolean(out, this.CreateAccount);
        MsgLogin.writeString(out, this.APIVersion);
        this.writeIntBytes(out, this.Mode.getValue(), 1);
        MsgLogin.writeString(out, this.EULASignature);
        MsgLogin.writeString(out, this.CompatibilityVersion);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgLogin[");
        sb.append("Firm: ").append(this.Firm).append(", ");
        sb.append("UserName: ").append(this.UserName).append(", ");
        sb.append("Password: ").append("****").append(", ");
        sb.append("CreateAccount: ").append(this.CreateAccount).append(", ");
        sb.append("Mode: ").append(this.Mode).append(", ");
        sb.append("Version: ").append(this.Version).append(", ");
        sb.append("AppName: ").append(this.AppName).append(", ");
        sb.append("AppLicense: ").append(this.AppLicense).append(", ");
        sb.append("FirstLogin: ").append(this.FirstLogin).append(", ");
        sb.append("AdditionalUser: ").append(this.AdditionalUser).append(", ");
        sb.append("NewPassword: ").append(this.NewPassword.isEmpty() ? "" : "****").append(", ");
        sb.append("APISystem: ").append(this.APISystem).append(", ");
        sb.append("APIVersion: ").append(this.APIVersion).append(", ");
        sb.append("MACAddress: ").append(this.MACAddress).append(", ");
        sb.append("ClientIP: ").append(this.ClientIP).append(", ");
        sb.append("Culture: ").append(this.Culture).append(", ");
        sb.append("OSPlatform: ").append(this.OSPlatform).append(", ");
        sb.append("OSVersion: ").append(this.OSVersion).append(", ");
        sb.append("VirtualMachine: ").append(this.VirtualMachine).append(", ");
        sb.append("AutoAccountSubscribe: ").append(this.AutoAccountSubscribe).append(", ");
        sb.append("UserSettingsFile: ").append(this.UserSettingsFile).append(", ");
        sb.append("SSIMethod: ").append(this.SSIMethod).append(", ");
        sb.append("EULASignature: ").append(this.EULASignature).append(", ");
        sb.append("CompatibilityVersion: ").append(this.CompatibilityVersion).append(", ");
        sb.append("InternetProviders[");
        sb.append("Internap: ").append(this.InternetProviders.Internap).append(", ");
        sb.append("Level3: ").append(this.InternetProviders.Level3).append(", ");
        sb.append("Yipes: ").append(this.InternetProviders.Yipes).append(", ");
        sb.append("ATT: ").append(this.InternetProviders.ATT).append(", ");
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    public static class InternetProviderPing {
        public long Internap = -1L;
        public long Level3 = -1L;
        public long Yipes = -1L;
        public long ATT = -1L;
    }
}

