/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.messages.Message;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MsgHeartbeat
extends Message {
    private long timeStamp = 0L;
    private int lastPingTime = 0;

    public MsgHeartbeat() {
        super(MessageType.Heartbeat);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public MsgHeartbeat setTimeStamp(long ts) {
        this.timeStamp = ts;
        return this;
    }

    public int getLastPingTime() {
        return this.lastPingTime;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException {
        this.timeStamp = MsgHeartbeat.readLong(in);
        this.lastPingTime = MsgHeartbeat.readInteger(in);
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgHeartbeat.writeLong(out, this.timeStamp);
        MsgHeartbeat.writeInteger(out, this.lastPingTime);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgHeartbeat[");
        sb.append("TimeStamp: ").append(this.timeStamp).append(", ");
        sb.append("LastPingTime: ").append(this.lastPingTime);
        sb.append("]");
        return sb.toString();
    }
}

