/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.Json;
import com.t4login.definitions.ActiveMonthDetails;
import com.t4login.definitions.AutoLiquidateDetails;
import com.t4login.definitions.ContractFields;
import com.t4login.messages.FirmContract;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class MsgFirmSnapshot
extends Message {
    public String FirmID = "";
    public boolean DueToConnection;
    public List<ClearingExchange> ClearingExchanges = new ArrayList<ClearingExchange>();
    public List<FirmContract> Contracts = new ArrayList<FirmContract>();

    public MsgFirmSnapshot() {
        super(MessageType.FirmSnapshot);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        Set<ContractFields> fields;
        FirmContract c;
        int i;
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.FirmID = MsgFirmSnapshot.readString(in).toUpperCase(Locale.US);
        this.DueToConnection = MsgFirmSnapshot.readBooleanAlt(in);
        this.ClearingExchanges = new ArrayList<ClearingExchange>();
        int nExchanges = MsgFirmSnapshot.read7BitInteger(in);
        for (int i2 = 0; i2 < nExchanges; ++i2) {
            ClearingExchange ce = new ClearingExchange();
            ce.ClearingExchange = MsgFirmSnapshot.readShortString(in);
            ce.Enabled = MsgFirmSnapshot.readBooleanAlt(in);
            this.ClearingExchanges.add(ce);
        }
        this.Contracts = new ArrayList<FirmContract>();
        int nContracts = MsgFirmSnapshot.read7BitInteger(in);
        FirmContract last = new FirmContract();
        for (i = 0; i < nContracts; ++i) {
            c = new FirmContract();
            fields = ContractFields.fromFlags(MsgFirmSnapshot.read7BitInteger(in));
            c.ExchangeID = fields.contains(ContractFields.ExchangeID) ? MsgFirmSnapshot.readShortString(in) : last.ExchangeID;
            c.ContractID = fields.contains(ContractFields.ContractID) ? MsgFirmSnapshot.readShortString(in) : last.ContractID;
            c.Enabled = fields.contains(ContractFields.Enabled) ? MsgFirmSnapshot.readBooleanAlt(in) : last.Enabled;
            c.Margin = fields.contains(ContractFields.Margin) ? MsgFirmSnapshot.readDouble(in) : last.Margin;
            c.StrategyMargin = fields.contains(ContractFields.StrategyMargin) ? MsgFirmSnapshot.readDouble(in) : last.StrategyMargin;
            c.CustomerFee = fields.contains(ContractFields.CustomerFee) ? MsgFirmSnapshot.readDouble(in) : last.CustomerFee;
            c.MemberFee = fields.contains(ContractFields.MemberFee) ? MsgFirmSnapshot.readDouble(in) : last.MemberFee;
            c.BlockExpiring = fields.contains(ContractFields.BlockExpiring) ? MsgFirmSnapshot.read7BitInteger(in) : last.BlockExpiring;
            c.BlockExpiringCanOverride = fields.contains(ContractFields.BlockExpiringCanOverride) ? MsgFirmSnapshot.readBooleanAlt(in) : last.BlockExpiringCanOverride;
            c.FixedMargin = fields.contains(ContractFields.FixedMargin) ? MsgFirmSnapshot.readBooleanAlt(in) : last.FixedMargin;
            if (fields.contains(ContractFields.AutoLiquidate)) {
                String autoLiquidateJson = MsgFirmSnapshot.readString(in);
                c.AutoLiquidate = Json.fromJson(autoLiquidateJson, AutoLiquidateDetails.class);
            } else {
                c.AutoLiquidate = last.AutoLiquidate;
            }
            last = c;
            this.Contracts.add(c);
        }
        last = new FirmContract();
        for (i = 0; i < nContracts; ++i) {
            c = this.Contracts.get(i);
            fields = ContractFields.fromFlags(MsgFirmSnapshot.read7BitInteger(in));
            if (fields.contains(ContractFields.ActiveMonths)) {
                String activeMonthsJson = MsgFirmSnapshot.readString(in);
                ActiveMonthDetails activeMonths = Json.fromJson(activeMonthsJson, ActiveMonthDetails.class);
                if (activeMonths == null) {
                    activeMonths = new ActiveMonthDetails();
                }
                c.ActiveMonths = activeMonths;
            } else {
                c.ActiveMonths = last.ActiveMonths;
            }
            last = c;
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgFirmSnapshot[");
        sb.append("FirmID: ").append(this.FirmID).append(", ");
        sb.append("DueToConnection: ").append(this.DueToConnection).append(", ");
        sb.append("n ClearingExchanges: ").append(this.ClearingExchanges.size()).append(", ");
        sb.append("n Contracts: ").append(this.Contracts.size());
        sb.append("]");
        return sb.toString();
    }

    public static class ClearingExchange {
        public String ClearingExchange;
        public boolean Enabled;
    }
}

