/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.Json;
import com.t4login.definitions.ActiveMonthDetails;
import com.t4login.definitions.AutoLiquidateDetails;
import com.t4login.definitions.ThreeState;
import com.t4login.messages.FirmContract;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class MsgFirmContract
extends Message {
    public String FirmID = "";
    public FirmContract Contract = new FirmContract();

    public MsgFirmContract() {
        super(MessageType.FirmContract);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.FirmID = MsgFirmContract.readString(in).toUpperCase(Locale.US);
        this.Contract = new FirmContract();
        this.Contract.ExchangeID = MsgFirmContract.readString(in);
        this.Contract.ContractID = MsgFirmContract.readString(in);
        this.Contract.Enabled = ThreeState.get(MsgFirmContract.readInteger(in)).equals(ThreeState.True);
        this.Contract.Margin = MsgFirmContract.readDouble(in);
        this.Contract.StrategyMargin = MsgFirmContract.readDouble(in);
        this.Contract.CustomerFee = MsgFirmContract.readDouble(in);
        this.Contract.MemberFee = MsgFirmContract.readDouble(in);
        this.Contract.BlockExpiring = MsgFirmContract.readShort(in);
        this.Contract.BlockExpiringCanOverride = MsgFirmContract.readBooleanAlt(in);
        this.Contract.FixedMargin = MsgFirmContract.readBooleanAlt(in);
        String autoLiquidateJson = MsgFirmContract.readString(in);
        if (autoLiquidateJson.length() == 0) {
            autoLiquidateJson = "{}";
        }
        this.Contract.AutoLiquidate = Json.fromJson(autoLiquidateJson, AutoLiquidateDetails.class);
        String activeMonthsJson = MsgFirmContract.readString(in);
        this.Contract.ActiveMonths = Json.fromJson(activeMonthsJson, ActiveMonthDetails.class);
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgFirmContract[");
        sb.append("FirmID: ").append(this.FirmID).append(", ");
        sb.append("ExchangeID: ").append(this.Contract.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.Contract.ContractID).append(", ");
        sb.append("Enabled: ").append(this.Contract.Enabled).append(", ");
        sb.append("Margin: ").append(this.Contract.Margin).append(", ");
        sb.append("StrategyMargin: ").append(this.Contract.StrategyMargin).append(", ");
        sb.append("CustomerFee: ").append(this.Contract.CustomerFee).append(", ");
        sb.append("MemberFee: ").append(this.Contract.MemberFee).append(", ");
        sb.append("BlockExpiring: ").append(this.Contract.BlockExpiring).append(", ");
        sb.append("BlockExpiringCanOverride: ").append(this.Contract.BlockExpiringCanOverride).append(", ");
        sb.append("FixedMargin: ").append(this.Contract.FixedMargin).append(", ");
        sb.append("AutoLiquidate: ").append(Json.toJson(this.Contract.AutoLiquidate));
        sb.append("ActiveMonths: ").append(Json.toJson(this.Contract.ActiveMonths));
        sb.append("]");
        return sb.toString();
    }
}

