/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.Json;
import com.t4login.datetime.NDateTime;
import com.t4login.definitions.CategoryType;
import com.t4login.definitions.ContractType;
import com.t4login.definitions.util.ContractDetails;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import com.t4login.util.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class MsgContractDetails2
extends Message {
    public String ExchangeID = "";
    public String ContractID = "";
    public ContractType ContractType = com.t4login.definitions.ContractType.Unknown;
    public String Description = "";
    public NDateTime DayChangeTime = NDateTime.MinValue;
    public String DayChangeTimeExceptions = "Sat=N;Sun=N";
    public NDateTime DayChangeTimeAlt = NDateTime.MinValue.AddMinutes(30.0);
    public boolean Disabled = false;
    public int YieldYears = 0;
    public double YieldParValue = 0.0;
    public double YieldRate = 0.0;
    public int YieldValueDenominator = 0;
    public double YieldRedemption = 0.0;
    public double YieldPaymentsPerYear = 0.0;
    public int YieldBasis = 0;
    public String Currency = "";
    public CategoryType Category = CategoryType.Unknown;
    public String StrikeDetails = "";
    public String ContractRef = "";
    public String TradingSchedule = "";
    public List<Relation> Relations = new ArrayList<Relation>();
    public String ClearingCode = "";
    public String ProductDescription = "";
    public String MarginMaintToInit = "";
    public String MarginVolScan = "";
    public String MarginSOM = "";
    public String MarginInitialSpec = "";
    public String MarginMaintenanceSpec = "";
    public String MarginInitialHedge = "";
    public String MarginMaintenanceHedge = "";
    public String FloorCode = "";
    public int MaxDecimals = 0;
    public ContractDetails Details = new ContractDetails();

    public MsgContractDetails2() {
        super(MessageType.ContractDetails2);
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        String detailsJson;
        ContractDetails details;
        int i;
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.ExchangeID = MsgContractDetails2.readShortString(in);
        this.ContractID = MsgContractDetails2.readShortString(in);
        this.ContractType = com.t4login.definitions.ContractType.get(MsgContractDetails2.readIntBytes(in, 1));
        this.Description = MsgContractDetails2.readShortString(in);
        this.DayChangeTime = MsgContractDetails2.readDateTime(in);
        this.DayChangeTimeExceptions = MsgContractDetails2.readShortString(in);
        this.Disabled = MsgContractDetails2.readBooleanAlt(in);
        this.YieldYears = MsgContractDetails2.readIntBytes(in, 1);
        if (this.YieldYears > 0) {
            this.YieldParValue = MsgContractDetails2.readDouble(in);
            this.YieldRate = MsgContractDetails2.readDouble(in);
            this.YieldValueDenominator = MsgContractDetails2.readInteger(in);
            this.YieldRedemption = MsgContractDetails2.readDouble(in);
            this.YieldPaymentsPerYear = MsgContractDetails2.readDouble(in);
            this.YieldBasis = MsgContractDetails2.readInteger(in);
        }
        int nRelations = MsgContractDetails2.readIntBytes(in, 1);
        for (i = 0; i < nRelations; ++i) {
            String relExchangeID = MsgContractDetails2.readShortString(in);
            String relContractID = MsgContractDetails2.readShortString(in);
            NDateTime relStartDate = MsgContractDetails2.readDateTime(in);
            NDateTime relEndDate = MsgContractDetails2.readDateTime(in);
            ContractType relContractType = com.t4login.definitions.ContractType.get(MsgContractDetails2.readIntBytes(in, 1));
            int relPriority = MsgContractDetails2.readIntBytes(in, 1);
            this.Relations.add(new Relation(relExchangeID, relContractID, relStartDate, relEndDate, relContractType, relPriority, ""));
        }
        this.Currency = MsgContractDetails2.readShortString(in);
        this.Category = CategoryType.get(MsgContractDetails2.readIntBytes(in, 1));
        this.StrikeDetails = MsgContractDetails2.readShortString(in);
        this.ContractRef = MsgContractDetails2.readShortString(in);
        for (i = 0; i < nRelations; ++i) {
            this.Relations.get((int)i).details = MsgContractDetails2.readShortString(in);
        }
        if (ver > 6) {
            this.TradingSchedule = MsgContractDetails2.readString(in);
        }
        if (ver > 7) {
            this.ClearingCode = MsgContractDetails2.readShortString(in);
            this.ProductDescription = MsgContractDetails2.readShortString(in);
        }
        if (ver > 8) {
            this.MarginMaintToInit = MsgContractDetails2.readShortString(in);
            this.MarginVolScan = MsgContractDetails2.readShortString(in);
            this.MarginSOM = MsgContractDetails2.readShortString(in);
        }
        if (ver > 9) {
            this.MarginInitialSpec = MsgContractDetails2.readShortString(in);
            this.MarginMaintenanceSpec = MsgContractDetails2.readShortString(in);
            this.MarginInitialHedge = MsgContractDetails2.readShortString(in);
            this.MarginMaintenanceHedge = MsgContractDetails2.readShortString(in);
        }
        if (ver > 10) {
            this.DayChangeTimeAlt = MsgContractDetails2.readDateTime(in);
        }
        if (ver > 11) {
            this.FloorCode = MsgContractDetails2.readShortString(in);
        }
        if (ver > 12) {
            this.MaxDecimals = MsgContractDetails2.read7BitInteger(in);
        }
        if (ver > 13 && (details = Json.fromJson(detailsJson = MsgContractDetails2.readString(in), ContractDetails.class)) != null) {
            this.Details = details;
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        Relation rel;
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgContractDetails2.writeShortString(out, this.ExchangeID);
        MsgContractDetails2.writeShortString(out, this.ContractID);
        this.writeIntBytes(out, this.ContractType.getValue(), 1);
        MsgContractDetails2.writeShortString(out, this.Description);
        MsgContractDetails2.writeDateTime(out, this.DayChangeTime);
        MsgContractDetails2.writeShortString(out, this.DayChangeTimeExceptions);
        MsgContractDetails2.writeBooleanAlt(out, this.Disabled);
        this.writeIntBytes(out, this.YieldYears, 1);
        if (this.YieldYears > 0) {
            MsgContractDetails2.writeDouble(out, this.YieldParValue);
            MsgContractDetails2.writeDouble(out, this.YieldRate);
            MsgContractDetails2.writeInteger(out, this.YieldValueDenominator);
            MsgContractDetails2.writeDouble(out, this.YieldRedemption);
            MsgContractDetails2.writeDouble(out, this.YieldPaymentsPerYear);
            MsgContractDetails2.writeInteger(out, this.YieldBasis);
        }
        this.writeIntBytes(out, this.Relations.size(), 1);
        for (i = 0; i < this.Relations.size(); ++i) {
            rel = this.Relations.get(i);
            MsgContractDetails2.writeShortString(out, rel.exchangeID);
            MsgContractDetails2.writeShortString(out, rel.contractID);
            MsgContractDetails2.writeDateTime(out, rel.startDate);
            MsgContractDetails2.writeDateTime(out, rel.endDate);
            this.writeIntBytes(out, rel.contractType.getValue(), 1);
            this.writeIntBytes(out, rel.priority, 1);
        }
        MsgContractDetails2.writeShortString(out, this.Currency);
        this.writeIntBytes(out, this.Category.getValue(), 1);
        MsgContractDetails2.writeShortString(out, this.StrikeDetails);
        MsgContractDetails2.writeShortString(out, this.ContractRef);
        for (i = 0; i < this.Relations.size(); ++i) {
            rel = this.Relations.get(i);
            MsgContractDetails2.writeShortString(out, rel.details);
        }
        MsgContractDetails2.writeString(out, this.TradingSchedule);
        MsgContractDetails2.writeShortString(out, this.ClearingCode);
        MsgContractDetails2.writeShortString(out, this.ProductDescription);
        MsgContractDetails2.writeShortString(out, this.MarginMaintToInit);
        MsgContractDetails2.writeShortString(out, this.MarginVolScan);
        MsgContractDetails2.writeShortString(out, this.MarginSOM);
        MsgContractDetails2.writeShortString(out, this.MarginInitialSpec);
        MsgContractDetails2.writeShortString(out, this.MarginMaintenanceSpec);
        MsgContractDetails2.writeShortString(out, this.MarginInitialHedge);
        MsgContractDetails2.writeShortString(out, this.MarginMaintenanceHedge);
        MsgContractDetails2.writeDateTime(out, this.DayChangeTimeAlt);
        MsgContractDetails2.writeShortString(out, this.FloorCode);
        MsgContractDetails2.write7BitInteger(this.MaxDecimals, out);
        MsgContractDetails2.writeString(out, Json.toJson(this.Details));
        return out.toByteArray();
    }

    public String toString() {
        ArrayList<CallSite> parts = new ArrayList<CallSite>();
        parts.add((CallSite)((Object)("ExchangeID: " + this.ExchangeID)));
        parts.add((CallSite)((Object)("ContractID: " + this.ContractID)));
        parts.add((CallSite)((Object)("ContractType: " + String.valueOf(this.ContractType))));
        parts.add((CallSite)((Object)("Description: " + this.Description)));
        parts.add((CallSite)((Object)("Disabled: " + this.Disabled)));
        parts.add((CallSite)((Object)("Details: " + Json.toJson(this.Details))));
        String res = "MsgContractDetails2[" + TextUtils.join((CharSequence)", ", parts) + "]";
        return res;
    }

    public static class Relation {
        public String exchangeID;
        public String contractID;
        public NDateTime startDate;
        public NDateTime endDate;
        public ContractType contractType;
        public int priority;
        public String details;

        public Relation(String exchangeID, String contractID, NDateTime startDate, NDateTime endDate, ContractType contractType, int priority, String details) {
            this.exchangeID = exchangeID;
            this.contractID = contractID;
            this.startDate = startDate;
            this.endDate = endDate;
            this.contractType = contractType;
            this.priority = priority;
            this.details = details;
        }

        public String toString() {
            ArrayList<CallSite> parts = new ArrayList<CallSite>();
            parts.add((CallSite)((Object)("exchangeID: " + this.exchangeID)));
            parts.add((CallSite)((Object)("contractID: " + this.contractID)));
            parts.add((CallSite)((Object)("startDate: " + String.valueOf(this.startDate))));
            parts.add((CallSite)((Object)("endDate: " + String.valueOf(this.endDate))));
            parts.add((CallSite)((Object)("contractType: " + String.valueOf(this.contractType))));
            parts.add((CallSite)((Object)("priority: " + this.priority)));
            parts.add((CallSite)((Object)("details: " + this.details)));
            String res = "Relation[" + TextUtils.join((CharSequence)", ", parts) + "]";
            return res;
        }
    }
}

