/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.Log;
import com.t4login.messages.Message;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class MsgCompressed
extends Message {
    private static final String TAG = "T4Android.MsgCompressed";
    private static final int CHUNK_SIZE = 30000;
    public Message PackedMessage = null;

    public MsgCompressed() {
        super(MessageType.Compressed);
    }

    public MsgCompressed(Message msg) {
        super(MessageType.Compressed);
        this.PackedMessage = msg;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException {
        Short msgTypeVal = Message.readShort(in);
        MessageType msgType = MessageType.get(msgTypeVal.shortValue());
        short msgVer = MsgCompressed.readShort(in);
        int msgLen = MsgCompressed.readInteger(in);
        byte[] msgBuff = new byte[msgLen];
        byte[] chunkBuff = new byte[30000];
        int chunks = MsgCompressed.readShort(in);
        int byteOffset = 0;
        for (int i = 0; i < chunks; ++i) {
            int nbuffread;
            int compressedBytes = MsgCompressed.readInteger(in);
            for (int nbuff = 0; nbuff < compressedBytes; nbuff += nbuffread) {
                nbuffread = in.read(chunkBuff, nbuff, compressedBytes - nbuff);
                if (nbuffread != -1) continue;
                throw new IOException("MsgCompressed.parseMessageStream(), Unexpected end of stream.");
            }
            InflaterInputStream infis = new InflaterInputStream(new ByteArrayInputStream(chunkBuff));
            int len = 0;
            for (int nread = Math.min(msgLen - byteOffset, 30000); nread > 0 && (len = infis.read(msgBuff, byteOffset, nread)) != -1; nread -= len) {
                byteOffset += len;
            }
            infis.close();
        }
        if (msgType != null) {
            this.PackedMessage = Message.getMessage(msgType, msgVer, msgBuff);
        } else {
            Log.e(TAG, "Message type '" + msgTypeVal + "' not recognized.");
        }
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.PackedMessage != null) {
            byte[] msgBytes = this.PackedMessage.getBytes();
            MsgCompressed.writeShort(out, (short)this.PackedMessage.getMessageType().getValue());
            MsgCompressed.writeShort(out, this.PackedMessage.getMessageType().getVersion());
            MsgCompressed.writeInteger(out, msgBytes.length);
            int nchunks = msgBytes.length / 30000 + 1;
            MsgCompressed.writeShort(out, (short)nchunks);
            int byteOffset = 0;
            for (int i = 0; i < nchunks; ++i) {
                int len = Math.min(30000, msgBytes.length - byteOffset);
                if (len <= 0) continue;
                ByteArrayOutputStream out0 = new ByteArrayOutputStream();
                DeflaterOutputStream out1 = new DeflaterOutputStream(out0);
                out1.write(msgBytes, byteOffset, len);
                out1.flush();
                out1.close();
                out0.close();
                byteOffset += len;
                MsgCompressed.writeInteger(out, out0.size());
                out.write(out0.toByteArray());
            }
        }
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgCompressed[");
        if (this.PackedMessage != null) {
            sb.append("Message: ").append(this.PackedMessage);
        } else {
            sb.append("Message: <none>");
        }
        sb.append("]");
        return sb.toString();
    }
}

