/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.ChartDataRequestMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class MsgChartDataBatchRequest
extends Message
implements ChartDataRequestMessage {
    public String RequestID = "";
    public String ExchangeID = "";
    public String ContractID = "";
    public String MarketID = "";
    public NDateTime TradeDateStart = NDateTime.MinValue;
    public NDateTime TradeDateEnd = NDateTime.MinValue;
    public NDateTime SessionStartTime = NDateTime.MinValue;
    public NDateTime SessionEndTime = NDateTime.MinValue;
    public ChartDataType DataType;
    public ChartDataRequestApplication RequestingApplication;

    public MsgChartDataBatchRequest() {
        super(MessageType.ChartDataBatchRequest);
    }

    @Override
    public String getRequestID() {
        return this.RequestID;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        throw new MessageDecodingNotSupported(this.getMessageType());
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MsgChartDataBatchRequest.writeString(out, this.RequestID);
        MsgChartDataBatchRequest.writeString(out, this.ExchangeID);
        MsgChartDataBatchRequest.writeString(out, this.ContractID);
        MsgChartDataBatchRequest.writeString(out, this.MarketID);
        MsgChartDataBatchRequest.writeDateTime(out, this.TradeDateStart);
        MsgChartDataBatchRequest.writeDateTime(out, this.TradeDateEnd);
        MsgChartDataBatchRequest.writeDateTime(out, this.SessionStartTime);
        MsgChartDataBatchRequest.writeDateTime(out, this.SessionEndTime);
        this.writeIntBytes(out, this.DataType.getValue(), 4);
        this.writeIntBytes(out, this.RequestingApplication.getValue(), 1);
        MsgChartDataBatchRequest.writeString(out, this.RequestID);
        return out.toByteArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgChartDataBatchRequest[");
        sb.append("RequestID: ").append(this.RequestID).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.ContractID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("TradeDateStart: ").append(this.TradeDateStart.toDateString()).append(", ");
        sb.append("TradeDateEnd: ").append(this.TradeDateEnd.toDateString()).append(", ");
        sb.append("SessionStartTime: ").append(this.TradeDateEnd.toShortTimeString()).append(", ");
        sb.append("SessionEndTime: ").append(this.TradeDateEnd.toShortTimeString()).append(", ");
        sb.append("DataType: ").append(this.DataType).append(", ");
        sb.append("RequestingApplication: ").append(this.RequestingApplication);
        sb.append("]");
        return sb.toString();
    }
}

