/*
 * Decompiled with CFR 0.152.
 */
package com.t4login.messages;

import com.t4login.datetime.NDateTime;
import com.t4login.definitions.ChartDataFormat;
import com.t4login.definitions.ChartDataRequestApplication;
import com.t4login.definitions.ChartRequestStatus;
import com.t4login.definitions.chartdata.ChartDataType;
import com.t4login.messages.ChartDataResponseMessage;
import com.t4login.messages.Message;
import com.t4login.messages.MessageDecodingNotSupported;
import com.t4login.messages.MessageEncodingNotSupported;
import com.t4login.messages.MessageType;
import com.t4login.messages.MessageVersionNotSupportedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MsgChartDataBatch
extends Message
implements ChartDataResponseMessage {
    public String RequestID;
    public ChartRequestStatus Status;
    public int ChartDataResponseFlags;
    public boolean NoCache = false;
    public String ExchangeID;
    public String ContractID;
    public String MarketID;
    public NDateTime TradeDateStart;
    public NDateTime TradeDateEnd;
    public NDateTime SessoinStartTime;
    public NDateTime SessionEndTime;
    public ChartDataType DataType;
    public NDateTime LastTradeTime;
    public ChartDataRequestApplication RequestingApplication;
    public List<MarketData> BatchData = new ArrayList<MarketData>();
    public NDateTime CacheGenerationDate = NDateTime.MinValue;

    public MsgChartDataBatch() {
        super(MessageType.ChartDataBatch);
    }

    @Override
    public String getRequestID() {
        return this.RequestID;
    }

    @Override
    protected void parseMessageStream(short ver, InputStream in) throws IOException, MessageVersionNotSupportedException, MessageDecodingNotSupported {
        int i;
        if (ver < this.getMessageType().getMinSupportedVersion()) {
            throw new MessageVersionNotSupportedException(this.getMessageType(), ver, this.getMessageType().getMinSupportedVersion());
        }
        this.RequestID = MsgChartDataBatch.readShortString(in);
        this.Status = ChartRequestStatus.get(MsgChartDataBatch.readIntBytes(in, 4));
        this.ExchangeID = MsgChartDataBatch.readShortString(in);
        this.ContractID = MsgChartDataBatch.readShortString(in);
        this.MarketID = MsgChartDataBatch.readShortString(in);
        this.TradeDateStart = MsgChartDataBatch.readDateTime(in);
        this.TradeDateEnd = MsgChartDataBatch.readDateTime(in);
        this.SessoinStartTime = MsgChartDataBatch.readDateTime(in);
        this.SessionEndTime = MsgChartDataBatch.readDateTime(in);
        this.DataType = ChartDataType.get(MsgChartDataBatch.readIntBytes(in, 4));
        this.LastTradeTime = MsgChartDataBatch.readDateTime(in);
        int nBatch = MsgChartDataBatch.readInteger(in);
        for (i = 0; i < nBatch; ++i) {
            MarketData mkt = new MarketData();
            mkt.MarketID = MsgChartDataBatch.readShortString(in);
            mkt.TradeDate = MsgChartDataBatch.readDateTime(in);
            mkt.DataFormat = ChartDataFormat.get(MsgChartDataBatch.readIntBytes(in, 4));
            mkt.StringData = MsgChartDataBatch.readString(in);
            this.BatchData.add(mkt);
        }
        this.ChartDataResponseFlags = MsgChartDataBatch.readIntBytes(in, 4);
        if ((this.ChartDataResponseFlags & 1) != 0) {
            this.NoCache = true;
        }
        for (i = 0; i < nBatch; ++i) {
            this.BatchData.get((int)i).TTV = MsgChartDataBatch.readIntBytes(in, 4);
        }
        for (i = 0; i < nBatch; ++i) {
            int dataLen = MsgChartDataBatch.readIntBytes(in, 4);
            if (dataLen > 0) {
                this.BatchData.get((int)i).BinData = new byte[dataLen];
                MsgChartDataBatch.fillBuffer(in, this.BatchData.get((int)i).BinData);
                continue;
            }
            this.BatchData.get((int)i).BinData = new byte[0];
        }
        this.RequestingApplication = ChartDataRequestApplication.get(MsgChartDataBatch.readIntBytes(in, 1));
    }

    @Override
    protected byte[] buildMessageBytes() throws IOException, MessageEncodingNotSupported {
        throw new MessageEncodingNotSupported(this.getMessageType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MsgChartContractData[");
        sb.append("RequestID: ").append(this.RequestID).append(", ");
        sb.append("Status: ").append(this.Status).append(", ");
        sb.append("ChartDataResponseFlags: ").append(this.ChartDataResponseFlags).append(", ");
        sb.append("ExchangeID: ").append(this.ExchangeID).append(", ");
        sb.append("ContractID: ").append(this.ContractID).append(", ");
        sb.append("MarketID: ").append(this.MarketID).append(", ");
        sb.append("TradeDateStart: ").append(this.TradeDateStart.toDateString()).append(", ");
        sb.append("TradeDateEnd: ").append(this.TradeDateEnd.toDateString()).append(", ");
        sb.append("SessionStartTime: ").append(this.SessoinStartTime.toShortTimeString()).append(", ");
        sb.append("SessionEndTime: ").append(this.SessionEndTime.toShortTimeString()).append(", ");
        sb.append("DataType: ").append(this.DataType).append(", ");
        sb.append("LastTradeTime: ").append(this.LastTradeTime.toString()).append(", ");
        sb.append("Batch Count: ").append(this.BatchData.size());
        sb.append("CacheGenerationDate: ").append(this.CacheGenerationDate);
        sb.append("]");
        return sb.toString();
    }

    public static final class MarketData {
        public String MarketID;
        public NDateTime TradeDate;
        public ChartDataFormat DataFormat;
        public int TTV;
        public String StringData;
        public byte[] BinData;
    }
}

